#include <stdlib.h>
#include <iostream.h>
#include <time.h> 

int randomize(int maxvalue, int search, int cubes){
	for (int numcube=0;numcube<cubes;numcube++){
		if ((rand()%maxvalue+1) != search){
			return 0;
		}
	}	
	return 1;
}
void runsim(int maxvalue, int search, int sims, int turns, int cubes){
	int loop[] = {50, 100, 200, 500, 1000};
	int win = 0;
	int wins=0;
	int numwins[sims];
	float average = 0.0;
	float paverage = 0.0;
	float s = 0.0;
	float sum = 0.0;
	float probability = 0.0;
	
	for (int numsim=0;numsim<sizeof(loop)/sizeof(loop[0]);numsim++){
		srand(time(NULL));
		for (int numsims=0;numsims<sims;numsims++){
			for (int numloop=0;numloop<loop[numsim];numloop++){
				for(int numturn=0;numturn<turns;numturn++){
					if (randomize(maxvalue, search, cubes) == 1)
						win=1;
				}
				if (win==1)
					wins++;
				win=0;
			}
			numwins[numsims]=wins;
			cout <<"Schleifen: "<<loop[numsim]<<" Simulatinoslauf: "<<numsims+1<<" Gewonnen Spiele: "<<wins<<'\n';
			wins=0;
		}	

		for (int value=0;value<sims;value++){
			sum=sum+numwins[value];
		}
		average = (1.0 / sims)*sum;
		cout <<"Mittelwert: "<<average<<'\n';
		
		sum = 0.0;
		for (int value=0;value<sims;value++){
			sum=sum+((numwins[value]-average)*(numwins[value]-average));
		}
		paverage = (1.0/(sims-1))*sum;
		s = sqrt(paverage);
		cout <<"Standardabweichung: "<<s<<'\n';
		sum = 0.0;
		probability = average/loop[numsim];
		cout <<"Wahrscheinlichkeit: "<<probability<<'\n'<<'\n';
	}
}

int main(){
	cout <<"Markus Kberl		0130163"<<'\n'<<"Susanne Schberl	0130374"<<'\n'<<'\n'<<'\n';
	cout <<"Game 1: 4 Wrfe, 1 Wrfel"<<'\n'<<'\n';
	runsim(6,6,8,4,1);
	cout <<'\n'<<'\n'<<"Game 2: 24 Wrfe, 2 Wrfel"<<'\n'<<'\n';
	runsim(6,6,8,24,2);
	
	return 0;
}
