#include <stdlib.h>
#include <iostream.h>
#include <time.h> 

int randomize(int maxvalue, int turn){
	int value[maxvalue];
	for (int numturn=0;numturn<turn;numturn++){
		{
			value[numturn] = rand()%maxvalue+1;
			for (int numloop=0;numloop<numturn;numloop++)
			{
				if (value[numloop]==value[numturn])
					return 0;
			}
		}
	}	
	return 1;
}

void runsim(int maxvalue, int sims, int turns){
	int loop[] = {250, 500, 1000, 2000};
	int wins=0;
	int numwins[sims];
	float average = 0.0;
	float paverage = 0.0;
	float s = 0.0;
	float sum = 0.0;
	float probability = 0.0;
	
	for (int numsim=0;numsim<sizeof(loop)/sizeof(loop[0]);numsim++){
		srand(time(NULL));
		for (int numsims=0;numsims<sims;numsims++){
			for (int numloop=0;numloop<loop[numsim];numloop++){
				if (randomize(maxvalue, turns)==1)
					wins++;				
			}
			numwins[numsims]=wins;
			cout <<"Schleifen: "<<loop[numsim]<<" Simulatinoslauf: "<<numsims+1<<" ohne Kollision: "<<wins<<'\n';
			wins=0;
		}	

		for (int value=0;value<sims;value++){
			sum=sum+numwins[value];
		}
		average = (1.0 / sims)*sum;
		cout <<"Mittelwert: "<<average<<'\n';
		
		sum = 0.0;
		for (int value=0;value<sims;value++){
			sum=sum+((numwins[value]-average)*(numwins[value]-average));
		}
		paverage = (1.0/(sims-1))*sum;
		s = sqrt(paverage);
		cout <<"Standardabweichung: "<<s<<'\n';
		sum = 0.0;
		probability = average/loop[numsim];
		cout <<"Wahrscheinlichkeit: "<<probability<<'\n'<<'\n';
	}
}

int main(){
	cout <<"Markus Kberl		0130163"<<'\n'<<"Susanne Schberl	0130374"<<'\n'<<'\n'<<'\n';
	cout <<"1. Szenario n=1024 und r=37"<<'\n'<<'\n';
	
	runsim(1024,8,37); //maxvalue, sims, turns
	cout <<'\n'<<'\n'<<"2. Szenario n=1024 und r=10"<<'\n'<<'\n';
	runsim(1024,8,10); //maxvalue, sims, turns
	
	return 0;
}
