#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

double pi = 3.1415926535;

double zufalls_zahl();
double berechnung_sm(int m, double *feld);
void durchlauf_versuch_1();
void durchlauf_versuch_2();

int main()
{
  srand((unsigned)time(NULL));
  // zufallsgenerator gesetzt

  printf("\n\n\nErwartetes Ergebnis: pi/4 (ca. %f )\n\n\n",pi/4.0);
  printf("Aufgabenstellung 1:\n\n");
  durchlauf_versuch_1();
  printf("\n\n\n\n");
  printf("Aufgabenstellung 2:\n\n\n");
  durchlauf_versuch_2();
  return(0);
}

void durchlauf_versuch_1()
{
  int zaehler = 0;
  int max_umfang = 2000;
  double *feld = new double[max_umfang];
  double ergebnis = 0.0;

  for(zaehler = 0; zaehler < max_umfang; zaehler++)
    feld[zaehler] = zufalls_zahl();
  printf("Zufallsvektoren *   Ergebnis fuer Sm\n");
  printf("*********************************\n");
  ergebnis = berechnung_sm(100, feld);
  printf("100             *     %f\n", ergebnis);
  ergebnis = berechnung_sm(200, feld);
  printf("200             *     %f\n", ergebnis);
  ergebnis = berechnung_sm(500, feld);
  printf("500             *     %f\n", ergebnis);
  ergebnis = berechnung_sm(1000, feld);
  printf("1000            *     %f\n", ergebnis);
  
  delete[](feld);
}

void durchlauf_versuch_2()
{
  double ergebnis = 0.0;
  int max_umfang = 1500;
  double *feld = new double[max_umfang];
  int zaehler = 0;
  int durchlauf = 0;
  
  printf("Experiment Nr.: * m=100        * m=200        * m=500        * m=1000\n");
  printf("******************************************************************************\n");

  for(durchlauf = 1; durchlauf <= 10; durchlauf++)
  {
    for(zaehler = 0; zaehler < max_umfang; zaehler++)
      feld[zaehler] = zufalls_zahl();

    printf("    %2d          * ", durchlauf);
  
    ergebnis = berechnung_sm(100, feld);
    printf("%f     * ", ergebnis);

    ergebnis = berechnung_sm(200, feld);
    printf("%f     * ", ergebnis);

    ergebnis = berechnung_sm(500, feld);
    printf("%f     * ", ergebnis);

    ergebnis = berechnung_sm(1000, feld);
    printf("%f\n", ergebnis);
  }

  delete[](feld);
}

double zufalls_zahl()
{
  int random_int = rand() % 1001;
  double random_double = 0.0;

  random_double = (double)random_int * pow(10, -3);

  return random_double;
}


double berechnung_sm(int anz_zufallsvekt, double *feld)
{
  int zaehler = 0;
  int ergebnis = 0;
  double sm = 0.0;

  for(zaehler = 0; zaehler < anz_zufallsvekt; zaehler++)
  {
    double x = feld[zaehler * 2];
    double y = feld[(zaehler * 2) + 1];

    if((pow(x, 2.0) + pow(y, 2.0)) < 1.0)
      ergebnis = ergebnis+1;
  }

  sm = (double)ergebnis / (double)anz_zufallsvekt;

  return sm;
}
