package gui;
/*Copyright 2004-2005 Univ.Prof. Dipl.-Ing. Dr.techn. Wolfgang SLANY,
Andreas Augustin, Sandra Durasiewicz, Bojan Hrnkas, Markus Köberl,
Bernhard Kornberger, Susanne Schöberl

This file is part of Neptune-Robot-Simulation.

Neptune-Robot-Simulation is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Neptune-Robot-Simulation is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Neptune-Robot-Simulation; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  US
*/
import java.util.HashMap;
import javax.swing.ImageIcon;
import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URL;

public class BrickImages
{
	
private HashMap brick_images_;
private String image_folder_;
private URL code_base_;
public BrickImages(URL code_base)
{
	code_base_=code_base;
}
private Image loadImage(String name) {
        ImageIcon icon = null;
        if (image_folder_ == null)
            image_folder_ = "";
        try {
            icon = new ImageIcon(new URL(code_base_, image_folder_ + "/"
                    + name));
            return icon.getImage();
        } catch (MalformedURLException e) {
            System.out.println("Failed to create URL:\n" + e);
            return null;
        }
    }

private ImageIcon loadIcon(String name) {
        ImageIcon icon = null;
        if (image_folder_ == null)
            image_folder_ = "";
        try {
            icon = new ImageIcon(new URL(code_base_, image_folder_ + "/"
                    + name));
            return icon;
        } catch (MalformedURLException e) {
            System.out.println("Failed to create URL:\n" + e);
            return null;
        }
    }

    /**
     * This method is called from within the init() method to initialize the
     * form. WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
public HashMap loadImages() 
   {
        brick_images_ = new HashMap();
        // load the images which are display at the brick_rules panel
        image_folder_ = "Images";
        brick_images_.put("CONDITION_DEFAULT", loadImage("images.jpg"));
        brick_images_.put("CONDITION_HOVER", loadImage("images1.jpg"));
        brick_images_.put("ACTION_DEFAULT", loadImage("images2.jpg"));
        brick_images_.put("ACTION_HOVER", loadImage("images3.jpg"));
        brick_images_.put("ARROW_UP", loadImage("arrow_up.gif"));
        brick_images_.put("ARROW_DOWN", loadImage("arrow_down.gif"));
        brick_images_.put("ARROW_LEFT", loadImage("arrow_left.gif"));
        brick_images_.put("ARROW_RIGHT", loadImage("arrow_right.gif"));
        brick_images_.put("FREE_GROUND", loadImage("free_ground.gif"));
        brick_images_.put("WALL_GROUND", loadImage("wall_ground.gif"));

        brick_images_.put("EMPTY_FLOOR", loadImage("floor_empty.gif"));
        brick_images_.put("FLOOR_0", loadImage("floor_0.gif"));
        brick_images_.put("FLOOR_1", loadImage("floor_1.gif"));
        brick_images_.put("FLOOR_2", loadImage("floor_2.gif"));
        brick_images_.put("FLOOR_3", loadImage("floor_3.gif"));
        brick_images_.put("FLOOR_4", loadImage("floor_4.gif"));
        brick_images_.put("X_BUTTON", loadIcon("x_button.gif"));

        brick_images_.put("COND_NONE", loadImage("cond_none.gif"));
        brick_images_.put("COND_GREEN", loadImage("cond_green.gif"));
        brick_images_.put("COND_BLUE", loadImage("cond_blue.gif"));
        brick_images_.put("COND_RED", loadImage("cond_red.gif"));
        brick_images_.put("COND_YELLOW", loadImage("cond_yellow.gif"));
        brick_images_.put("COND_GRAY", loadImage("cond_gray.gif"));

        brick_images_.put("COND_NONE_1", loadImage("cond_none_1.gif"));
        brick_images_.put("COND_GREEN_1", loadImage("cond_green_1.gif"));
        brick_images_.put("COND_BLUE_1", loadImage("cond_blue_1.gif"));
        brick_images_.put("COND_RED_1", loadImage("cond_red_1.gif"));
        brick_images_.put("COND_YELLOW_1", loadImage("cond_yellow_1.gif"));
        brick_images_.put("COND_GRAY_1", loadImage("cond_gray_1.gif"));

        brick_images_.put("LAB_WAY", loadImage("way_3.jpg"));
        brick_images_.put("LAB_WALL", loadImage("way_2.jpg"));

        brick_images_
                .put("LAB_ROBOT_BLANK_UP", loadImage("robot_blank_up.gif"));
        brick_images_.put("LAB_ROBOT_BLANK_RIGHT",
                loadImage("robot_blank_right.gif"));
        brick_images_.put("LAB_ROBOT_BLANK_DOWN",
                loadImage("robot_blank_down.gif"));
        brick_images_.put("LAB_ROBOT_BLANK_LEFT",
                loadImage("robot_blank_left.gif"));

        brick_images_.put("LAB_ROBOT_BLUE_UP", loadImage("robot_blue_up.gif"));
        brick_images_.put("LAB_ROBOT_BLUE_RIGHT",
                loadImage("robot_blue_right.gif"));
        brick_images_.put("LAB_ROBOT_BLUE_DOWN",
                loadImage("robot_blue_down.gif"));
        brick_images_.put("LAB_ROBOT_BLUE_LEFT",
                loadImage("robot_blue_left.gif"));

        brick_images_
                .put("LAB_ROBOT_GREEN_UP", loadImage("robot_green_up.gif"));
        brick_images_.put("LAB_ROBOT_GREEN_RIGHT",
                loadImage("robot_green_right.gif"));
        brick_images_.put("LAB_ROBOT_GREEN_DOWN",
                loadImage("robot_green_down.gif"));
        brick_images_.put("LAB_ROBOT_GREEN_LEFT",
                loadImage("robot_green_left.gif"));

        brick_images_.put("LAB_ROBOT_RED_UP", loadImage("robot_red_up.gif"));
        brick_images_.put("LAB_ROBOT_RED_RIGHT",
                loadImage("robot_red_right.gif"));
        brick_images_.put("LAB_ROBOT_RED_DOWN",
                loadImage("robot_red_down.gif"));
        brick_images_.put("LAB_ROBOT_RED_LEFT",
                loadImage("robot_red_left.gif"));

        brick_images_.put("LAB_ROBOT_YELLOW_UP", loadImage("robot_yellow_up.gif"));
        brick_images_.put("LAB_ROBOT_YELLOW_RIGHT",
                loadImage("robot_yellow_right.gif"));
        brick_images_.put("LAB_ROBOT_YELLOW_DOWN",
                loadImage("robot_yellow_down.gif"));
        brick_images_.put("LAB_ROBOT_YELLOW_LEFT",
                loadImage("robot_yellow_left.gif"));

        brick_images_.put("LAB_ROBOT_GRAY_UP", loadImage("robot_gray_up.gif"));
        brick_images_.put("LAB_ROBOT_GRAY_RIGHT", loadImage("robot_gray_right.gif"));
        brick_images_.put("LAB_ROBOT_GRAY_DOWN", loadImage("robot_gray_down.gif"));
        brick_images_.put("LAB_ROBOT_GRAY_LEFT", loadImage("robot_gray_left.gif"));

        brick_images_.put("LAB_CELLMARK0", loadImage("lab_cellmark0.gif"));
        brick_images_.put("LAB_CELLMARK1", loadImage("lab_cellmark1.gif"));
        brick_images_.put("LAB_CELLMARK2", loadImage("lab_cellmark2.gif"));
        brick_images_.put("LAB_CELLMARK3", loadImage("lab_cellmark3.gif"));
        brick_images_.put("LAB_CELLMARK", loadImage("lab_cellmark.gif"));

        brick_images_.put("LAB_DIAMOND", loadImage("diamond.gif"));
        
        return brick_images_;

    }
}