package PrintLabyrinth;
//----------------------------------------------------------------------
/**
 * class representing a two dimensional labyrinth
 */

public class LabyrinthField extends Field
{
      /** the number of diamonds distributed in the field (set from
       * outside of the class with the appropriate method-calls */
  protected int num_diamonds_;

      /** the number of way cells distributed in the field (set from
       * outside of the class with the appropriate method-calls */
  protected int num_way_cells_;

      /** the number of none way cells e.g.way cells (set from
       * outside of the class with the appropriate method-calls */
  protected int num_wall_cells_;

//----------------------------------------------------------------------
/**
 * Standard constructor
 * @param rows the number of rows of this labyrinth
 * @param cols the number of columns of this labyrinth
 * @exception IllegalArgumentException thrown if either rows or cols
 * is < 0
 */

  public LabyrinthField(int rows,int cols)
    throws IllegalArgumentException
  {
    super(rows, cols);

    for (int row = 0; row < rows; row++)
    {
      for (int col = 0; col < cols; col++)
      {
        field_[row][col] = new Cell();
        Cell cell = (Cell)field_[row][col];
        cell.convertToWall();
      }
    }
    num_wall_cells_ = rows * cols;
  }

//----------------------------------------------------------------------
/**
 * package-internal method called from the outside to set the number
 * of diamonds distributed in this labyrinthfield. It is not checked, whether
 * this number exceeds the maximum allowed number. This has to be done
 * beforehand.
 * @exception IllegalArgumentException thrown if the number of mines
 * is < 0
 */

  void setNumDiamonds(int num_diamonds)
    throws IllegalArgumentException
  {
    if (num_diamonds < 0)
      throw(new IllegalArgumentException(
              "num_diamonds must be >= 0"));
    num_diamonds_ = num_diamonds;
  }

//----------------------------------------------------------------------
/**
 * package-internal method called from the outside to set the number
 * of way cells distributed in this labyrinthfield. It is not checked, whether
 * this number exceeds the maximum allowed number. This has to be done
 * beforehand.
 * @exception IllegalArgumentException thrown if the number of way cells
 * is < 0
 */

  void setNumWayCells(int num_way_cells)
    throws IllegalArgumentException
  {
    if (num_way_cells < 0)
      throw(new IllegalArgumentException(
              "num_way_cells must be >= 0"));
    num_way_cells_ = num_way_cells;
  }

//----------------------------------------------------------------------
/**
 * package-internal method to decrement the counter for the number of
 * cells that are a Wall
 */

  void decrementNumWallCells()
  {
    num_wall_cells_--;
  }

//----------------------------------------------------------------------
/**
 * package-internal method that returns if all diamonds were found
 * according to the internal counters
 */

  boolean wereAllDiamondsFound()
  {
    return(num_diamonds_ == 0);
  }

//------------------------------------------------------------
/**
 * standard toString method for debugging
 * @return info about the labyrinth field in string-format
 */

  public String toString()
  {
    return("Labyrinthfield: num_diamonds_ = " + num_diamonds_ +
           ", num_way_cells_ = " + num_way_cells_ +
           ", num_wall_cells_ = " + num_wall_cells_ +
           super.toString());
  }

}
