//package PrintLabyrinth;

import java.awt.*;
import java.applet.*;
import java.net.*;
import PrintLabyrinth.*;
import PrintLabyrinth.Robot;
//----------------------------------------------------------------------
/**
 * class to display the labyrinth
 */

public class PrintLabyrinth extends Applet
{
  protected final static String directory_ = "F:\\work\\PrintLabyrinth\\";
  //HEIGHT and WHITH of a labyrinth cell
  protected final static int CELL_HEIGHT = 20;
  protected final static int CELL_WHITH = 20;

  //number of cells in a row and a col
  protected final static int ROWS = 20;
  protected final static int COLS = 20;

  //sice of the labyrinth
  protected final static int LABYRINTH_HEIGHT = ROWS * CELL_HEIGHT;
  protected final static int LABYRINTH_WHITH = COLS * CELL_WHITH;

  protected static LabyrinthField labyrinth_field_;
  protected static Cell cell_;
  protected static CreateLabyrinth create_labyrinth_;
  protected static LoadLabyrinth load_labyrinth_;
  protected static Robot robot_;

  Image way, wall, robot, diamond;


  // Um das Labyrinth zu laden
  public static void main(String[] args)
  {
  int hposition, vposition, cols_counter, rows_counter;
  hposition=0;
  vposition=0;
  cols_counter=0;
  rows_counter=0;

  load_labyrinth_ = new LoadLabyrinth(directory_ + "Labyrinthaufbau.xml");
    

      labyrinth_field_=load_labyrinth_.getLabyrinthField();

      while(rows_counter<labyrinth_field_.getNumRows())
      {
        while(cols_counter<labyrinth_field_.getNumCols())
        {
          cell_=(Cell)labyrinth_field_.getElement(rows_counter,cols_counter);

          if(cell_.isWall()==true)
            System.out.print(load_labyrinth_.getWallSymbol());
          if(cell_.isWay()==true)
          {
            if(cell_.isStartpoint()==true)
              System.out.print(load_labyrinth_.getStartSymbol());
            else
            {
              if(cell_.containsDiamond()==true)
                System.out.print(load_labyrinth_.getDiamondSymbol());
              else
              {
                System.out.print(load_labyrinth_.getGallerySymbol());
              }
            }
          }
          if(cols_counter==labyrinth_field_.getNumCols()-1)
            System.out.print("\n");

         cols_counter=cols_counter+1;
         hposition=hposition+CELL_WHITH;
        }
        rows_counter=rows_counter+1;
        vposition=vposition+CELL_HEIGHT;
        hposition=0;
        cols_counter=0;
      }

  }
  
  // um das Labyrinth zu laden
  public void init()
  {
    setSize(LABYRINTH_HEIGHT,LABYRINTH_WHITH);

    way = getImage( getDocumentBase(), "PrintLabyrinth/way_3.jpg" );
    wall = getImage( getDocumentBase(), "PrintLabyrinth/way_2.jpg" );
    robot = getImage( getDocumentBase(), "PrintLabyrinth/ball.gif" );
    diamond = getImage( getDocumentBase(), "PrintLabyrinth/diamond.gif" );

     load_labyrinth_ = new LoadLabyrinth(directory_ + "Labyrinthaufbau.xml");
//    try
    {
      labyrinth_field_=load_labyrinth_.getLabyrinthField();      
      robot_ = new Robot();
      robot_.setPos(load_labyrinth_.getStartpointRow(), load_labyrinth_.getStartpointCol());
    }
//    catch(IllegalDirectionException ex)
    {
      
    }
  }

 
/*  
  // Um das Labyrinth zufllig zu generieren  
  public static void main(String[] args)
  {
  int hposition, vposition, cols_counter, rows_counter;
  hposition=0;
  vposition=0;
  cols_counter=0;
  rows_counter=0;

    create_labyrinth_ = new CreateLabyrinth(ROWS,COLS);
    try
    {
      create_labyrinth_.calculateWays();
      create_labyrinth_.setDiamonds();
      labyrinth_field_=create_labyrinth_.getLabyrinthField();

      while(rows_counter<ROWS)
      {
        while(cols_counter<COLS)
        {
          cell_=(Cell)labyrinth_field_.getElement(rows_counter,cols_counter);

          if(cell_.isWall()==true)
            System.out.print("W");
          if(cell_.isWay()==true)
          {
            if(cell_.isStartpoint()==true)
              System.out.print("S");
            else
            {
              if(cell_.containsDiamond()==true)
                System.out.print("*");
              else
              {
                System.out.print(" ");
              }
            }
          }
          if(cols_counter==COLS-1)
            System.out.print("\n");

         cols_counter=cols_counter+1;
         hposition=hposition+CELL_WHITH;
        }
        rows_counter=rows_counter+1;
        vposition=vposition+CELL_HEIGHT;
        hposition=0;
        cols_counter=0;
      }
    }
    catch(IllegalDirectionException ex)
    {
    
    }
  }

  
//     Um das Labyrinth zufllig zu generieren  
  public void init()
  {
    setSize(LABYRINTH_HEIGHT,LABYRINTH_WHITH);

    way = getImage( getDocumentBase(), "PrintLabyrinth/way_3.jpg" );
    wall = getImage( getDocumentBase(), "PrintLabyrinth/way_2.jpg" );
    robot = getImage( getDocumentBase(), "PrintLabyrinth/ball.gif" );
    diamond = getImage( getDocumentBase(), "PrintLabyrinth/diamond.gif" );
    create_labyrinth_ = new CreateLabyrinth(ROWS,COLS);


    try
    {
      create_labyrinth_.calculateWays();
      create_labyrinth_.setDiamonds();
      labyrinth_field_=create_labyrinth_.getLabyrinthField();
            
      robot_ = new Robot();
      robot_.setPos(create_labyrinth_.getStartpointRow(), create_labyrinth_.getStartpointCol());
    }
    catch(IllegalDirectionException ex)
    {
      
    }
  }
*/
  
  public void paint(Graphics g)
  {
    update(g);
  }

public void update(Graphics g)
  {
    paintFrame(g);
  }

public void start()
{
  Direction direction = new Direction();
  try
  {
    direction.setDirection(Direction.DIRECTION_UP);
    robot_.moveInDirection(direction);
  }
  catch(IllegalDirectionException ex)
  {
    
  }
}

  public void paintFrame(Graphics g)
  {
    int hposition, vposition, cols_counter, rows_counter;
    hposition=0;
    vposition=0;
    cols_counter=0;
    rows_counter=0;
    
    while(rows_counter<labyrinth_field_.getNumRows())
      {
        while(cols_counter<labyrinth_field_.getNumCols())
        {
          	cell_=(Cell)labyrinth_field_.getElement(rows_counter,cols_counter);

          if(cell_.isWay()==true)
          {
              g.drawImage(way, hposition, vposition, this);
              if(cell_.containsDiamond()==true)
                g.drawImage(diamond, hposition, vposition, this);
          }
          else
            g.drawImage(wall, hposition, vposition, this);

          cols_counter=cols_counter+1;
          hposition=hposition+CELL_WHITH;
        }
        rows_counter=rows_counter+1;
        vposition=vposition+CELL_HEIGHT;
        hposition=0;
        cols_counter=0;
      }
      
      int robot_vposition = robot_.getPosRow() * CELL_HEIGHT;
      int robot_hposition = robot_.getPosCol() * CELL_WHITH;
      
      if(robot_vposition >= 0 && robot_hposition >=0)
      g.drawImage(robot, robot_hposition, robot_vposition, this);
      
  }

}
