package PrintLabyrinth;
//import java.applet.*;
//------------------------------------------------------------
/**
 *  A cell that is used in the labyrinth
 */

public class Cell
{
      /** status flags */
  protected final static int WALL =               0x00000001;
  protected final static int WAY =                0x00000002;
  protected final static int STARTPOINT =         0x00000004;
  protected final static int CONTAINS_DIAMOND =   0x00000008;
      /** member variable to store the flags in */
  protected int status_;

//------------------------------------------------------------
/**
 * find out whether the cell is a wall
 * @return true if the cell is a wall, false otherwise
 */

  public void Cell()
  {
    status_ = WALL;
  }

//------------------------------------------------------------
/**
 * find out whether the cell is a wall
 * @return true if the cell is a wall, false otherwise
 */

  public boolean isWall()
  {
    return((status_ & WALL) != 0);
  }

//------------------------------------------------------------
/**
 * covert a way or a empty cell to wall
 * @exception IllegalStateException thrown if the cell is allready
 * a wall, the cell contains a diamond or a robot.
 */

  public void convertToWall()
    throws IllegalStateException
  {
    if ((status_ & WALL) != 0)
      throw(new IllegalStateException(
              "can't convert to a wall, cell is already a wall"));
    if ((status_ & CONTAINS_DIAMOND) != 0)
        throw(new IllegalStateException(
              "can't convert to a wall, cell contains a diamond"));
    if ((status_ & WAY) != 0)
      status_ &= ~WAY;
    status_ |= WALL;
  }

//------------------------------------------------------------
/**
 * find out whether the cell is a way
 * @return true if the cell is a way, false otherwise
 */

  public boolean isWay()
  {
    return((status_ & WAY) != 0);
  }

//------------------------------------------------------------
/**
 * covert a cell to a way
 * @exception IllegalStateException thrown if the cell is allready
 * a way.
 */

  public void convertToWay()
    throws IllegalStateException
  {
    if ((status_ & WAY) != 0)
      throw(new IllegalStateException(
              "can't convert to a way, cell is already a way"));
    if ((status_ & WALL) != 0)
      status_ &= ~WALL;
    status_ |= WAY;
  }

//------------------------------------------------------------
/**
 * find out whether the cell is a startpoint
 * @return true if the cell is a startpoint, false otherwise
 */

  public boolean isStartpoint()
  {
    return((status_ & STARTPOINT) != 0);
  }

//------------------------------------------------------------
/**
 * covert a cell to a startpoint
 * @exception IllegalStateException thrown if the cell is allready
 * a startpoint.
 */

  public void convertToStartpoint()
    throws IllegalStateException
  {
    if ((status_ & STARTPOINT) != 0)
      throw(new IllegalStateException(
              "can't convert to a startpoint, cell is already a startpoint"));
    if ((status_ & WALL) != 0)
  {
    status_ &= ~WALL;
    status_ |= WAY;
  }
  status_ |= STARTPOINT;
  }

//------------------------------------------------------------
/**
 * remove a startpoint
 * @exception IllegalStateException thrown when trying to remove a
 * startpoint form a cell that doesn't contain a startpoint
 */

  public void removeSartpoint()
    throws IllegalStateException
  {
    if ((status_ & STARTPOINT) == 0)
      throw(new IllegalStateException(
              "can't remove a startpoint, cell doesn't contain a startpoint"));
    status_ &= ~STARTPOINT;
  }

//------------------------------------------------------------
/**
 * find out whether the cell contains a diamand
 * @return true if the cell contains a diamand, false otherwise
 */

  public boolean containsDiamond()
  {
    return((status_ & CONTAINS_DIAMOND) != 0);
  }

//------------------------------------------------------------
/**
 * set a diamand
 * @exception IllegalStateException thrown when trying to place a
 * diamond in a cell that already contains a diamond
 */

  public void setDiamond()
    throws IllegalStateException
  {
    if ((status_ & CONTAINS_DIAMOND) != 0)
      throw(new IllegalStateException(
              "can't set a diamond, cell contains already a diamond"));
    status_ |= CONTAINS_DIAMOND;
  }

//------------------------------------------------------------
/**
 * remove a diamond
 * @exception IllegalStateException thrown when trying to remove a
 * diamond form a cell that doesn't contain a diamond
 */

  public void removeDiamond()
    throws IllegalStateException
  {
    if ((status_ & CONTAINS_DIAMOND) == 0)
      throw(new IllegalStateException(
              "can't remove a diamond, cell doesn't contain a diamond"));
    status_ &= ~CONTAINS_DIAMOND;
  }

//------------------------------------------------------------
/**
 * resets the cell including status
 */

  public void resetAll()
  {
    status_ = 0;
  }


//------------------------------------------------------------
/**
 * standard toString method for debugging
 * @return info about the cell in string-format
 */

  public String toString()
  {
    return("status_: " + status_);
  }

}
