package PrintLabyrinth;

import java.util.Random;


public class Direction
{
  public final static int DIRECTION_UP    = 1;
  public final static int DIRECTION_RIGHT = 2;
  public final static int DIRECTION_DOWN  = 3;
  public final static int DIRECTION_LEFT  = 4;
  
  protected int direction_;
  protected Random random_generator_;
  
  public Direction()
  {
    direction_ = 0;
    random_generator_ = new Random();
  }
  
  protected boolean isLegalDirection(int direction)
  {
    return( direction == DIRECTION_UP     ||
     direction == DIRECTION_RIGHT  ||
     direction == DIRECTION_DOWN   ||
     direction == DIRECTION_LEFT      );
  }
  
  public int getDirection()
    throws IllegalDirectionException
  {
    if (!isLegalDirection(direction_))
    {
      throw new IllegalDirectionException("Illegal Direction!");
    }
    
    return direction_;
  }
  
  public void setDirection(int direction)
    throws IllegalDirectionException
  {
    if (isLegalDirection(direction))
    {
      direction_ = direction;
    }
    else
    {
      throw new IllegalDirectionException("Illegal Direction!");
    }
  }
  
  public void invertDirection()
    throws IllegalDirectionException
  {
    if (!isLegalDirection(direction_))
    {
      throw new IllegalDirectionException("Illegal Direction!");
    }
    
    switch (direction_)
    {
      case DIRECTION_UP:
        direction_ = DIRECTION_DOWN;
        break;
      case DIRECTION_DOWN:
        direction_ = DIRECTION_UP;
        break;
      case DIRECTION_RIGHT:
        direction_ = DIRECTION_LEFT;
        break;
      case DIRECTION_LEFT:
        direction_ = DIRECTION_RIGHT;
        break;
      default:
        break;
    }
  }
  
  public void randomizeNextDirection()
    throws IllegalDirectionException
  {
    invertDirection();
    int forbidden_direction = direction_;

    while (direction_==forbidden_direction)
    {
      randomizeDirection();
    }
  }
  

  
  public void randomizeDirection()
  {    
    int rand_value = random_generator_.nextInt(4)+1;
    switch (rand_value)
    {
      case 1:
        direction_ = DIRECTION_UP;
        break;
      case 2:
        direction_ = DIRECTION_RIGHT;
        break;
      case 3:
        direction_ = DIRECTION_DOWN;
        break;
      case 4:
        direction_ = DIRECTION_LEFT;
        break;
      default:
        break;
    }
  }

  
  public String toString()
  {
    String ret_string = "Current direction: ";
    switch (direction_)
    {
      case DIRECTION_UP:
        ret_string += "UP";
        break;
      case DIRECTION_DOWN:
        ret_string += "DOWN";
        break;
      case DIRECTION_RIGHT:
        ret_string += "RIGHT";
        break;
      case DIRECTION_LEFT:
        ret_string += "LEFT";
        break;
      default:
        ret_string += "0";
        break;
    }
    return ret_string;
  }
}
