
package PrintLabyrinth;

import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.XMLReader;
import org.xml.sax.SAXException;
import java.io.File;
import java.io.IOException;


//----------------------------------------------------------------------
/**
 * class representing a two dimensional labyrinth
 */

public class LoadLabyrinth
{
  
  /** the number of diamonds distributed in the field (set from
   * outside of the class with the appropriate method-calls */
//  protected int num_diamonds_;

  /** the max number of rows
   *  max_row_=rows-1*/
  protected int max_row_;
  /** the max number of cols
   *  max_col_=cols-1*/
  protected int max_col_;
  /** the row-coordinate of the "startpont"
   * with the range 0 to rows-1*/
  protected int startpoint_row_;
  /** the col-coordinate of the "startpont"
   * with the range 0 to cols-1*/
  protected int startpoint_col_;

  protected LabyrinthField labyrinth_field_;
  
  protected char start_symbol_;
  protected char wall_symbol_;
  protected char diamond_symbol_;
  protected char gallery_symbol_;
  protected char worm_symbol_;

//  protected int row_;
//  protected int col_;

//----------------------------------------------------------------------
/**
 * Standard constructor
 * @param filename name of the XML file to load
 * @exception IllegalArgumentException if the specified file 
 * can't be found
 */

  public LoadLabyrinth(String filename)
    throws IllegalArgumentException

  {
    try
    {
      SAXParserFactory factory = SAXParserFactory.newInstance();
      SAXParser saxParser = factory.newSAXParser();
      XMLReader xmlReader = saxParser.getXMLReader();
      LabyrinthXMLContentHandler labyrinth_xml_content_handler = new LabyrinthXMLContentHandler();
      xmlReader.setContentHandler(labyrinth_xml_content_handler);
 //     xmlReader.parse(new File(filename).toURL().toString());
      xmlReader.parse(filename);
 
      int rows = labyrinth_xml_content_handler.getHeight();
      int cols = labyrinth_xml_content_handler.getWidth();
      start_symbol_   = labyrinth_xml_content_handler.getStartSymbol();
      wall_symbol_    = labyrinth_xml_content_handler.getWallSymbol();
      diamond_symbol_ = labyrinth_xml_content_handler.getDiamondSymbol();
      gallery_symbol_ = labyrinth_xml_content_handler.getGallerySymbol();
      worm_symbol_    = labyrinth_xml_content_handler.getWormSymbol();
      char[][] labyrinth   = labyrinth_xml_content_handler.getLabyrinth();

      labyrinth_field_ = new LabyrinthField(rows, cols);

      max_row_=rows-1;
      max_col_=cols-1;

      Cell current_cell;
      char current_symbol;
      for (int row_count = 0; row_count < rows; row_count++)
      {
        for (int col_count = 0; col_count < cols; col_count++)
        {
          current_cell   = (Cell)labyrinth_field_.getElement(row_count,col_count);
          current_symbol = labyrinth[row_count][col_count];
          if(current_symbol == start_symbol_)
          {
            startpoint_row_=row_count;
            startpoint_col_=col_count;
            current_cell.convertToStartpoint();
          }
          else if(current_symbol == wall_symbol_)
          {
            //current_cell.convertToWall();
          }
          else if(current_symbol == diamond_symbol_)
          {
            current_cell.convertToWay();
            current_cell.setDiamond();
          }
          else if(current_symbol == gallery_symbol_)
          {
            current_cell.convertToWay();
          }

        }
      }
    }
    catch(SAXException exc)
    {
      System.err.println(exc.getMessage());
    }
    catch(ParserConfigurationException exc)
    {
      System.err.println(exc.getMessage());
    }
    catch(IOException exc)
    {
      System.err.println(exc.getMessage());
    }

  }

//----------------------------------------------------------------------
/**
 *
 *
 */
  public LabyrinthField getLabyrinthField()
  {
    return labyrinth_field_;
  }

//----------------------------------------------------------------------
/**
 * standard toString method for debugging
 * @return info about the labyrinth field in string-format
 */

  public String toString()
  {
    return("LoadLabyrinth: " + " startpoint_row_ = " + startpoint_row_ +
           ", startpoint_col_ = " + startpoint_col_ +
           super.toString());
  }
  
  public int getStartpointRow()
  {
    return startpoint_row_;
  }
  public int getStartpointCol()
  {
    return startpoint_col_;
  }

  public char getStartSymbol()
  {
    return start_symbol_;
  }
  
  public char getWallSymbol()
  {
    return wall_symbol_;
  }
  
  public char getDiamondSymbol()
  {
    return diamond_symbol_;
  }
  
  public char getGallerySymbol()
  {
    return gallery_symbol_;
  }
  
  public char getWormSymbol()
  {
    return worm_symbol_;
  }

}
