//package PrintLabyrinth;

import java.awt.*;
import java.applet.*;
import java.io.*;
import java.net.*;
import PrintLabyrinth.*;
import PrintLabyrinth.Robot;
//----------------------------------------------------------------------
/**
 * class to display the labyrinth
 */

public class PrintLabyrinth extends Applet
{
  protected final static boolean create_labyrinth_ = false;  // Switch, nur derzeit ntig

  protected final static String directory_ = "/home/koebi001/public_html/java/2004-08-31/";
 // String file = new File("Labyrinthaufbau.xml").getAbsolutePath();

  //HEIGHT and WHITH of a labyrinth cell
  protected final static int CELL_HEIGHT = 20;
  protected final static int CELL_WHITH = 20;

  //number of cells in a row and a col
  protected final static int ROWS = 20;
  protected final static int COLS = 20;

  //sice of the labyrinth
  protected final static int LABYRINTH_HEIGHT = ROWS * CELL_HEIGHT;
  protected final static int LABYRINTH_WHITH = COLS * CELL_WHITH;

  protected static LabyrinthField labyrinth_field_;
  //protected static Cell cell_;
//  protected static CreateLabyrinth create_labyrinth_;
//  protected static LoadLabyrinth load_labyrinth_;
  protected static Labyrinth labyrinth_;
  protected static Robot robot_;

  Image way, wall, robot, diamond;
  protected static WriteLabToXML write_lab_;


  public static void main(String[] args)
  {
  int hposition, vposition, cols_counter, rows_counter;
  hposition=0;
  vposition=0;
  cols_counter=0;
  rows_counter=0;

  try
  {
//    create_labyrinth_ = new CreateLabyrinth(ROWS,COLS);
    labyrinth_ = new Labyrinth();
    if (create_labyrinth_)
    {
      labyrinth_.createLabyrinth(ROWS, COLS, 150, 10, true, true, true, true);
    }
    else
    {
      labyrinth_.loadLabyrinth("Labyrinthaufbau.xml");
    }
//    create_labyrinth_.calculateWays();
//    create_labyrinth_.setDiamonds();
//    labyrinth_field_=create_labyrinth_.getLabyrinthField();
    labyrinth_field_=labyrinth_.getLabyrinthField();

    robot_ = new Robot();
//    robot_.setStartDirection(create_labyrinth_.getStartDirection());
    robot_.setPos(labyrinth_.getStartpointRow(), labyrinth_.getStartpointCol());
    robot_.setStartDirection(labyrinth_.getStartDirection());
    write_lab_ = new WriteLabToXML(labyrinth_field_, robot_);



      while(rows_counter<labyrinth_field_.getNumRows())
      {
        while(cols_counter<labyrinth_field_.getNumCols())
        {
          //cell_=(Cell)labyrinth_field_.getElement(rows_counter,cols_counter);

          if(labyrinth_field_.isWall(rows_counter,cols_counter)==true)
            System.out.print(LabSymbols.WALLSYMBOL);
          if(labyrinth_field_.isWay(rows_counter,cols_counter)==true)
          {
            if(labyrinth_field_.isStartpoint(rows_counter,cols_counter)==true)
              System.out.print(LabSymbols.STARTSYMBOL);
            else
            {
              if(labyrinth_field_.containsDiamond(rows_counter,cols_counter)==true)
                System.out.print(LabSymbols.DIAMONDSYMBOL);
              else
              {
                System.out.print(LabSymbols.WAYSYMBOL);
              }
            }
          }
          if(cols_counter==labyrinth_field_.getNumCols()-1)
            System.out.print("\n");

         cols_counter=cols_counter+1;
         hposition=hposition+CELL_WHITH;
        }
        rows_counter=rows_counter+1;
        vposition=vposition+CELL_HEIGHT;
        hposition=0;
        cols_counter=0;
      }
    }
    catch(IllegalDirectionException ex)
    {
      System.err.println(ex.getMessage());
    }

  write_lab_.writeXMLFile("Labyrinthaufbau2.xml");

  }


  public void init()
  {

    //String file=args[0];
    setSize(LABYRINTH_HEIGHT,LABYRINTH_WHITH);

    way = getImage( getDocumentBase(), "PrintLabyrinth/way_3.jpg" );
    wall = getImage( getDocumentBase(), "PrintLabyrinth/way_2.jpg" );
    robot = getImage( getDocumentBase(), "PrintLabyrinth/ball.gif" );
    diamond = getImage( getDocumentBase(), "PrintLabyrinth/diamond.gif" );



    try
    {
//    create_labyrinth_ = new CreateLabyrinth(ROWS,COLS);
    labyrinth_ = new Labyrinth();
    if (create_labyrinth_)
    {
      labyrinth_.createLabyrinth(ROWS, COLS, 150, 50, true, true, true, true);
    }
    else
    {
      labyrinth_.loadLabyrinth(directory_ + "Labyrinthaufbau.xml");
      //labyrinth_.loadLabyrinth(file);
    }

//    create_labyrinth_.calculateWays();
//    create_labyrinth_.setDiamonds();
//    labyrinth_field_=create_labyrinth_.getLabyrinthField();
    labyrinth_field_=labyrinth_.getLabyrinthField();

      robot_ = new Robot();
//      robot_.setPos(create_labyrinth_.getStartpointRow(), create_labyrinth_.getStartpointCol());
      robot_.setPos(labyrinth_.getStartpointRow(), labyrinth_.getStartpointCol());
      robot_.setStartDirection(labyrinth_.getStartDirection());
    }
    catch(IllegalDirectionException ex)
    {
      System.err.println(ex.getMessage());
    }

 /*   try
   {
      OutputStream fout= new FileOutputStream("f:\\work\\PrintLabyrinth\\Labyrinthaufbau2.xml");
      OutputStream bout= new BufferedOutputStream(fout);
      OutputStreamWriter out
       = new OutputStreamWriter(bout, "8859_1");
      out.write("<?xml version=\"1.0\" ");
      out.write("encoding=\"ISO-8859-1\"?>\r\n");
      write_lab_.writeRobotLabyrinth(out);
      out.flush();
      out.close();
    }
    catch(UnsupportedEncodingException e)
    {
      System.out.println(
        "This VM does not support the Latin-1 character set."
        );
    }
    catch (IOException e)
    {
      System.out.println(e.getMessage());
    } */
  }


  public void paint(Graphics g)
  {
    update(g);
  }

public void update(Graphics g)
  {
    paintFrame(g);
  }

public void start()
{
  Direction direction = new Direction();
  try
  {
    direction.setDirection(Direction.DIRECTION_UP);
    robot_.moveInDirection(direction);
  }
  catch(IllegalDirectionException ex)
  {
    System.err.println(ex.getMessage());
  }
}

  public void paintFrame(Graphics g)
  {
    int hposition, vposition, cols_counter, rows_counter;
    hposition=0;
    vposition=0;
    cols_counter=0;
    rows_counter=0;

    while(rows_counter<labyrinth_field_.getNumRows())
      {
        while(cols_counter<labyrinth_field_.getNumCols())
        {
            //cell_=(Cell)labyrinth_field_.getElement(rows_counter,cols_counter);

          if(labyrinth_field_.isWay(rows_counter,cols_counter)==true)
          {
              g.drawImage(way, hposition, vposition, this);
              if(labyrinth_field_.containsDiamond(rows_counter,cols_counter)==true)
                g.drawImage(diamond, hposition, vposition, this);
          }
          else
            g.drawImage(wall, hposition, vposition, this);

          cols_counter=cols_counter+1;
          hposition=hposition+CELL_WHITH;
        }
        rows_counter=rows_counter+1;
        vposition=vposition+CELL_HEIGHT;
        hposition=0;
        cols_counter=0;
      }

      int robot_vposition = robot_.getPosRow() * CELL_HEIGHT;
      int robot_hposition = robot_.getPosCol() * CELL_WHITH;

      if(robot_vposition >= 0 && robot_hposition >=0)
      g.drawImage(robot, robot_hposition, robot_vposition, this);

  }

}
