package PrintLabyrinth;

/**-----------------------------------------------------------------------------
 * class represents a Labyrinth and contains methods to construct a new labyrinth

 */


public class Labyrinth
{
  private CreateLabyrinth create_labyrinth_;
  private LoadLabyrinth load_labyrinth_;

  public Labyrinth()
  {
    create_labyrinth_ = null;
    load_labyrinth_   = null;
  }

/**-----------------------------------------------------------------------------
 * method loads a Labyrinth from a given XML file.
 * @param file_name name of the XML file
 */

  public void loadLabyrinth(String file_name)
  {
    create_labyrinth_ = null;
    load_labyrinth_   = new LoadLabyrinth(file_name);
  }

/**-----------------------------------------------------------------------------
 * method creates a Labyrinth randomly
 * @param rows the number of rows of this Labyrinth.
 * @param cols the number of cols of this Labyrinth.
 * @param num_way_cells the number of cell which are declared als way.
 * @param num_diamonds the number of diamonds in this labyrinth.
 * @param build_angle if true corners are allowed.
 * @param build_tree if true crossroads are allowed.
 * @param build_loop if true the ways through the labyrinth can contain loops.
 * @param build_places if true the labyrinth can contain places.
 */
  public void createLabyrinth(int rows, int cols, int num_way_cells, int num_diamonds,
    boolean build_angle, boolean build_tree, boolean build_loop, boolean build_places)
    throws IllegalDirectionException
  {
    create_labyrinth_ = new CreateLabyrinth(rows, cols, num_way_cells,
       num_diamonds, build_angle, build_tree, build_loop, build_places);

    create_labyrinth_.calculateWays();
    create_labyrinth_.setDiamonds();

    load_labyrinth_   = null;
  }

  public LabyrinthField getLabyrinthField()
  {
    if (create_labyrinth_ != null)
      return create_labyrinth_.getLabyrinthField();

    if (load_labyrinth_ != null)
      return load_labyrinth_.getLabyrinthField();

    return null;
  }

  public int getStartpointRow()
  {
    if (create_labyrinth_ != null)
      return create_labyrinth_.getStartpointRow();

    if (load_labyrinth_ != null)
      return load_labyrinth_.getStartpointRow();

    return -1;
  }

  public int getStartpointCol()
  {
    if (create_labyrinth_ != null)
      return create_labyrinth_.getStartpointCol();

    if (load_labyrinth_ != null)
      return load_labyrinth_.getStartpointCol();

    return -1;
  }

  public Direction getStartDirection()
  {
    if (create_labyrinth_ != null)
      return create_labyrinth_.getStartDirection();

    if (load_labyrinth_ != null)
      return load_labyrinth_.getStartDirection();

    return null;
  }

  public String toString()
  {
    if (create_labyrinth_ != null)
      return create_labyrinth_.toString();

    if (load_labyrinth_ != null)
      return load_labyrinth_.toString();

    return "no valid Labyrinth available";
  }


}