package PrintLabyrinth;

import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.Attributes;
import java.lang.Integer;



public class LabyrinthXMLContentHandler extends DefaultHandler
{
  private int width_;
  private int height_;
  private char start_symbol_;
  private char wall_symbol_;
  private char diamond_symbol_;
  private char gallery_symbol_;
  private char worm_symbol_;
  private Direction starting_direction_;
  private char[][] labyrinth_data_;
  private String temp_labyrinth_data_;
  private String current_tag_;
  
  public LabyrinthXMLContentHandler()
  {
    width_=0;
    height_=0;
    start_symbol_= 0;
    wall_symbol_= 0;
    diamond_symbol_=0;
    worm_symbol_=0;
    starting_direction_= new Direction();
    temp_labyrinth_data_= new String();
    current_tag_= new String();
  }
  
/**-----------------------------------------------------------------------------
 *Receive notification of the beginning of the document.
 */  
  public void startDocument()
  {
    //nothing to do here.
  }
  
/**-----------------------------------------------------------------------------
 *Receive notification of the start of an element. 
 *@param attributes - The specified or defaulted attributes.
 *@param localName - The local name (without prefix), 
 *or the empty string if Namespace processing is not being performed.
 *@param qualName - The qualified name (with prefix), 
 *or the empty string if qualified names are not available.
 */
  
  public void startElement(String uri, String localName, String qualName, Attributes attribs)
  {
    current_tag_ = qualName;
  }
  
/**-----------------------------------------------------------------------------
 *Receive notification of character data inside an element. 
 *@param charArray - The characters.
 *@param start - The start position in the character array.
 *@param length - The number of characters to use from the character array.
 */  
  public void characters(char[] charArray, int start, int length)
  {
    if(current_tag_.length() > 0)
    {
      String temp_string = new String(charArray, start, length);
      temp_string = temp_string.trim();
      
      if (current_tag_.equals(new String(TagName.WIDTH)))
      {
        width_=Integer.decode(temp_string).intValue();
      }
      
      else if (current_tag_.equals(new String(TagName.HEIGHT)))
      {
        height_=Integer.decode(temp_string).intValue();
      }
      
      else if (current_tag_.equals(new String(TagName.STARTSYMBOL)))
      {
        start_symbol_=temp_string.trim().charAt(0);
      }
      
      else if (current_tag_.equals(new String(TagName.WALLSYMBOL)))
      {       
        wall_symbol_=temp_string.charAt(0);
      }
      
      else if (current_tag_.equals(new String(TagName.DIAMONDSYMBOL)))
      {       
        diamond_symbol_=temp_string.charAt(0);
      }
      
      else if (current_tag_.equals(new String(TagName.GALLERYSYMBOL)))
      {       
        gallery_symbol_=temp_string.charAt(0);
      }
      
      else if (current_tag_.equals(new String(TagName.WORMSYMBOL)))
      {       
        worm_symbol_=temp_string.charAt(0);
      }
      
      else if (current_tag_.equals(new String(TagName.STARTDIRECTION)))
      {     
        try
        {
          if (temp_string.equals(new String(Direction.DIR_UP)))
          {
            starting_direction_.setDirection(Direction.DIRECTION_UP);
          }
          else if (temp_string.equals(new String(Direction.DIR_RIGHT)))
          {
            starting_direction_.setDirection(Direction.DIRECTION_RIGHT);
          }
          else if (temp_string.equals(new String(Direction.DIR_DOWN)))
          {
            starting_direction_.setDirection(Direction.DIRECTION_DOWN);
          }
          else if (temp_string.equals(new String(Direction.DIR_LEFT)))
          {
            starting_direction_.setDirection(Direction.DIRECTION_LEFT);
          }
        }
        catch(IllegalDirectionException exc)
        {
          
        }
      }

      else if (current_tag_.equals(new String(TagName.LABYRINTH)))
      {       
        if (temp_string.length() > 1)
        {
          temp_labyrinth_data_ = temp_labyrinth_data_ + temp_string + "\n";
        }
      }
    }
  }
  
/**-----------------------------------------------------------------------------
 *Receive notification of the end of an element. 
 *@param localName - The local name (without prefix), or the empty string if 
 *Namespace processing is not being performed.
 *@param qName - The qualified XML 1.0 name (with prefix), or the empty string if 
 *qualified names are not available.
 */  
  public void endElement(String uri, String localName, String qualName)
  {
    current_tag_="";
  }

/**-----------------------------------------------------------------------------
 *Receive notification of the end of the document.  
 */  
  public void endDocument()
  {
    convertLabyrinthData();
  }

/**-----------------------------------------------------------------------------
 * Generates a twodimensional character-array which is an ASCII representation 
 * of the labyrinthfield. 
 */
  private void convertLabyrinthData()
  {
    labyrinth_data_= new char[height_][width_];
    
    String[] rows = temp_labyrinth_data_.split("\n");

    for (int row_count=0; row_count<height_; row_count++)
    {
      temp_labyrinth_data_=rows[row_count].trim();
      for(int col_count =0; col_count<width_; col_count++)
      {
        labyrinth_data_[row_count][col_count]= temp_labyrinth_data_.charAt(col_count);
      }
    }
  }
  
  public int getWidth()
  {
    return width_;
  }
  
  public int getHeight()
  {
    return height_;
  }
  
  public char getStartSymbol()
  {
    return start_symbol_;
  }
  
  public char getWallSymbol()
  {
    return wall_symbol_;
  }
  
  public char getDiamondSymbol()
  {
    return diamond_symbol_;
  }
  
  public char getGallerySymbol()
  {
    return gallery_symbol_;
  }
  
  public char getWormSymbol()
  {
    return worm_symbol_;
  }
  
  public Direction getStartingDirection()
  {
    return starting_direction_;
  }
  
  public char[][] getLabyrinth()
  {
    return labyrinth_data_;
  }
  
}
