package PrintLabyrinth;

import java.util.Random;

//----------------------------------------------------------------------
/**
 * class representing a two dimensional labyrinth
 */

public class RandomWayCoordinates
{

private int rows_, cols_;
private int random_row, random_col;
private Random random_generator_;

  public RandomWayCoordinates(int rows,int cols)
      throws IllegalArgumentException
    {
      if (rows <= 1)
        throw(new IllegalArgumentException(
          "rows must be >= 1"));
      if (cols <= 1)
        throw(new IllegalArgumentException(
        "rows must be >= 1"));
      random_generator_ = new Random();
      rows_=rows;
      cols_=cols;
      random_row=-1;
      random_col=-1;
  }

  public boolean findRandomWayCoordinates(LabyrinthField labyrinth_field, int num_ways)
  {
        random_row=-1;
        random_col=-1;
    int min=1;
    int max=num_ways;
    int cell_number = getIntRandomValue(min, max);
    int rows_count, cols_count;
    int way_cell_counter=0;
    //Cell cell;
    for(rows_count=0;rows_count<rows_;rows_count++)
    {
      for(cols_count=0;cols_count<cols_;cols_count++)
      {
        //cell=(Cell)labyrinth_field.getElement(rows_count, cols_count);
        if(labyrinth_field.isWay(rows_count, cols_count)==true)
          way_cell_counter++;
        if(way_cell_counter==cell_number)
        {
          random_row=rows_count;
          random_col=cols_count;
          return true;
        }
      }
    }
    return false;
  }

  public int getRandomWayRowCoordinate()
    throws IllegalArgumentException
  {
    if (random_row < 1)
      throw(new IllegalArgumentException(
            "random_row must be < 1"));
    return random_row;
  }

  public int getRandomWayColCoordinate()
    throws IllegalArgumentException
  {
    if (random_col < 1)
      throw(new IllegalArgumentException(
            "random_col must be < 1"));
    return random_col;
  }

  protected int getIntRandomValue(int min, int max)
  {
      return min + random_generator_.nextInt(max-min+1);
    }
}