package PrintGame;
import java.awt.*;
import java.applet.*;
import PrintGame.*;
import PrintGame.Robot;

public class PrintLabyrinth
{
  //HEIGHT and WHITH of a labyrinth cell
  public final static int CELL_HEIGHT = 20;
  public final static int CELL_WIDTH = 20;
  
  protected Image img_way_, img_wall_, img_robot_, img_diamond_;
  
  protected  LabyrinthField labyrinth_field_;

  protected  Robot robot_;
  protected  Applet applet_;
 
  public PrintLabyrinth( Applet applet, Robot robot, LabyrinthField labyrinth_field)
  {
    applet_=applet;
    robot_ = robot;
    labyrinth_field_ = labyrinth_field;
    img_way_ = applet_.getImage( applet_.getDocumentBase(), "PrintGame/way_3.jpg" );
    img_wall_ = applet_.getImage( applet_.getDocumentBase(), "PrintGame/way_2.jpg" );
    img_robot_ = applet_.getImage( applet_.getDocumentBase(), "PrintGame/ball.gif" );
    img_diamond_ = applet_.getImage( applet_.getDocumentBase(), "PrintGame/diamond.gif" );
  }
  
  
  public void paintFrame(Graphics g)
  {
    int hposition, vposition, cols_counter, rows_counter;
    hposition=0;
    vposition=0;
    cols_counter=0;
    rows_counter=0;

    while(rows_counter<labyrinth_field_.getNumRows())
      {
        while(cols_counter<labyrinth_field_.getNumCols())
        {
          if(labyrinth_field_.isWay(rows_counter,cols_counter)==true)
          {
              g.drawImage(img_way_, hposition, vposition, applet_);
              if(labyrinth_field_.containsDiamond(rows_counter,cols_counter)==true)
                g.drawImage(img_diamond_, hposition, vposition, applet_);
          }
          else
            g.drawImage(img_wall_, hposition, vposition, applet_);

          cols_counter=cols_counter+1;
          hposition=hposition+CELL_WIDTH;
        }
        rows_counter=rows_counter+1;
        vposition=vposition+CELL_HEIGHT;
        hposition=0;
        cols_counter=0;
      }
      int robot_vposition = robot_.getPosRow() * CELL_HEIGHT;
      int robot_hposition = robot_.getPosCol() * CELL_WIDTH;

      if(robot_vposition >= 0 && robot_hposition >=0)
      g.drawImage(img_robot_, robot_hposition, robot_vposition, applet_);
  }
}


