package PrintGame;

/**
 * class representing a Condition
 */
public class Condition
{
  protected boolean wall_left_;
  protected boolean wall_right_;
  protected boolean wall_ahead_;
  
  protected int cell_mark_;
  protected int state_;
  
//-----------------------------------------------------------------------------  
/**
 * constructor generates a new condition with the specified arguments
 * @param wall_left false means that the cell on the left of the robot is a way
 * @param wall_right false means that the cell on the right of the robot is a way
 * @param wall_ahead false means that the cell in front of the robot is a way
 * @param cell_mark 0 if the cell is not marked
 * @param new_area true if the robot explores area he hasn't seen before
 */    
  public Condition(int state, int cell_mark, boolean wall_left, 
    boolean wall_right, boolean wall_ahead )
    throws IllegalArgumentException
  {
    if(cell_mark<0 || cell_mark>3)
     throw(new IllegalArgumentException(
       "cell_mark must be >= 0 and <= 3"));
     
    wall_left_= wall_left;
    wall_right_ = wall_right;
    wall_ahead_= wall_ahead;
    cell_mark_= cell_mark;
    state_ = state;
  }
  
//-----------------------------------------------------------------------------
/**
 * method sets if the cells in field of vision of the robot are ways or walls
 * @param wall_left false means that the cell on the left of the robot is a way
 * @param wall_right false means that the cell on the right of the robot is a way
 * @param wall_ahead false means that the cell in front of the robot is a way
 */  
  public void setWalls(boolean wall_left, boolean wall_right, boolean wall_ahead)
  {
    wall_left_= wall_left;
    wall_right_ = wall_right;
    wall_ahead_= wall_ahead;
  }
  
//----------------------------------------------------------------------------- 
/**
 * method sets the cell mark
 * @param cell_mark 0 if the cell is not marked
 * 1 if the cell is marked for the first time
 * 2 if the cell was marked before
 */  
  public void setCellMark(int cell_mark)
    throws IllegalArgumentException
  {
    if(cell_mark<0 || cell_mark>3)
     throw(new IllegalArgumentException(
       "cell_mark must be >= 0 and <= 3"));
    
    cell_mark_= cell_mark;
  }
  
//-----------------------------------------------------------------------------  
/**
 *
 */  
  public void setState(int state)
    throws IllegalArgumentException
  {
    if(state<0 || state>1)
     throw(new IllegalArgumentException(
       "state must be >= 0 and <= 1"));
    state_ = state;
  }
  
//-----------------------------------------------------------------------------  
/**
 *
 */  
  public boolean isWallLeft()
  {
    return wall_left_;
  }
  
//-----------------------------------------------------------------------------  
/**
 *
 */  
  public boolean isWallRight()
  {
    return wall_right_;
  }
  
//-----------------------------------------------------------------------------  
/**
 *
 */  
  public boolean isWallAhead()
  {
    return wall_ahead_;
  }
  
//-----------------------------------------------------------------------------  
/**
 *
 */  
  public int getCellMark()
  {
    return cell_mark_;
  }
  
//-----------------------------------------------------------------------------  
/**
 *
 */    
  public int getState()
  {
    return state_;
  }
//-----------------------------------------------------------------------------
/**
 * method compares 2 conditions and returns true if they are equal.
 */   
  public boolean equals(Condition test_condition)
  {
    return ((wall_left_  == test_condition.isWallLeft())  && 
            (wall_right_ == test_condition.isWallRight()) && 
            (wall_ahead_ == test_condition.isWallAhead()) && 
            (cell_mark_  == test_condition.getCellMark()) && 
            (state_   == test_condition.getState())   );
  }
}
