package PrintGame;


import java.awt.Graphics;
import java.awt.Image;
import java.util.HashMap;

import javax.swing.JPanel;

public class PrintLabyrinth extends JPanel
{
  //HEIGHT and WHITH of a labyrinth cell
  public final static int CELL_HEIGHT = 20;
  public final static int CELL_WIDTH = 20;
  
  protected Image img_way_, img_wall_, img_robot_, img_diamond_;
  
  protected  LabyrinthField labyrinth_field_;

  protected  Robot robot_;

 
  public PrintLabyrinth( HashMap brick_images, Robot robot, LabyrinthField labyrinth_field)
  {
    robot_ = robot;
    labyrinth_field_ = labyrinth_field;
    img_way_ = (Image) brick_images.get("LAB_WAY");
    img_wall_ = (Image) brick_images.get("LAB_WALL");
    img_robot_ = (Image) brick_images.get("LAB_ROBOT");
    img_diamond_ = (Image) brick_images.get("LAB_DIAMOND");
  }
  
  public void setLabyrinthField( LabyrinthField labyrinth_field )
  {
      labyrinth_field_ = labyrinth_field; 
  }
  public void setRobot( Robot robot )
  {
    robot_ = robot;  
  }
  public void paintComponent(Graphics g) {
      super.paintComponent(g);
    int hposition, vposition, cols_counter, rows_counter;
    hposition=0;
    vposition=0;
    cols_counter=0;
    rows_counter=0;
    if( (labyrinth_field_ != null) && (robot_ != null)) {
	    while(rows_counter<labyrinth_field_.getNumRows())
	      {
	        while(cols_counter<labyrinth_field_.getNumCols())
	        {
	          if(labyrinth_field_.isWay(rows_counter,cols_counter)==true)
	          {
	              g.drawImage(img_way_, hposition, vposition, this);
	              if(labyrinth_field_.containsDiamond(rows_counter,cols_counter)==true)
	                g.drawImage(img_diamond_, hposition, vposition, this);
	          }
	          else
	            g.drawImage(img_wall_, hposition, vposition, this);
	
	          cols_counter=cols_counter+1;
	          hposition=hposition+CELL_WIDTH;
	        }
	        rows_counter=rows_counter+1;
	        vposition=vposition+CELL_HEIGHT;
	        hposition=0;
	        cols_counter=0;
	      }
	      int robot_vposition = robot_.getPosRow() * CELL_HEIGHT;
	      int robot_hposition = robot_.getPosCol() * CELL_WIDTH;
	
	      if(robot_vposition >= 0 && robot_hposition >=0)
	        g.drawImage(img_robot_, robot_hposition, robot_vposition, this);
	    }
  }
}


