/*
 * Created on 12.09.2004
 *
 */
package PrintGame;

import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.XMLReader;
import org.xml.sax.SAXException;
import java.io.File;
import java.io.IOException;

public class LevelHandler {

  private LoadLabyrinth load_labyrinth_;
  private GameXMLContentHandler game_xml_content_handler_;
  private String wall_picture_;
  private String way_picture_;
  private String robot_picture_;
  private String diamond_picture_;
  private String start_picture_;
  private int num_levels_;
  private String file_;

  public LevelHandler()
  {

  }

  public void loadGameXmlFile(String filename)
  {
    try
    {
      SAXParserFactory factory = SAXParserFactory.newInstance();
      SAXParser saxParser = factory.newSAXParser();
      XMLReader xmlReader = saxParser.getXMLReader();
      game_xml_content_handler_ = new GameXMLContentHandler();
      xmlReader.setContentHandler(game_xml_content_handler_);
      xmlReader.parse(filename);

      wall_picture_ = game_xml_content_handler_.getWallPicture();
      way_picture_ = game_xml_content_handler_.getWayPicture();
      robot_picture_ = game_xml_content_handler_.getRobotPicture();
      diamond_picture_ = game_xml_content_handler_.getDiamondPicture();
      start_picture_ = game_xml_content_handler_.getStartPicture();
      num_levels_ = game_xml_content_handler_.getNumLevels();
    }
    catch(SAXException exc)
    {
      System.err.println(exc.getMessage());
    }
    catch(ParserConfigurationException exc)
    {
      System.err.println(exc.getMessage());
    }
    catch(IOException exc)
    {
      System.err.println(exc.getMessage());
    }
  }

  public int getNumLevels()
  {
    return num_levels_;
  }

  public void loadLevel(int number)
  {
    file_ = game_xml_content_handler_.getFile(number);
 
    load_labyrinth_ = new LoadLabyrinth(file_);
  }


  public LabyrinthField getLabyrinthField()
  {
    return load_labyrinth_.getLabyrinthField();
  }
  public int getStartpointRow()
  {
    return load_labyrinth_.getStartpointRow();
  }
  public int getStartpointCol()
  {
    return load_labyrinth_.getStartpointCol();
  }
  public Direction getStartDirection()
  {
    return load_labyrinth_.getStartDirection();
  }
}
