package PrintGame;

/**
 * class representing a Robot.
 */
public class Robot
{
  
  private int position_row_;
  private int position_col_;
  private Direction start_direction_;
  private Direction current_direction_;
  private int state_;

//-----------------------------------------------------------------------------
/**
 * standard constructor
 */  
  public Robot()
  {
    position_row_ = -1;
    position_col_ = -1;
    start_direction_ = new Direction();
    current_direction_= new Direction();
    state_ = 0;
  }
  
//-----------------------------------------------------------------------------  
/**
 * method returns the mark new_area_
 * @return info about the way the robot has taken
 * when it returns false the robot wasn't on this cell before
 */
   public int getState()
  {
    return state_;
  }
   
//-----------------------------------------------------------------------------
/**
 *
 */   
  public int getPosRow()
  {
    return position_row_;
  }
   
//-----------------------------------------------------------------------------
/**
 *
 */   
  public int getPosCol()
  {
    return position_col_;
  }
   
//-----------------------------------------------------------------------------
/**
 *
 */   
  public Direction getStartDirection()
  {
    return start_direction_;
  }
   
//-----------------------------------------------------------------------------
/**
 *
 */    
  public Direction getCurrentDirection()
  {
    return current_direction_;
  }
   
//-----------------------------------------------------------------------------
/**
 *
 */ 
  public void setState(int state)
    throws IllegalArgumentException
  {
    if(state<0 || state>1)
     throw(new IllegalArgumentException(
       "state must be >= 0 and <= 1"));
    state_ = state;
  }
   
//-----------------------------------------------------------------------------
/**
 *
 */   
  public void setPos(int row, int col)
  {
    position_row_ = row;
    position_col_ = col;
  }
   
//-----------------------------------------------------------------------------
/**
 *
 */   
  public void setStartDirection(Direction start_direction)
    throws IllegalDirectionException
  {
    start_direction.getDirection();    // wirft Exception
    start_direction_= start_direction;
    current_direction_ = start_direction_;
  }

//-----------------------------------------------------------------------------
/**
 * internal method to move a robot one cell to the given direction.
 * @param direction 
 * @exception IllegalDirectionException thrown if the direction isn't valid.
 */  
  
  protected void moveInDirection(Direction direction)
    throws IllegalDirectionException
  {
    switch (direction.getDirection())
    {
      case Direction.DIRECTION_UP:
        position_row_ -= 1;
        break;
      case Direction.DIRECTION_DOWN:
        position_row_ += 1;
        break;
      case Direction.DIRECTION_RIGHT:
        position_col_ += 1;
        break;
      case Direction.DIRECTION_LEFT:
        position_col_ -= 1;
        break;
      default:
        break;
    }
  }

//-----------------------------------------------------------------------------  
/**
 * method to move a robot one cell forward (relative to his current direction)
 * @exception IllegalDirectionException thrown if the direction isn't valid.
 */  
  public void moveForward()
    throws IllegalDirectionException
  {
     moveInDirection(current_direction_);      
  }

//-----------------------------------------------------------------------------  
/**
 * method to move a robot one cell back (relative to his current direction)
 * @exception IllegalDirectionException thrown if the direction isn't valid.
 */    
  public void goBack()
    throws IllegalDirectionException
  {
    current_direction_.invertDirection();
    moveInDirection(current_direction_); 
  }

//-----------------------------------------------------------------------------  
/**
 * method to move a robot one cell left (relative to his current direction)
 * @exception IllegalDirectionException thrown if the direction isn't valid.
 */    
  public void goLeft()
    throws IllegalDirectionException
  {
    switch(current_direction_.getDirection())
    {
      case Direction.DIRECTION_UP:
        current_direction_.setDirection(Direction.DIRECTION_LEFT);
        break;
      case Direction.DIRECTION_DOWN:
        current_direction_.setDirection(Direction.DIRECTION_RIGHT);
        break;
      case Direction.DIRECTION_LEFT:
        current_direction_.setDirection(Direction.DIRECTION_DOWN);
        break;
      case Direction.DIRECTION_RIGHT:
        current_direction_.setDirection(Direction.DIRECTION_UP);
        break;
      default:
        break;
    }
    moveInDirection(current_direction_); 
  }
  
//-----------------------------------------------------------------------------  
/**
 * method to move a robot one cell right (relative to his current direction)
 * @exception IllegalDirectionException thrown if the direction isn't valid.
 */    
  public void goRight()
    throws IllegalDirectionException
  {
    switch(current_direction_.getDirection())
    {
      case Direction.DIRECTION_UP:
        current_direction_.setDirection(Direction.DIRECTION_RIGHT);
        break;
      case Direction.DIRECTION_DOWN:
        current_direction_.setDirection(Direction.DIRECTION_LEFT);
        break;
      case Direction.DIRECTION_LEFT:
        current_direction_.setDirection(Direction.DIRECTION_UP);
        break;
      case Direction.DIRECTION_RIGHT:
        current_direction_.setDirection(Direction.DIRECTION_DOWN);
        break;
      default:
        break;
    }
    moveInDirection(current_direction_); 
  }
}
