/*
 * Created on 12.09.2004
 *
 */
package PrintGame;

import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.XMLReader;
import org.xml.sax.SAXException;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class LevelHandler {

  private LoadLabyrinth load_labyrinth_;
  private GameXMLContentHandler game_xml_content_handler_;
  private String wall_picture_;
  private String way_picture_;
  private String robot_picture_;
  private String diamond_picture_;
  private String start_picture_;
  private int num_levels_;
  private String file_;
  private URL document_base_;
  private boolean is_not_default_style_;

  public LevelHandler()
  {
    document_base_= null;
    is_not_default_style_=false;
  }

  public void setDocumentBase(URL document_base)
  {
    document_base_=document_base;
  }

  public void loadGameXmlFile(String filename)
  {
    try
    {
      SAXParserFactory factory = SAXParserFactory.newInstance();
      SAXParser saxParser = factory.newSAXParser();
      XMLReader xmlReader = saxParser.getXMLReader();
      game_xml_content_handler_ = new GameXMLContentHandler();
      game_xml_content_handler_.setDocumentBase(document_base_);
      xmlReader.setContentHandler(game_xml_content_handler_);
      xmlReader.parse(filename);

      wall_picture_ = game_xml_content_handler_.getWallPicture();
      way_picture_ = game_xml_content_handler_.getWayPicture();
      robot_picture_ = game_xml_content_handler_.getRobotPicture();
      diamond_picture_ = game_xml_content_handler_.getDiamondPicture();
      start_picture_ = game_xml_content_handler_.getStartPicture();
      num_levels_ = game_xml_content_handler_.getNumLevels();
    }
    catch(SAXException exc)
    {
      System.err.println(exc.getMessage());
    }
    catch(ParserConfigurationException exc)
    {
      System.err.println(exc.getMessage());
    }
    catch(IOException exc)
    {
      System.err.println(exc.getMessage());
    }
  }

  public int getNumLevels()
  {
    return num_levels_;
  }

  public void loadLevel(int number)
  {
    is_not_default_style_=false;
    file_ = game_xml_content_handler_.getFile(number);
    load_labyrinth_ = new LoadLabyrinth(file_);
    is_not_default_style_=load_labyrinth_.isStyle();
    //System.out.println("is_not_default_style_: " + is_not_default_style_);
    //System.out.println("start_direction_: " + load_labyrinth_.getLabyrinthField().getStartDirection());
  }


  public LabyrinthField getLabyrinthField()
  {
    return load_labyrinth_.getLabyrinthField();
  }

  public String getWallPicture()
  {
    if(is_not_default_style_)
      return load_labyrinth_.getWallPicture();
    else
      return wall_picture_;
  }

  public String getWayPicture()
  {
    if(is_not_default_style_)
      return load_labyrinth_.getWayPicture();
    else
      return way_picture_;
  }

  public String getRobotPicture()
  {
    if(is_not_default_style_)
      return load_labyrinth_.getRobotPicture();
    else
      return robot_picture_;
  }

  public String getDiamondPicture()
  {
    if(is_not_default_style_)
      return load_labyrinth_.getDiamondPicture();
    else
      return diamond_picture_;
  }

  public String getStartPicture()
  {
    if(is_not_default_style_)
      return load_labyrinth_.getStartPicture();
    else
      return start_picture_;
  }

}
