
package PrintGame;

import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.XMLReader;
import org.xml.sax.SAXException;
import java.io.File;
import java.io.IOException;


//----------------------------------------------------------------------
/**
 * class representing a two dimensional labyrinth
 */

public class LoadLabyrinth
{

  /** the number of diamonds distributed in the field (set from
   * outside of the class with the appropriate method-calls */
//  protected int num_diamonds_;

  /** the max number of rows
   *  max_row_=rows-1*/
  protected int max_row_;
  /** the max number of cols
   *  max_col_=cols-1*/
  protected int max_col_;

  protected LabyrinthField labyrinth_field_;
  protected CreateLabyrinth create_labyrinth_;
  protected LabyrinthXMLContentHandler labyrinth_xml_content_handler_;

  private boolean is_style_;
  private String wall_picture_;
  private String way_picture_;
  private String robot_picture_;
  private String diamond_picture_;
  private String start_picture_;

//------------------------------------------------------------------------------
/**
 * Standard constructor
 * @param filename name of the XML file to load
 * @exception IllegalArgumentException if the specified file
 * can't be found
 */

  public LoadLabyrinth(String filename)
    throws IllegalArgumentException

  {
    try
    {
      SAXParserFactory factory = SAXParserFactory.newInstance();
      SAXParser saxParser = factory.newSAXParser();
      XMLReader xmlReader = saxParser.getXMLReader();
      labyrinth_xml_content_handler_ = new LabyrinthXMLContentHandler();
      xmlReader.setContentHandler(labyrinth_xml_content_handler_);
 //     xmlReader.parse(new File(filename).toURL().toString());
 //System.out.println("LoadLabyrinth parse file");
      xmlReader.parse(filename);
//System.out.println("LoadLabyrinth file ok");
      boolean is_load_labyrinth=false;

      char start_symbol;
      char wall_symbol;
      char diamond_symbol;
      char way_symbol;
      char one_symbol;
      char two_symbol;
      char three_symbol;

      int set_num_diamonds;
      int set_num_way_cells;
      int set_min_way_lenght;
      int set_max_way_lenght;
      int set_build_angles;
      int set_build_trees;
      int set_build_places;
      int set_build_loops;

      int rows = labyrinth_xml_content_handler_.getHeight();
      int cols = labyrinth_xml_content_handler_.getWidth();
      //System.out.println("rows: " + rows);
      //System.out.println("cols: " + cols);
      labyrinth_field_ = new LabyrinthField(rows, cols);

      max_row_=rows-1;
      max_col_=cols-1;
//System.out.println("isCreateLabyrinth: " + labyrinth_xml_content_handler_.isCreateLabyrinth());

      String name = labyrinth_xml_content_handler_.getLevelName();
      labyrinth_field_.setName(name);

      if(labyrinth_xml_content_handler_.isLoadLabyrinth()==true)
      {
        //System.out.println("isLoadLabyrinth()");
        is_load_labyrinth=true;
        start_symbol = labyrinth_xml_content_handler_.getStartSymbol();
        wall_symbol = labyrinth_xml_content_handler_.getWallSymbol();
        diamond_symbol = labyrinth_xml_content_handler_.getDiamondSymbol();
        way_symbol = labyrinth_xml_content_handler_.getWaySymbol();
        one_symbol = labyrinth_xml_content_handler_.getOneSymbol();
        two_symbol = labyrinth_xml_content_handler_.getTwoSymbol();
        three_symbol = labyrinth_xml_content_handler_.getThreeSymbol();
        char[][] labyrinth   = labyrinth_xml_content_handler_.getLabyrinth();
        Direction start_direction = labyrinth_xml_content_handler_.getStartingDirection();
        labyrinth_field_.setStartDirection(start_direction);

        char current_symbol;
        for (int row_count = 0; row_count < rows; row_count++)
        {
          for (int col_count = 0; col_count < cols; col_count++)
          {
            current_symbol = labyrinth[row_count][col_count];
            if(current_symbol == start_symbol)
            {
              //startpoint_row_=row_count;
              //startpoint_col_=col_count;
              //current_cell.convertToStartpoint();
              labyrinth_field_.convertToStartpoint(row_count,col_count);
            }
            else if(current_symbol == wall_symbol)
            {
              //current_cell.convertToWall();
              //labyrinth_field_.convertToWall(row_count,col_count);
            }
            else if(current_symbol == diamond_symbol)
            {
              //current_cell.convertToWay();
              //current_cell.setDiamond();
              labyrinth_field_.convertToWay(row_count,col_count);
              labyrinth_field_.setDiamond(row_count,col_count);
            }
            else if(current_symbol == way_symbol)
            {
              //current_cell.convertToWay();
              labyrinth_field_.convertToWay(row_count,col_count);
            }
            else if(current_symbol == one_symbol)
            {
              labyrinth_field_.convertToWay(row_count,col_count);
              labyrinth_field_.setCellMark(row_count,col_count,(int) 1);
            }
            else if(current_symbol == two_symbol)
            {
              labyrinth_field_.convertToWay(row_count,col_count);
              labyrinth_field_.setCellMark(row_count,col_count,(int) 2);
            }
            else if(current_symbol == three_symbol)
            {
              labyrinth_field_.convertToWay(row_count,col_count);
              labyrinth_field_.setCellMark(row_count,col_count,(int) 3);
            }
          }
        }
      }
      if(labyrinth_xml_content_handler_.isCreateLabyrinth()==true)
      {
        //System.out.println("isCreateLabyrinth()");
        set_num_diamonds = labyrinth_xml_content_handler_.getNumDiamonds();
        set_num_way_cells = labyrinth_xml_content_handler_.getNumWayCells();
        set_min_way_lenght = labyrinth_xml_content_handler_.getMinWayLenght();
        set_max_way_lenght = labyrinth_xml_content_handler_.getMaxWayLenght();
        set_build_angles = labyrinth_xml_content_handler_.getBuildAngles();
        set_build_trees = labyrinth_xml_content_handler_.getBuildTrees();
        set_build_places = labyrinth_xml_content_handler_.getBuildPlaces();
        set_build_loops = labyrinth_xml_content_handler_.getBuildLoops();

        create_labyrinth_ = new CreateLabyrinth(labyrinth_field_);
        create_labyrinth_.setNumDiamonds(set_num_diamonds);
        create_labyrinth_.setNumWayCells(set_num_way_cells);
        create_labyrinth_.setMinWayLenght(set_min_way_lenght);
        create_labyrinth_.setMaxWayLenght(set_max_way_lenght);
        create_labyrinth_.setBuildAngles(set_build_angles);
        create_labyrinth_.setBuildTrees(set_build_trees);
        create_labyrinth_.setBuildPlaces(set_build_places);
        create_labyrinth_.setBuildLoops(set_build_loops);

        create_labyrinth_.calculateWays();
        //System.out.println("calculateWays()");

        if(set_num_diamonds!=0)
        {
          //System.out.println("setDiamonds()");
          create_labyrinth_.setDiamonds();
        }
        labyrinth_field_=create_labyrinth_.getLabyrinthField();
      }

      is_style_=labyrinth_xml_content_handler_.isStyle();
    }
    catch(SAXException exc)
    {
      System.out.println("SAXException");
      System.err.println(exc.getMessage());
      System.err.println(exc.toString());
    }
    catch(ParserConfigurationException exc)
    {
      System.out.println("ParserConfigurationException");
      System.err.println(exc.getMessage());
    }
    catch(IOException exc)
    {
      System.out.println("IOException");
      System.err.println(exc.getMessage());
    }

  }

//------------------------------------------------------------------------------
/**
 *
 *
 */
  public LabyrinthField getLabyrinthField()
  {
    return labyrinth_field_;
  }



//------------------------------------------------------------------------------
/**
 * standard toString method for debugging
 * @return info about the labyrinth field in string-format
 */

  public String toString()
  {
    return("LoadLabyrinth: " +
           super.toString());
  }

  public boolean isStyle()
  {
    return is_style_;
  }

  public String getWallPicture()
  {
    return labyrinth_xml_content_handler_.getWallPicture();
  }

  public String getWayPicture()
  {
    return way_picture_ = labyrinth_xml_content_handler_.getWayPicture();
  }

  public String getRobotPicture()
  {
    return robot_picture_ = labyrinth_xml_content_handler_.getRobotPicture();
  }

  public String getDiamondPicture()
  {
    return diamond_picture_ = labyrinth_xml_content_handler_.getDiamondPicture();
  }

  public String getStartPicture()
  {
    return start_picture_ = labyrinth_xml_content_handler_.getStartPicture();
  }

}
