/*
 * Created on 12.09.2004
 *
 */
package PrintGame;

import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.XMLReader;
import org.xml.sax.SAXException;

import TUGLaby.LabyrinthChoosePanel;

import java.io.File;
import java.io.IOException;
import java.net.URL;

public class LevelHandler {

  private LoadLabyrinth load_labyrinth_; 
  private LoadLabyrinth load_labyrinth_backup_;
  private GameXMLContentHandler game_xml_content_handler_;
  private String wall_picture_;
  private String way_picture_;
  private String robot_picture_;
  private String diamond_picture_;
  private String start_picture_;
  private int num_levels_;
  private String file_;
  private String custom_level_filename_;
  private URL document_base_;
  private boolean is_not_default_style_;
  private boolean is_error_;
  private Direction initial_direction_; 

  public LevelHandler()
  {
    document_base_= null;
    custom_level_filename_ = null;
    is_not_default_style_=false;
	is_error_=false;
	initial_direction_=null;
  }

  public void setDocumentBase(URL document_base)
  {
    document_base_=document_base;
  }

  public void setCustomLevelFile(String filename)
  {
      custom_level_filename_ = filename;
  }
  
  public void loadGameXmlFile(String filename)
  {
    try
    {
      SAXParserFactory factory = SAXParserFactory.newInstance();
			factory.setValidating(true);
      SAXParser saxParser = factory.newSAXParser();
      XMLReader xmlReader = saxParser.getXMLReader();
      
	  game_xml_content_handler_ = new GameXMLContentHandler();
	  game_xml_content_handler_.setDocumentBase(document_base_);
      xmlReader.setContentHandler(game_xml_content_handler_);
			XMLErrorHandler xml_error_handler = new XMLErrorHandler();
			xmlReader.setErrorHandler(xml_error_handler);
      xmlReader.parse(filename);
			is_error_=xml_error_handler.isXMLError();
			if(is_error_==false)
			{
      	wall_picture_ = game_xml_content_handler_.getWallPicture();
      	way_picture_ = game_xml_content_handler_.getWayPicture();
      	robot_picture_ = game_xml_content_handler_.getRobotPicture();
      	diamond_picture_ = game_xml_content_handler_.getDiamondPicture();
      	start_picture_ = game_xml_content_handler_.getStartPicture();
      	num_levels_ = game_xml_content_handler_.getNumLevels();
			}
    }
    catch(SAXException exc)
    {
      System.err.println(exc.getMessage());
    }
    catch(ParserConfigurationException exc)
    {
      System.err.println(exc.getMessage());
    }
    catch(IOException exc)
    {
      System.err.println(exc.getMessage());
    }
  }

  public int getNumLevels()
  {
		if(is_error_==false)
    	return num_levels_;
		else 
			return -1;
  }

/**
* loadLevel is used to fill load_labyrinth_ with a LoadLabyrinth object which can be either a new one or a copy of the last one.
*@param number The level choosed in the LabyrinthChoosePanel
*@param keep_labyrinth Used to determine if the old labyrinth should be kept or a new one should be generated
*@author Bernhard Kornberger (mostly)
*/
  public boolean loadLevel(int number,boolean keep_labyrinth)
  {
		if(is_error_==false)
		{	
			if (number < LabyrinthChoosePanel.CUSTOM_LEVEL_TYPE) //not custom level
			    file_ = game_xml_content_handler_.getFile(number); //get filename from Game.xml
			else
			    file_ = custom_level_filename_;

		    
			if(keep_labyrinth)  // Keep the old labyrinth
			{
			    is_not_default_style_=false;
				load_labyrinth_=new LoadLabyrinth(load_labyrinth_backup_);
				is_not_default_style_=load_labyrinth_.isStyle();
				return true;
			}
			else // Create a new labyrinth and make a backup
			{
				if (file_ != null)
				{
				    is_not_default_style_=false;
					load_labyrinth_ = new LoadLabyrinth(file_, document_base_);
					load_labyrinth_backup_=new LoadLabyrinth(load_labyrinth_);
					is_not_default_style_=load_labyrinth_.isStyle();
					return true;
				}
			}
		}
		return false;
  }

  public void loadLevel(String filename)
  {
		if(is_error_==false)
		{
			is_not_default_style_=false;
			file_ = filename; 		
			
			load_labyrinth_ = new LoadLabyrinth(file_, document_base_);
			load_labyrinth_backup_=new LoadLabyrinth(load_labyrinth_);
			
			is_not_default_style_=load_labyrinth_.isStyle();
		}
  }
  
  public LabyrinthField getLabyrinthField()
  {
		if(is_error_==false)
    	return load_labyrinth_.getLabyrinthField();
		else
			return null;
		
  }

  public String getWallPicture()
  {

    if(is_not_default_style_)
    	return load_labyrinth_.getWallPicture();
    else
    	return wall_picture_;
  }

  public String getWayPicture()
  {
    if(is_not_default_style_)
      return load_labyrinth_.getWayPicture();
    else
      return way_picture_;
  }

  public String getRobotPicture()
  {
    if(is_not_default_style_)
      return load_labyrinth_.getRobotPicture();
    else
      return robot_picture_;
  }

  public String getDiamondPicture()
  {
    if(is_not_default_style_)
      return load_labyrinth_.getDiamondPicture();
    else
      return diamond_picture_;
  }

  public String getStartPicture()
  {
    if(is_not_default_style_)
      return load_labyrinth_.getStartPicture();
    else
      return start_picture_;
  }
  public boolean woar()
  {
  	return true;
  }

}
