package PrintGame;

import java.util.Random;

//----------------------------------------------------------------------
/**
 * class representing a two dimensional labyrinth
 */

public class RandomWayCoordinates
{

private int rows_, cols_;
private int random_row_, random_col_;
private Random random_generator_;

  public RandomWayCoordinates(int rows,int cols)
      throws IllegalArgumentException
    {
      if (rows <= 1)
        throw(new IllegalArgumentException(
          "rows must be >= 1"));
      if (cols <= 1)
        throw(new IllegalArgumentException(
        "rows must be >= 1"));
      random_generator_ = new Random();
      rows_=rows;
      cols_=cols;
      random_row_=-1;
      random_col_=-1;
  }

  public boolean findRandomWayCoordinates(LabyrinthField labyrinth_field)
  {
        random_row_=-1;
        random_col_=-1;
    int min=1;
    int max=labyrinth_field.getNumWayCells();
    int cell_number = getIntRandomValue(min, max);
    int rows_count, cols_count;
    int way_cell_counter=0;
    //Cell cell;
    for(rows_count=0;rows_count<rows_;rows_count++)
    {
      for(cols_count=0;cols_count<cols_;cols_count++)
      {
        //cell=(Cell)labyrinth_field.getElement(rows_count, cols_count);
        if((labyrinth_field.isWay(rows_count, cols_count)==true)&&(labyrinth_field.isStartpoint(rows_count, cols_count)==false))
          way_cell_counter++;
        if(way_cell_counter==cell_number)
        {
          random_row_=rows_count;
          random_col_=cols_count;
          return true;
        }
      }
    }
    return false;
  }

  public int getRandomWayRowCoordinate()
    throws IllegalArgumentException
  {
    if (random_row_ < 1)
      throw(new IllegalArgumentException(
            "random_row_ must be > 1"));
    return random_row_;
  }

  public int getRandomWayColCoordinate()
    throws IllegalArgumentException
  {
    if (random_col_ < 1)
      throw(new IllegalArgumentException(
            "random_col_ must be > 1"));
    return random_col_;
  }

  protected int getIntRandomValue(int min, int max)
  {
      return min + random_generator_.nextInt(max-min+1);
    }
}