/*
 * Created on 19.10.2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package PrintGame;

import java.net.URL;
import java.net.MalformedURLException;
import java.io.IOException;

import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.XMLReader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import javax.swing.JOptionPane;

import PrintGame.Action;
import PrintGame.Condition;
import PrintGame.Instruction;


/**
 *
 *
 */
public class TxtParser
{
	private String line_;

	private String condition_start_string_;
  private String condition_end_string_;
  private String action_start_string_;
  private String action_end_string_;
  private String condition_action_separator_string_;
  private String separator_string_;
  private String comment_out_line_string_;
  private String comment_out_start_string_;
  private String comment_out_end_string_;
  private String wall_string_;
  private String way_string_;
  private String direction_left_string_;
  private String direction_ahead_string_;
  private String direction_right_string_;
  private String direction_back_string_;
	private URL url_ = null;
	private String path_ = null;
	private InstructionTXTXMLContentHandler handler_;

	public TxtParser (URL url)
	{
	InstructionTXTXMLContentHandler handler_ = new InstructionTXTXMLContentHandler();
        try { path_ = (new URL(url, "config/InstructionTXT.xml")).toString();}
	catch (MalformedURLException ex) { System.err.println(ex.getMessage());}
    	try
    	{
	SAXParserFactory factory = SAXParserFactory.newInstance();
	factory.setValidating(true);   //neu
	SAXParser saxParser = factory.newSAXParser();
	XMLReader xmlReader = saxParser.getXMLReader();
	handler_ = new InstructionTXTXMLContentHandler();
	xmlReader.setContentHandler(handler_);
	XMLErrorHandler xml_error_handler = new XMLErrorHandler();
	xmlReader.setErrorHandler(xml_error_handler);
	xmlReader.parse(path_);
	}
	catch(SAXParseException exc)
	{
		System.out.println("ERROR");
		System.out.println("In File " + exc.getSystemId());
		System.out.println(exc.getMessage());
	}
	catch(SAXException exc)
	{
		System.out.println("SAXException");
		System.err.println(exc.getMessage());
		System.err.println(exc.toString());
	}
	catch(ParserConfigurationException exc)
	{
		System.out.println("ParserConfigurationException");
		System.err.println(exc.getMessage());
	}
	catch(IOException exc)
	{
		System.out.println("IOException");
		System.err.println(exc.getMessage());
	}

	condition_start_string_ = handler_.ConditionStartString();
  condition_end_string_= handler_.ConditionEndString();
  action_start_string_= handler_.ActionStartString();
  action_end_string_= handler_.ActionEndString();
  condition_action_separator_string_= handler_.ConditionActionSeparatorString();
  separator_string_= handler_.SeparatorString();
	comment_out_line_string_= handler_.CommentOutLineString();
  comment_out_start_string_= handler_.CommentOutStartString();
  comment_out_end_string_= handler_.CommentOutEndString();
  wall_string_= handler_.WallString();
  way_string_= handler_.WayString();
  direction_left_string_= handler_.DirectionLeftString();
  direction_ahead_string_= handler_.DirectionAheadString();
  direction_right_string_= handler_.DirectionRightString();
  direction_back_string_= handler_.DirectionBackString();
	}


	private Instruction parseLine(String line, int linecount)
	throws IllegalArgumentException
	{
		boolean wall_left = false;
		boolean wall_right = false;
		boolean wall_ahead = false;
		//Integer state,cell_mark,new_state,new_mark;
		int dir=0;
    Condition condi;
		Action acti;
    String tmp_condition;
    String tmp_action;
    Instruction instruction;
		line = line.trim();



     if(line.startsWith(comment_out_line_string_))
     {
       instruction=null;
     }
     else
     {
        int cond_act_sep=line.indexOf(condition_action_separator_string_);
        if(cond_act_sep==-1)
          throw(new IllegalArgumentException("Syntax Error in instruction "+linecount));
        else
        {
          tmp_condition=line.substring(0, cond_act_sep);
          tmp_action=line.substring(cond_act_sep+condition_action_separator_string_.length());
        }
        //seperate Condition and Action
        if(tmp_condition.startsWith(condition_start_string_)==false)
              throw(new IllegalArgumentException("Syntax Error in instruction "+linecount));

        if(tmp_condition.endsWith(condition_end_string_)==false)
              throw(new IllegalArgumentException("Syntax Error in instruction"+linecount));

        if(tmp_action.startsWith(action_start_string_)==false)
              throw(new IllegalArgumentException("Syntax Error in instruction "+linecount));

        if(tmp_action.endsWith(action_end_string_)==false)
        {
              int end=tmp_action.indexOf(action_end_string_)+action_end_string_.length();
              String comment=tmp_action.substring(end+action_end_string_.length()-1);
              comment=comment.trim();
              if(comment.startsWith(comment_out_line_string_)==false)
              throw(new IllegalArgumentException("Syntax Error in instruction "+linecount));
        }
        //parse Condition, seperate sensors, state and cell mark
        tmp_condition=tmp_condition.trim();
        int first_seperator=tmp_condition.indexOf(separator_string_);
        int second_seperator=tmp_condition.indexOf(separator_string_, first_seperator+1);
        if(first_seperator==-1||second_seperator==-1)
          throw(new IllegalArgumentException("Condition Syntax Error in instruction "+linecount+": to less arguments"));

        int third_seperator=tmp_condition.indexOf(separator_string_, second_seperator+1);
        if(third_seperator!=-1)
          throw(new IllegalArgumentException("Condition Syntax Error in instruction "+linecount+": to many arguments"));

        String condition_sensors=tmp_condition.substring(condition_start_string_.length(),first_seperator);
        condition_sensors=condition_sensors.trim();
    //     System.out.println("Sensors found: "+condition_sensors);

        String condition_state=tmp_condition.substring(first_seperator+separator_string_.length(),second_seperator);
        condition_state=condition_state.trim();
        if(condition_state.length()<1)
          throw(new IllegalArgumentException("Condition Syntax Error in instruction "+linecount+": state not found"));
        else if (condition_state.length()>30)
          throw(new IllegalArgumentException("Condition Syntax Error in instruction "+linecount+": state string is too long"));

    //     System.out.println("State found: "+condition_state);
        String condition_cellmark=tmp_condition.substring(second_seperator+separator_string_.length(),tmp_condition.indexOf(condition_end_string_));
        condition_cellmark=condition_cellmark.trim();
        if(condition_cellmark.length()<1)
          throw(new IllegalArgumentException("Condition Syntax Error in instruction "+linecount+": cellmark not found"));
        else if (condition_cellmark.length()>30)
          throw(new IllegalArgumentException("Condition Syntax Error in instruction "+linecount+": cellmark string is too long"));
    //     System.out.println("Cellmark found: "+condition_cellmark);




        //parse Sensors,
        // left sensor
        if(condition_sensors.regionMatches(true,0,wall_string_,0,wall_string_.length())==true)
        {
          wall_left=true;
    //       System.out.println("wall_left");
          condition_sensors=condition_sensors.substring(wall_string_.length());
        }
        else if(condition_sensors.regionMatches(true,0,way_string_,0,way_string_.length())==true)
              condition_sensors=condition_sensors.substring(way_string_.length());
        else if(condition_sensors.length()==0)
          throw(new IllegalArgumentException("Condition Syntax Error in instruction "+linecount+": wrong parameter count for sensors"));
        else
          throw(new IllegalArgumentException("Condition Syntax Error in instruction "+linecount+": wrong parameter for left sensor"));

        // head sensor
        condition_sensors=condition_sensors.trim();
        if(condition_sensors.regionMatches(true,0,wall_string_,0,wall_string_.length())==true)
        {
          wall_ahead=true;
    //       System.out.println("wall_ahead");
          condition_sensors=condition_sensors.substring(wall_string_.length());
        }
        else if(condition_sensors.regionMatches(true,0,way_string_,0,way_string_.length())==true)
              condition_sensors=condition_sensors.substring(way_string_.length());
        else if(condition_sensors.length()==0)
          throw(new IllegalArgumentException("Condition Syntax Error in instruction "+linecount+": wrong parameter count for sensors"));
        else
          throw(new IllegalArgumentException("Condition Syntax Error in instruction "+linecount+": wrong parameter for ahead sensor"));

        // right sensor
        condition_sensors=condition_sensors.trim();
        if(condition_sensors.regionMatches(true,0,wall_string_,0,wall_string_.length())==true)
        {
          wall_right=true;
    //       System.out.println("wall_right");
          condition_sensors=condition_sensors.substring(wall_string_.length());
        }
        else if(condition_sensors.regionMatches(true,0,way_string_,0,way_string_.length())==true)
              condition_sensors=condition_sensors.substring(way_string_.length());
        else if(condition_sensors.length()==0)
          throw(new IllegalArgumentException("Condition Syntax Error in instruction "+linecount+": wrong parameter count for sensors"));
        else
          throw(new IllegalArgumentException("Condition Syntax Error in instruction "+linecount+": wrong parameter for right sensor"));

        condition_sensors=condition_sensors.trim();
        if(condition_sensors.length()!=0)
          throw(new IllegalArgumentException("Condition Syntax Error in instruction "+linecount+": wrong parameter count for sensors"));



        //parse Action,
        tmp_action=tmp_action.trim();
          first_seperator=tmp_action.indexOf(separator_string_);
          second_seperator=tmp_action.indexOf(separator_string_, first_seperator+1);
        if(first_seperator==-1||second_seperator==-1)
          throw(new IllegalArgumentException("Action Syntax Error in instruction "+linecount+": to less arguments"));

          third_seperator=tmp_action.indexOf(separator_string_, second_seperator+1);
        if(third_seperator!=-1)
          throw(new IllegalArgumentException("Action Syntax Error in instruction "+linecount+": to many arguments"));

        String action_cellmark=tmp_action.substring(action_start_string_.length(),first_seperator);
        action_cellmark=action_cellmark.trim();
        if(action_cellmark.length()<1)
          throw(new IllegalArgumentException("Action Syntax Error in instruction "+linecount+": cellmark not found"));
        else if (action_cellmark.length()>30)
          throw(new IllegalArgumentException("Action Syntax Error in instruction "+linecount+": cellmark string is too long"));

    //      System.out.println("action cellmark found: "+action_cellmark);

        String direction=tmp_action.substring(first_seperator+separator_string_.length(),second_seperator);
        direction=direction.trim();
    //     System.out.println("Direction found: "+direction);

        String action_state=tmp_action.substring(second_seperator+separator_string_.length(),tmp_action.indexOf(action_end_string_));
        action_state=action_state.trim();
        if(action_state.length()<1)
          throw(new IllegalArgumentException("Action Syntax Error in instruction "+linecount+": state not found"));
        else if (action_state.length()>30)
          throw(new IllegalArgumentException("Action Syntax Error in instruction "+linecount+": state string is too long"));
    //     System.out.println("action state found: "+action_state);

        //parse Direction

        if((direction.regionMatches(true,0,direction_left_string_,0,direction_left_string_.length())==true)&& (direction.length()==direction_left_string_.length()))
          dir=4;
        else if((direction.regionMatches(true,0,direction_ahead_string_,0,direction_ahead_string_.length())==true)&&
        (direction.length()==direction_ahead_string_.length()))
        dir=1;
        else if((direction.regionMatches(true,0,direction_right_string_,0,direction_right_string_.length())==true)&& (direction.length()==direction_right_string_.length()))
              dir=2;
        else if((direction.regionMatches(true,0,direction_back_string_,0,direction_back_string_.length())==true)&& (direction.length()==direction_back_string_.length()))
          dir=3;
        else
          throw(new IllegalArgumentException("Action Syntax Error in instruction "+linecount+": wrong parameter for direction"));

      condi = new Condition(0,"",wall_left,wall_right,wall_ahead);
      acti = new Action(0,"",dir);
      instruction = new Instruction(condi,acti);
      }
   return instruction;
	}

public InstructionList parseText(String textstring)
  {
  String text=textstring;
  InstructionList instructions;
  instructions = new InstructionList();
  int linecount=0;
  int line_end=0;
  int line_start=0;

  try
  {
    if(text.endsWith("\n")==false)
      text=text.concat("\n");

    line_end=text.indexOf("\n",line_end);
    while(line_end!=-1)
    {
      linecount++;
      String line="";
      line=text.substring(line_start,line_end);
      line=line.trim();
      line_start=line_end;
      line_end++;
      if(line.length()!=0)
      {
        Instruction new_instruction;
        new_instruction=parseLine(line, linecount);
        if(new_instruction!=null)
          instructions.addInstruction(new_instruction);
      }
      line_end=text.indexOf("\n",line_end);
    }
  }
  catch(IllegalArgumentException exc)
    {
      System.err.println(exc.getMessage());
       JOptionPane error;
       error=new JOptionPane();
       error.showMessageDialog(null, exc.getMessage(), "Marvin-10 Programmfehler", error.ERROR_MESSAGE);
    }
  return instructions;
  }


	/*public Instruction parseLine(String line){
		//line_ = line;
		//System.out.println("in parseLine");
		boolean wall_left = false;
		boolean wall_right = false;
		boolean wall_ahead = false;
		Integer state,cell_mark,new_state,new_mark;
		Condition condi;
		Action acti;
		int action_start,direction = 0;


		if(line.charAt(1) == 'F')
			wall_left = true;
		if(line.charAt(2) == 'F')
			wall_ahead = true;
		if(line.charAt(3) == 'F')
			wall_right = true;

		//state = new Integer(line.charAt(5));
		state = new Integer(Character.digit((line.charAt(5)),10));

		//check for -1
		if(line.charAt(7) == '-')
			cell_mark = new Integer(-1*Character.digit(line.charAt(8),10));
		else
			cell_mark = new Integer(Character.digit(line.charAt(7),10));

		condi = new Condition(state.intValue(),cell_mark.intValue(),wall_left,wall_right,wall_ahead);

		action_start = line.indexOf('>');

		if(line.charAt(action_start+2) == '-' )
			new_mark = new Integer(-1*Character.digit(line.charAt(action_start+3),10));
		else
			new_mark = new Integer(Character.digit(line.charAt(action_start+2),10));


	//		new_mark = new Integer(line.substring(action_start+2,action_start+4));
	//	else
	//		new_mark = new Integer(line.charAt(action_start+2));

		action_start = line.indexOf('n');

		if(line.charAt(action_start+1) == ',')
			direction = 2;
		else if(line.charAt(action_start+5) == 'v')
			direction = 1;
		else if(line.charAt(action_start+5) == 'l')
			direction = 3;
		else if(line.charAt(action_start+5) == 'r')
			direction = 4;

		//find last closing bracket, start at end of -> sign
		new_state = new Integer(Character.digit(line.charAt(line.indexOf(')',line.indexOf('>'))-1),10));

		acti = new Action(new_state.intValue(),new_mark.intValue(),direction);

		return new Instruction(condi,acti);
	}*/
}
