/*
 * Created on 29.09.2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package TUGLaby;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JPanel;
import javax.swing.JRadioButton;

/**
 * Contains the RadioButtons shown in the GUI, used to determine a level.
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class LabyrinthChoosePanel extends JPanel implements MouseListener {
    public final static int COUNT_LEVEL_TYPES = 6;
    public final static int CUSTOM_LEVEL_TYPE = 6; //type is index + 1
    private JRadioButton labyrinth_type_radio_[];
    private static final int START_X = 1;
    private static final int START_Y = 1;
    private static final int SIZE_X = 70;
    private static final int SIZE_Y = 10;
    private static final int DIST_Y = 1;
    private int current_selected_;
	private TUGLabyrinth top;

    /**
     *  This is the RadioButton field, used to choose one of the levels
	 * @param preset The level which is active at start time
	 * @param top_object_ The top level object TUGLaby, necessary because the action listener within this class needs to call its drawNewLabyrinth method
     */
    public LabyrinthChoosePanel(int preset,TUGLabyrinth top_object_) {
        super();
		top=top_object_;
        this.setLayout(new FlowLayout(FlowLayout.LEFT));
        this.setBackground(Color.ORANGE);
        current_selected_ = preset;
        labyrinth_type_radio_ = new JRadioButton[COUNT_LEVEL_TYPES];

        for (int i = 0; i < COUNT_LEVEL_TYPES; i++) {

            labyrinth_type_radio_[i] = new JRadioButton();
            labyrinth_type_radio_[i].setBackground(Color.ORANGE);
            if (i == (preset - 1))
                labyrinth_type_radio_[i].setSelected(true);
            else
                labyrinth_type_radio_[i].setSelected(false);

            labyrinth_type_radio_[i].addMouseListener(this);
            add(labyrinth_type_radio_[i]);

        }
        labyrinth_type_radio_[0].setText("Leichtes Labyrinth");
        labyrinth_type_radio_[1].setText("Schweres Labyrinth");
        labyrinth_type_radio_[2].setText("Labyrinth mit Loops");
        labyrinth_type_radio_[3].setText("Freies Feld");
		    labyrinth_type_radio_[4].setText("Labyrinth mit Pltzen");
		    labyrinth_type_radio_[5].setText("Benutzerdefiniert");
    }
    
    public int getCurrentSelected() {
        return current_selected_;
    }
    
    public void setSelected(int select_type)
    {
        for (int i = 0; i < COUNT_LEVEL_TYPES; i++) {
            if (select_type-1 == i) {
                labyrinth_type_radio_[i].setSelected(true);
                current_selected_ = i + 1;
            } else
                labyrinth_type_radio_[i].setSelected(false);
        }        
    }

    public void mouseClicked(MouseEvent event) {
        for (int i = 0; i < COUNT_LEVEL_TYPES; i++) {
            if (((JRadioButton) event.getSource()) == labyrinth_type_radio_[i]) {
                labyrinth_type_radio_[i].setSelected(true);
                current_selected_ = i + 1;
            } else
                labyrinth_type_radio_[i].setSelected(false);
        }
		top.drawNewLabyrinth();
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

}
