package TUGLaby;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.io.InputStreamReader;
import java.io.BufferedReader;
import java.io.IOException;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JFileChooser;

//-----------------------------
import java.net.*;
import javax.swing.*;
import java.awt.*;
import java.util.LinkedList;
//-------------------------------
import PrintGame.Action;
import PrintGame.Condition;
import PrintGame.IllegalDirectionException;
import PrintGame.Instruction;
import PrintGame.InstructionList;

import PrintGame.LabyrinthField;
import PrintGame.LevelHandler;
import PrintGame.LoadInstructions;
import PrintGame.PrintLabyrinth;
import PrintGame.Robot;
import PrintGame.TuringMachine;
import PrintGame.WriteInstructionsToXML;
import PrintGame.WriteLabToXML;
import PrintGame.TxtParser;
import PrintGame.Cell;
import PrintGame.XpertMode;
/*
 * JApplet.java
 *
 * Created on 16. August 2004, 22:30
 */

/**
 * The Top level class
 * @author user
 */
public class TUGLabyrinth extends javax.swing.JApplet implements Runnable {
    private javax.swing.JApplet mainframe_ = this;
    private static final long serialVersionUID = 7538087491086535801L;
    private static final int height = 580;
    private static final int width = 950;
    private static final int max_characters_ = 2000;
    private RuleTreePanel rule_tree_panel_;
    //private RulesBrickPanel rules_brick_panel_;
    private JScrollPane rule_tree_scrollpane_;
    private LabyrinthChoosePanel lab_choose_panel_;
    private HashMap brick_images_;
    private JButton start_button_;
	  private JButton help_button_;
    private JButton draw_button_;
	  private JButton load_lab_button_;
	  private JButton save_lab_button_;
	  private JButton new_rule_button_;
	  private JButton load_rules_button_;
	  private JButton save_rules_button_;
    private JButton xpert_mode_button_;
    private JButton rules_; // NEU
    private JButton labyrinth_; // NEU
    private JButton level_of_difficulty_; //NEU
    private JButton low_score_; //NEU
    private String image_folder_;
    protected Thread th_;
    protected int level_type_;
	  public boolean redrawLabyrinth;
    private TextArea ta_;
    /**
     * ADDED FROM PrintGame
     * *********************************************************
     */
    protected final static boolean create_labyrinth_ = false; // Switch, nur
    // derzeit ntig
    //number of cells in a row and a col
    protected final static int ROWS = 20;
    protected final static int COLS = 20;
    //size of the labyrinth
    //    protected final static int LABYRINTH_HEIGHT = ROWS * CELL_HEIGHT;
    //    protected final static int LABYRINTH_WHITH = COLS * CELL_WHITH;
    Image way, wall, robot, diamond;
    protected static LabyrinthField labyrinth_field_;
    protected static LevelHandler level_handler_;
    protected static Robot robot_;
    protected static WriteLabToXML write_lab_;
    protected InstructionList instruct_list_;
    protected TuringMachine turing_machine_;
    protected PrintLabyrinth print_labyrinth_;
    protected boolean ready_to_run_;
    protected String file_name_;
    protected String custom_level_filename_;

    //protected BufferedReader in;          NOCH NTIG ?

    /**
     * ADDED FROM PrintGame
     */

    /** Initializes the applet JApplet
	* Draws the applet and some of its buttons. Adds action listeners.
	* One of the object trees which may help you to understand the source is: Applet->LevelHandler->LoadLabyrinth->LabyrinthField
	*/
    public void init() {
		String version = System.getProperty("java.version");
		System.out.print("Java Version: "+version+"\n");

		version = System.getProperty("java.class.version");
		System.out.print("Java Class Version: "+version+"\n");

    	/*try{
    		in = new BufferedReader(new InputStreamReader(
    				new URL(this.getDocumentBase(),"instructions.txt").openStream()));
    		in.mark(max_characters_);
    	}catch(Exception e){in = null;}
	*/
    	// BEGIN OF WINDOW SETUP ****************************************************************
        getContentPane().setLayout(null);
        this.setSize(width, height);

        String abs_filename = getParameter("abs_filename");

        abs_filename = "Games/Game.xml";
        ready_to_run_ = false;
        level_type_ = 1;

		// Add jButtons and jRadioButtons
        start_button_ = new JButton();
		help_button_ =  new JButton();
		draw_button_ = new JButton();
		load_lab_button_ = new JButton();
		save_lab_button_ = new JButton();
		new_rule_button_ = new JButton();
		load_rules_button_ = new JButton();
		save_rules_button_ = new JButton();
    xpert_mode_button_= new JButton();
    rules_= new JButton(); // NEU
    labyrinth_= new JButton(); // NEU
    level_of_difficulty_= new JButton(); //NEU
    low_score_ =new JButton(); //NEU

		lab_choose_panel_ = new LabyrinthChoosePanel(1,this);
    getContentPane().add(start_button_);
		getContentPane().add(help_button_);
		getContentPane().add(draw_button_);
		getContentPane().add(load_lab_button_);
		getContentPane().add(save_lab_button_);
		getContentPane().add(new_rule_button_);
    getContentPane().add(lab_choose_panel_);
    getContentPane().add(load_rules_button_);
    getContentPane().add(save_rules_button_);
    getContentPane().add(xpert_mode_button_);
    getContentPane().add(rules_);
    getContentPane().add(labyrinth_);
    getContentPane().add(level_of_difficulty_);
    getContentPane().add(low_score_);


		// Images -> HashMap "brick_images_"
        loadImages();

        rule_tree_panel_ = new RuleTreePanel(brick_images_);
		// Initially display 4 Rules - this is done for usablility reasons.
		for(int i=0;i<4;i++) rule_tree_panel_.addNewRule("ConditionRule");

        //rules_brick_panel_ = new RulesBrickPanel(brick_images_,rule_tree_panel_);
        rule_tree_panel_.setPreferredSize(new Dimension(250, height - 10));
        rule_tree_scrollpane_ = new JScrollPane(rule_tree_panel_);

        print_labyrinth_ = new PrintLabyrinth(brick_images_, robot_, null);

        getContentPane().add(rule_tree_scrollpane_);
        //getContentPane().add(rules_brick_panel_);
        getContentPane().add(print_labyrinth_);

        rule_tree_scrollpane_.setBounds(5, 35, 268, height - 40 + 1);
        //rules_brick_panel_.setBounds(280, 35, 243, 62);
        print_labyrinth_.setBounds(280, 90, 400, 400);
				print_labyrinth_.setBackground(Color.ORANGE);

        lab_choose_panel_.setBounds(700, 50, 200, 170);
        //lab_choose_panel_.setBounds(700, 5, 200, 170);

        URL new_url = null;
        try {
            new_url = new URL(getDocumentBase(), abs_filename);
        } catch (MalformedURLException ex) {
            System.err.println(ex.getMessage());
        }
        this.getContentPane().setBackground(Color.ORANGE);
        file_name_ = new_url.toString(); // "Game.xml", Level-Info

		// END OF WINDOW SETUP *************************************************

    // BEGIN OF RULE BUTTON  ***********************************************
        rules_.setBounds(273,5,115,28);//(120,5,153,28);
        rules_.setBackground(new Color(127,127,127));
        rules_.setForeground(Color.ORANGE);
        rules_.setText("Regelstze");
    // END OF RULE BUTTON **************************************************

    // BEGIN OF LABYRINTH BUTTON  ******************************************
       labyrinth_.setBounds(388,5,115,28);
       labyrinth_.setBackground(new Color(127,127,127));
       labyrinth_.setForeground(Color.ORANGE);
       labyrinth_.setText("Labyrinth");
    // END OF LABYRINTH BUTTON *********************************************

    // BEGIN OF LEVEL OF DIFFICULT BUTTON  *********************************
       level_of_difficulty_.setBounds(503,5,180,28);
       level_of_difficulty_.setBackground(new Color(127,127,127));
       level_of_difficulty_.setForeground(Color.ORANGE);
       level_of_difficulty_.setText("Schwierigkeitsgrad");
    // END OF LEVEL OF DIFFICULT BUTTON ************************************

    // BEGIN OF LOWSCORE BUTTON  *******************************************
       low_score_.setBounds(683,5,150,28);
       low_score_.setBackground(new Color(127,127,127));
       low_score_.setForeground(Color.ORANGE);
       low_score_.setText("Bestenliste");
    // END OF LOWSCORE BUTTON **********************************************

    // BEGIN OF NEW RULE BUTTON  *******************************************
        //new_rule_button_.setBounds(5,5,89,28);
        new_rule_button_.setBounds(5,5,115,28);
        new_rule_button_.setBackground(new Color(127,127,127));
        new_rule_button_.setForeground(Color.ORANGE);
        //new_rule_button_.setText("add");
        new_rule_button_.setText("Hinzufgen");

        new_rule_button_.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) { // Load rules button pressed

                rule_tree_panel_.addNewRule("ConditionRule");
            }
        });
        // END OF NEW RULE BUTTON **************************************************


        // BEGIN OF LOAD RULES BUTTON  *********************************************
        /*load_rules_button_.setBounds(94,5,89,28);
        load_rules_button_.setBackground(new Color(127,127,127));
        load_rules_button_.setForeground(Color.ORANGE);
        load_rules_button_.setText("Load");

        load_rules_button_.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) { // Load rules button pressed

                String filename;
/*              FileOpenService fos = null;
                FileContents fileContents = null;

                try {
                    fos = (FileOpenService)ServiceManager.
                              lookup("javax.jnlp.FileOpenService");
                } catch (UnavailableServiceException exc) { }

                if (fos != null) {
                    try {
                        fileContents = fos.openFileDialog(null, null);
                    } catch (Exception exc) {
                        System.err.println("Open command failed: "
                                   + exc.getLocalizedMessage());
                    }
                }

                if (fileContents != null) {
                    try {
                        //This is where a real application would do something
                        //with the file.
                        filename = fileContents.getName();

                        LoadInstructions rules_loader =
                            new LoadInstructions(filename, mainframe_.getDocumentBase());
                        instruct_list_ = rules_loader.getInstructionList();

                        TUGLabyrinth.this.rule_tree_panel_.deleteAllRules();

                        for (int i = 0; i < instruct_list_.size(); i++) {
                        	Instruction dummy = instruct_list_.getInstructionAtPos(i);
                        	TUGLabyrinth.this.rule_tree_panel_.addNewRule(dummy);
                        }
                    } catch (IOException exc) {
                        System.err.println("Problem opening file: "
                                   + exc.getLocalizedMessage());
                    }
                }*/


               /* JFileChooser chooser = new JFileChooser();
                int returnVal = chooser.showOpenDialog(null);
                if(returnVal == JFileChooser.APPROVE_OPTION) {
                   filename = chooser.getSelectedFile().getPath();
                   LoadInstructions rules_loader =
                       new LoadInstructions(filename, mainframe_.getDocumentBase());
                   instruct_list_ = rules_loader.getInstructionList();

                   TUGLabyrinth.this.rule_tree_panel_.deleteAllRules();

                   for (int i = 0; i < instruct_list_.size(); i++) {
                   		Instruction dummy = instruct_list_.getInstructionAtPos(i);
                   		TUGLabyrinth.this.rule_tree_panel_.addNewRule(dummy);
                    }
                }
            }
        });*/
        // END OF LOAD RULES BUTTON ************************************************


		// BEGIN OF SAVE RULES BUTTON  *********************************************
       /* save_rules_button_.setBounds(183,5,89,28);
        save_rules_button_.setBackground(new Color(127,127,127));
        save_rules_button_.setForeground(Color.ORANGE);
        save_rules_button_.setText("Save");

        save_rules_button_.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) { // Load rules button pressed

                String filename, folder;
                JFileChooser chooser = new JFileChooser();
                int returnVal = chooser.showSaveDialog(null);
                if(returnVal == JFileChooser.APPROVE_OPTION) {
                	instruct_list_ = new InstructionList();
                    LinkedList listi = TUGLabyrinth.this.rule_tree_panel_
                            .getRuleList();

                   	for (int i = 0; i < listi.size(); i++) {
                   		Instruction dummy = ((ConditionRulePanel) listi.get(i)).getInstruction();
                  		instruct_list_.addInstruction(dummy);
                		System.out.print(dummy);
                    }

                   	filename = chooser.getSelectedFile().getPath();
                   	folder = chooser.getSelectedFile().getParent();
                    WriteInstructionsToXML rules_saver =
                       new WriteInstructionsToXML(instruct_list_);
                    rules_saver.writeXMLFile(filename);

                    rules_saver.writeDTDFile(folder);
                }
            }
        });*/
        // END OF SAVE RULES BUTTON **************************************************


		// BEGIN OF START BUTTON  ****************************************************
        start_button_.setBounds(710,350, 150, 30);
        start_button_.setBackground(new Color(127,127,127));
        start_button_.setForeground(Color.ORANGE);
        start_button_.setText("Start !");

        start_button_.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) { // START BUTTON PRESSED
                System.out.println("\n START BUTTON PRESSED, Rule Tree -->");
            	 String l;
            	instruct_list_ = new InstructionList();
                LinkedList listi = TUGLabyrinth.this.rule_tree_panel_.getRuleList();


                /*if(in != null){ // NOT executed at normal operation
                	try{
                		in.reset();
                		while((l = in.readLine()) != null){
                			System.out.println("Line read: " + l);
                			Instruction dummy = parser_.parseLine(l);
                			System.out.println("Line parsed: " + dummy);
                			instruct_list_.addInstruction(dummy);
                			System.out.println("dummy: " + dummy);
                		}
               		}catch(Exception e){System.out.println("while:"+e.getMessage());}
                }else{ // this is executed at normal operation
                	for (int i = 0; i < listi.size(); i++) {
                		Instruction dummy = ((ConditionRulePanel) listi.get(i)).getInstruction();
                		instruct_list_.addInstruction(dummy);
                		System.out.print(dummy);
                		}
                }*/
		// ------------------------------------------------------------------------------------------
		for (int i = 0; i < listi.size(); i++) {
                		Instruction dummy = ((ConditionRulePanel) listi.get(i)).getInstruction();
                		instruct_list_.addInstruction(dummy);
                		System.out.print(dummy);
                		}
		// ------------------------------------------------------------------------------------------

                level_handler_.loadLevel(lab_choose_panel_.getCurrentSelected(),true); // responsible for drawing, param: (level, keepLabyrinth)
				ready_to_run_ = true;
      			labyrinth_field_ = level_handler_.getLabyrinthField();
				th_ = new Thread(TUGLabyrinth.this);
				th_.start();// => Calls run()
            }
        });

        // END OF START BUTTON ****************************************************


    // BEGIN OF HELP BUTTON  ***********************************************
        //help_button_.setBounds(710, 190, 150, 30);
        help_button_.setBounds(833, 5, 100, 28);
        help_button_.setBackground(new Color(127,127,127));
        help_button_.setForeground(Color.ORANGE);
        //new_rule_button_.setText("add");
        help_button_.setText("Hilfe");

        help_button_.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
              HelpWindow help_window=new HelpWindow(getCodeBase());
              help_window.showHelpWindow();
            }
        });
    // END OF HELP BUTTON **************************************************

		// BEGIN OF EXPERTEN-MODUS BUTTON ****************************************************
		{
      xpert_mode_button_.setBounds(120,5,153,28);
			xpert_mode_button_.setBackground(new Color(127,127,127));
			xpert_mode_button_.setForeground(Color.ORANGE);
			xpert_mode_button_.setText("Experten-Modus");
			xpert_mode_button_.addActionListener
			(new java.awt.event.ActionListener()
				{public void actionPerformed(java.awt.event.ActionEvent evt)
					{
						 instruct_list_ = new InstructionList();
             LinkedList listi = TUGLabyrinth.this.rule_tree_panel_.getRuleList();

            for (int i = 0; i < listi.size(); i++)
            {
              Instruction dummy = ((ConditionRulePanel) listi.get(i)).getInstruction();
              instruct_list_.addInstruction(dummy);
              System.out.print(dummy);
            }

             JFrame frame_;
             JButton submit_button_;
             URL url_;
             //ta_ = new TextArea("(FGF,0,-1)aus->(-1,nach vorn,0)\n(GFF,0,-1)aus->(-1,nach links,0)\n(FFG,0,-1)aus->(-1,nach rechts,0)\n(FFF,0,-1)aus->(-1,umdrehen,0)");
             ta_ = new TextArea();
             final XpertMode xpert= new XpertMode();
             xpert.setUrl(getDocumentBase());

             submit_button_ = new JButton();
             submit_button_.setBounds(5,5,89,28);
             submit_button_.setBackground(new Color(127,127,127));
             submit_button_.setForeground(Color.ORANGE);
             submit_button_.setText("Regelsatz bernehmen");
             submit_button_.addActionListener
            (new java.awt.event.ActionListener()
              {public void actionPerformed(java.awt.event.ActionEvent evt)
                {
                 rule_tree_panel_.deleteAllRules();
                 instruct_list_=xpert.getRuleList(ta_);
                 for(int count=0;count<instruct_list_.size();count++)
                 {
                  Instruction tmp_instruction=instruct_list_.getInstructionAtPos(count);
                  rule_tree_panel_.addNewRule(tmp_instruction);
                 }
                }
              }
            );
             frame_ = new JFrame("Marvin-10 Experten-Modus");
             frame_.getContentPane().setLayout(new BorderLayout());
             frame_.getContentPane().add(submit_button_, BorderLayout.SOUTH);
             frame_.getContentPane().add(ta_, BorderLayout.CENTER);
             frame_.setSize(300,600 );
             frame_.setVisible(true);

             xpert.outputRuleList(instruct_list_, ta_);
					}
				}
			);
		}
		// END EXPERTEN-MODUS BUTTON ********************************************************

		// DRAW BUTTON ************************************************************
		{
			draw_button_.setBounds(710, 230, 150, 30);
			draw_button_.setBackground(new Color(127,127,127));
			draw_button_.setForeground(Color.ORANGE);
			draw_button_.setText("Neues Labyrinth");
			draw_button_.addActionListener
			(new java.awt.event.ActionListener()
				{public void actionPerformed(java.awt.event.ActionEvent evt)
					{
						drawNewLabyrinth();
					}
				}
			);
		}
		// END DRAW BUTTON ********************************************************

		// LOAD LAB BUTTON ********************************************************
		{
			load_lab_button_.setBounds(710, 270, 150, 30);
			load_lab_button_.setBackground(new Color(127,127,127));
			load_lab_button_.setForeground(Color.ORANGE);
			load_lab_button_.setText("Labyrinth laden");
			load_lab_button_.addActionListener
			(new java.awt.event.ActionListener()
				{public void actionPerformed(java.awt.event.ActionEvent evt)
					{
	                	String filename;
	                	JFileChooser chooser = new JFileChooser();
	                	int returnVal = chooser.showOpenDialog(null);
	                	if(returnVal == JFileChooser.APPROVE_OPTION) {
	                	    filename = chooser.getSelectedFile().getPath();
	                	    custom_level_filename_ = filename;
		                	lab_choose_panel_.setSelected(LabyrinthChoosePanel.CUSTOM_LEVEL_TYPE);
							drawNewLabyrinth();
	                	}
					}
				}
			);
		}
		// END LOAD LAB BUTTON ****************************************************

		// SAVE LAB BUTTON ********************************************************
		{
			save_lab_button_.setBounds(710, 310, 150, 30);
			save_lab_button_.setBackground(new Color(127,127,127));
			save_lab_button_.setForeground(Color.ORANGE);
			save_lab_button_.setText("Labyrinth speichern");
			save_lab_button_.addActionListener
			(new java.awt.event.ActionListener()
				{public void actionPerformed(java.awt.event.ActionEvent evt)
					{
	                	String filename, folder;
	                	JFileChooser chooser = new JFileChooser();
	                	int returnVal = chooser.showSaveDialog(null);
	                	if(returnVal == JFileChooser.APPROVE_OPTION) {
	                	    filename = chooser.getSelectedFile().getPath();
	                	    folder = chooser.getSelectedFile().getParent();
	                	    WriteLabToXML lab_writer = new WriteLabToXML(labyrinth_field_);
	                	    lab_writer.writeXMLFile(filename);
	                	    lab_writer.writeDTDFile(folder);
	                	}
					}
				}
			);
		}
		// END SAVE LAB BUTTON ****************************************************

		drawNewLabyrinth();

    }

	/** This methods job is to generate a new labyrinth.
	* It is intended to be called from the action listener of the draw_button_ and from the action listener
	* of the LabyrinthChoosePanel.
	* @author Bernhard Kornberger
	*/
	public void drawNewLabyrinth()
	{
		level_handler_ = new LevelHandler();
        level_handler_.setDocumentBase(getDocumentBase());
        level_handler_.loadGameXmlFile(file_name_);
        level_handler_.setCustomLevelFile(custom_level_filename_);
		if (level_handler_.loadLevel(lab_choose_panel_.getCurrentSelected(),false)) // draw lab., param: (level, keepLabyrinth)
		{

	      	labyrinth_field_ = level_handler_.getLabyrinthField();
			robot_ = new Robot();
	       	robot_.setPos(labyrinth_field_.getStartpointRow(), labyrinth_field_.getStartpointCol());
	       	try
			{
				robot_.setStartDirection(labyrinth_field_.getStartDirection());
			}
			catch (IllegalDirectionException ex)
			{
	            System.err.println(ex.getMessage());
			}
			print_labyrinth_.setLabyrinthField(labyrinth_field_);
	        print_labyrinth_.setRobot(robot_);
	      	repaint();
			this.showStatus("Marvin-10 programmieren...");
		}
	}

    /**
     * This method is called from within the init() method to initialize the
     * form. WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void loadImages() {
        brick_images_ = new HashMap();
        // load the images which are display at the brick_rules panel
        image_folder_ = "Images";
        brick_images_.put("CONDITION_DEFAULT", loadImage("images.jpg"));
        brick_images_.put("CONDITION_HOVER", loadImage("images1.jpg"));
        brick_images_.put("ACTION_DEFAULT", loadImage("images2.jpg"));
        brick_images_.put("ACTION_HOVER", loadImage("images3.jpg"));
        brick_images_.put("ARROW_UP", loadImage("arrow_up.gif"));
        brick_images_.put("ARROW_DOWN", loadImage("arrow_down.gif"));
        brick_images_.put("ARROW_LEFT", loadImage("arrow_left.gif"));
        brick_images_.put("ARROW_RIGHT", loadImage("arrow_right.gif"));
        brick_images_.put("FREE_GROUND", loadImage("free_ground.gif"));
        brick_images_.put("WALL_GROUND", loadImage("wall_ground.gif"));

        brick_images_.put("EMPTY_FLOOR", loadImage("floor_empty.gif"));
        brick_images_.put("FLOOR_0", loadImage("floor_0.gif"));
        brick_images_.put("FLOOR_1", loadImage("floor_1.gif"));
        brick_images_.put("FLOOR_2", loadImage("floor_2.gif"));
        brick_images_.put("FLOOR_3", loadImage("floor_3.gif"));
        brick_images_.put("X_BUTTON", loadIcon("x_button.gif"));

        brick_images_.put("COND_NONE", loadImage("cond_none.gif"));
        brick_images_.put("COND_GREEN", loadImage("cond_green.gif"));
        brick_images_.put("COND_BLUE", loadImage("cond_blue.gif"));
        brick_images_.put("COND_RED", loadImage("cond_red.gif"));
        brick_images_.put("COND_YELLOW", loadImage("cond_yellow.gif"));

        brick_images_.put("COND_NONE_1", loadImage("cond_none_1.gif"));
        brick_images_.put("COND_GREEN_1", loadImage("cond_green_1.gif"));
        brick_images_.put("COND_BLUE_1", loadImage("cond_blue_1.gif"));
        brick_images_.put("COND_RED_1", loadImage("cond_red_1.gif"));
        brick_images_.put("COND_YELLOW_1", loadImage("cond_yellow_1.gif"));

        brick_images_.put("LAB_WAY", loadImage("way_3.jpg"));
        brick_images_.put("LAB_WALL", loadImage("way_2.jpg"));

        brick_images_
                .put("LAB_ROBOT_BLANK_UP", loadImage("robot_blank_up.gif"));
        brick_images_.put("LAB_ROBOT_BLANK_RIGHT",
                loadImage("robot_blank_right.gif"));
        brick_images_.put("LAB_ROBOT_BLANK_DOWN",
                loadImage("robot_blank_down.gif"));
        brick_images_.put("LAB_ROBOT_BLANK_LEFT",
                loadImage("robot_blank_left.gif"));

        brick_images_.put("LAB_ROBOT_BLUE_UP", loadImage("robot_blue_up.gif"));
        brick_images_.put("LAB_ROBOT_BLUE_RIGHT",
                loadImage("robot_blue_right.gif"));
        brick_images_.put("LAB_ROBOT_BLUE_DOWN",
                loadImage("robot_blue_down.gif"));
        brick_images_.put("LAB_ROBOT_BLUE_LEFT",
                loadImage("robot_blue_left.gif"));

        brick_images_
                .put("LAB_ROBOT_GREEN_UP", loadImage("robot_green_up.gif"));
        brick_images_.put("LAB_ROBOT_GREEN_RIGHT",
                loadImage("robot_green_right.gif"));
        brick_images_.put("LAB_ROBOT_GREEN_DOWN",
                loadImage("robot_green_down.gif"));
        brick_images_.put("LAB_ROBOT_GREEN_LEFT",
                loadImage("robot_green_left.gif"));

        brick_images_.put("LAB_ROBOT_RED_UP", loadImage("robot_red_up.gif"));
        brick_images_.put("LAB_ROBOT_RED_RIGHT",
                loadImage("robot_red_right.gif"));
        brick_images_.put("LAB_ROBOT_RED_DOWN",
                loadImage("robot_red_down.gif"));
        brick_images_.put("LAB_ROBOT_RED_LEFT",
                loadImage("robot_red_left.gif"));

        brick_images_.put("LAB_ROBOT_YELLOW_UP", loadImage("robot_yellow_up.gif"));
        brick_images_.put("LAB_ROBOT_YELLOW_RIGHT",
                loadImage("robot_yellow_right.gif"));
        brick_images_.put("LAB_ROBOT_YELLOW_DOWN",
                loadImage("robot_yellow_down.gif"));
        brick_images_.put("LAB_ROBOT_YELLOW_LEFT",
                loadImage("robot_yellow_left.gif"));


        brick_images_.put("LAB_CELLMARK0", loadImage("lab_cellmark0.gif"));
        brick_images_.put("LAB_CELLMARK1", loadImage("lab_cellmark1.gif"));
        brick_images_.put("LAB_CELLMARK2", loadImage("lab_cellmark2.gif"));
        brick_images_.put("LAB_CELLMARK3", loadImage("lab_cellmark3.gif"));

        brick_images_.put("LAB_DIAMOND", loadImage("diamond.gif"));

    }

    private Image loadImage(String name) {
        ImageIcon icon = null;
        if (image_folder_ == null)
            image_folder_ = "";
        try {
            icon = new ImageIcon(new URL(getCodeBase(), image_folder_ + "/"
                    + name));
            return icon.getImage();
        } catch (MalformedURLException e) {
            System.out.println("Failed to create URL:\n" + e);
            return null;
        }

    }

    private ImageIcon loadIcon(String name) {
        ImageIcon icon = null;
        if (image_folder_ == null)
            image_folder_ = "";
        try {
            icon = new ImageIcon(new URL(getCodeBase(), image_folder_ + "/"
                    + name));
            return icon;
        } catch (MalformedURLException e) {
            System.out.println("Failed to create URL:\n" + e);
            return null;
        }

    }



    public void createInstructList() {

        instruct_list_ = new InstructionList();
        //1 - Condition(N oder B, Markierung, Links Wand, Rechts Wand, Vorne
        // Wand)
        Instruction instruction = new Instruction(new Condition(0, "0", true,
                true, false), new Action(0, "0", Action.MOVE_AHEAD));
        instruct_list_.addInstruction(instruction);

        //2
        instruction = new Instruction(new Condition(0, "0", false, true, true),
                new Action(0, "0", Action.MOVE_LEFT));
        instruct_list_.addInstruction(instruction);

        //3
        instruction = new Instruction(new Condition(0, "0", true, false, true),
                new Action(0, "0", Action.MOVE_RIGHT));
        instruct_list_.addInstruction(instruction);

        //4
        instruction = new Instruction(new Condition(0, "0", false, false, true),
                new Action(0, "1", Action.MOVE_LEFT));
        instruct_list_.addInstruction(instruction);

        //5
        instruction = new Instruction(new Condition(0, "0", true, false, false),
                new Action(0, "1", Action.MOVE_AHEAD));
        instruct_list_.addInstruction(instruction);

        //6
        instruction = new Instruction(new Condition(0, "0", false, true, false),
                new Action(0, "1", Action.MOVE_LEFT));
        instruct_list_.addInstruction(instruction);

        //7
        instruction = new Instruction(new Condition(0, "0", true, true, true),
                new Action(1, "0", Action.MOVE_BACK));
        instruct_list_.addInstruction(instruction);

        // B in condition or/and action
        //8
        instruction = new Instruction(new Condition(1, "0", true, true, false),
                new Action(1, "0", Action.MOVE_AHEAD));
        instruct_list_.addInstruction(instruction);

        //9
        instruction = new Instruction(new Condition(1, "0", false, true, true),
                new Action(1, "0", Action.MOVE_LEFT));
        instruct_list_.addInstruction(instruction);

        //10
        instruction = new Instruction(new Condition(1, "0", true, false, true),
                new Action(1, "0", Action.MOVE_RIGHT));
        instruct_list_.addInstruction(instruction);

        //11
        instruction = new Instruction(new Condition(1, "1", false, false, true),
                new Action(0, "2", Action.MOVE_LEFT));
        instruct_list_.addInstruction(instruction);

        //12
        instruction = new Instruction(new Condition(1, "1", true, false, false),
                new Action(0, "2", Action.MOVE_AHEAD));
        instruct_list_.addInstruction(instruction);

        //13
        instruction = new Instruction(new Condition(1, "1", false, true, false),
                new Action(0, "2", Action.MOVE_LEFT));
        instruct_list_.addInstruction(instruction);

        //14
        instruction = new Instruction(new Condition(1, "2", false, false, true),
                new Action(1, "0", Action.MOVE_LEFT));
        instruct_list_.addInstruction(instruction);

        //15
        instruction = new Instruction(new Condition(1, "2", true, false, false),
                new Action(1, "0", Action.MOVE_AHEAD));
        instruct_list_.addInstruction(instruction);

        //16
        instruction = new Instruction(new Condition(1, "2", false, true, false),
                new Action(1, "0", Action.MOVE_LEFT));
        instruct_list_.addInstruction(instruction);

        //Vier Weg Kreuzung
        //1
        instruction = new Instruction(new Condition(0, "0", false, false, false),
                new Action(0, "1", Action.MOVE_LEFT));
        instruct_list_.addInstruction(instruction);

        //2
        instruction = new Instruction(new Condition(1, "1", false, false, false),
                new Action(0, "2", Action.MOVE_LEFT));
        instruct_list_.addInstruction(instruction);

        //3
        instruction = new Instruction(new Condition(1, "2", false, false, false),
                new Action(0, "3", Action.MOVE_LEFT));
        instruct_list_.addInstruction(instruction);

        //4
        instruction = new Instruction(new Condition(1, "3", false, false, false),
                new Action(1, "0", Action.MOVE_LEFT));
        instruct_list_.addInstruction(instruction);

        //Loops bei 3 Weg Kreuzungen
        instruction = new Instruction(new Condition(0, "1", false, false, true),
                new Action(1, "2", Action.MOVE_LEFT));
        instruct_list_.addInstruction(instruction);

        instruction = new Instruction(new Condition(0, "1", false, true, false),
                new Action(1, "2", Action.MOVE_LEFT));
        instruct_list_.addInstruction(instruction);

        instruction = new Instruction(new Condition(0, "1", true, false, false),
                new Action(1, "2", Action.MOVE_AHEAD));
        instruct_list_.addInstruction(instruction);

        //Loops bei 4 Weg Kreuzungen
        instruction = new Instruction(new Condition(0, "1", false, false, false),
                new Action(0, "2", Action.MOVE_LEFT));
        instruct_list_.addInstruction(instruction);

        instruction = new Instruction(new Condition(0, "2", false, false, false),
                new Action(1, "3", Action.MOVE_LEFT));
        instruct_list_.addInstruction(instruction);

    }

	/**
	* Used to start a new thread and intended to be called from the start button's action listener defined in init()
	*/
    public void run() {
        try
		{
			if(level_handler_.getLabyrinthField()!=null)
			{
				robot_ = new Robot();
            	robot_.setPos(labyrinth_field_.getStartpointRow(), labyrinth_field_.getStartpointCol());
            	robot_.setStartDirection(labyrinth_field_.getStartDirection());

				// TuringMachine setup
				turing_machine_ = new TuringMachine();
				turing_machine_.setLabyrinthField(labyrinth_field_);
				turing_machine_.setRobot(robot_);
				turing_machine_.setInstructionList(instruct_list_);
				turing_machine_.setMode(TuringMachine.VERYFASTFORWARD);

				// Put it together, repaint, start!
            	print_labyrinth_.setLabyrinthField(labyrinth_field_);
            	print_labyrinth_.setRobot(robot_);
            	repaint();
            	Thread.sleep(50);
				turing_machine_.start(print_labyrinth_);

				// The following lines just set appropriate status bar messages
				String status_message_="";
				int rest_=labyrinth_field_.getNumDiamonds();
				if(rest_==1)status_message_="Es ist noch ein Diamant im Labyrinth";
				if(rest_>1) status_message_="Es sind noch "+rest_+" Diamanten im Labyrinth";
				boolean robot_is_out_=(robot_.getPosCol()==labyrinth_field_.getStartpointCol() &&
					robot_.getPosRow() ==labyrinth_field_.getStartpointRow()); // Did the robot return to the start point?
				if(rest_==0 && robot_is_out_) status_message_="Du hast es geschafft! Marvin-10 hat  "+turing_machine_.getNumTakenDiamonds()+" Diamanten gesammelt.";
				if(rest_==0 && !robot_is_out_) status_message_="Okay, aber Marvin-10 mu wieder aus dem Labyrinth herauskommen";
				this.showStatus(status_message_);
			}

        } catch (IllegalDirectionException ex) {
            System.err.println(ex.getMessage());
        } catch (InterruptedException ex) {
            System.err.println(ex.getMessage());
        }
    }
}
