/*
 * Created on 30.03.2005
 *
 * Package - PrintGame
 * File - InstructionListXMLContentHandler.java
 * 
 */
package PrintGame;

import java.net.URL;

import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/**
 * InstructionListXMLContentHandler - XML Content Handler for instruction list stored in an XML file
 * 
 * @author Bojan Hrnkas
 *
 */
public class InstructionListXMLContentHandler extends DefaultHandler {
    
    private char wall_symbol_;
    private char way_symbol_;
    private InstructionList instructions_;
    private Instruction temp_instruction_;
    private Condition temp_condition_;
    private int temp_cond_state_;
    private int temp_cond_cell_mark_;
    private boolean temp_wall_left_;
    private boolean temp_wall_right_;
    private boolean temp_wall_ahead_;
    private Action temp_action_;
    private int temp_action_state_;
    private int temp_action_cell_mark_;
    private int temp_moving_direction_;
    private String current_tag_;
    private URL document_base_;
    
    public InstructionListXMLContentHandler()
    {
        instructions_ = new InstructionList();
        temp_instruction_ = null;
        temp_condition_ = null;
        temp_action_ = null;
        current_tag_ = new String();
        document_base_=null;
    }
    
    public void setDocumentBase(URL document_base)
    {
        document_base_=document_base;
    }
    

    /**
     *Receive notification of the beginning of the document.
     */
    public void startDocument()
    {
        //nothing to do here.
    }
    
    /**
     *Receive notification of the start of an element.
     *@param attributes - The specified or defaulted attributes.
     *@param localName - The local name (without prefix),
     *or the empty string if Namespace processing is not being performed.
     *@param qualName - The qualified name (with prefix),
     *or the empty string if qualified names are not available.
     */
    
    public void startElement(String uri, String localName, String qualName, Attributes attribs)
    {
        current_tag_ = qualName;      
   }
    
    /**-----------------------------------------------------------------------------
     *Receive notification of character data inside an element.
     *@param charArray - The characters.
     *@param start - The start position in the character array.
     *@param length - The number of characters to use from the character array.
     */
    public void characters(char[] charArray, int start, int length)
    {
        if(current_tag_.length() > 0)
        {
            String temp_string = new String(charArray, start, length);
            temp_string = temp_string.trim();
            
            if (current_tag_.equals(new String(TagName.WALLSYMBOL)))
            {
              wall_symbol_=temp_string.charAt(0);
            }
            else if (current_tag_.equals(new String(TagName.WAYSYMBOL)))
            {
              way_symbol_=temp_string.charAt(0);
            }
            else if (current_tag_.equals(new String(TagName.WALLLEFT)))
            {
                if (temp_string.charAt(0) == wall_symbol_)
                    temp_wall_left_ = true;
                else
                    temp_wall_left_ = false;
            }
            else if (current_tag_.equals(new String(TagName.WALLAHEAD)))
            {
                if (temp_string.charAt(0) == wall_symbol_)
                    temp_wall_ahead_ = true;
                else
                    temp_wall_ahead_ = false;
            }
            else if (current_tag_.equals(new String(TagName.WALLRIGHT)))
            {
                if (temp_string.charAt(0) == wall_symbol_)
                    temp_wall_right_ = true;
                else
                    temp_wall_right_ = false;
            }
            else if (current_tag_.equals(new String(TagName.CONDSTATE)))
            {
                temp_cond_state_ = Integer.decode(temp_string).intValue();
            }
            else if (current_tag_.equals(new String(TagName.CONDCELLMARK)))
            {
                temp_cond_cell_mark_ = Integer.decode(temp_string).intValue();
            }
            else if (current_tag_.equals(new String(TagName.ACTIONSTATE)))
            {
                temp_action_state_ = Integer.decode(temp_string).intValue();
            }
            else if (current_tag_.equals(new String(TagName.ACTIONCELLMARK)))
            {
                temp_action_cell_mark_ = Integer.decode(temp_string).intValue();
            }
            else if (current_tag_.equals(new String(TagName.MOVINGDIRECTION)))
            {
                temp_moving_direction_ = Integer.decode(temp_string).intValue();
            }
        }
    }
    
    public void endElement(String uri, String localName, String qualName)
    {
        if (qualName.equals(new String(TagName.INSTRUCTION)))
        {
            temp_instruction_ = new Instruction(temp_condition_, temp_action_);
            instructions_.addInstruction(temp_instruction_);
        }
        else if (qualName.equals(new String(TagName.CONDITION)))
        {
            temp_condition_ = new Condition(temp_cond_state_,temp_cond_cell_mark_,temp_wall_left_,temp_wall_right_,temp_wall_ahead_);
        }
        else if (qualName.equals(new String(TagName.ACTION)))
        {
            temp_action_ = new Action(temp_action_state_,temp_action_cell_mark_,temp_moving_direction_);
        }
 	    current_tag_="";
    }

    /**
     *Receive notification of the end of the document.
     */
      public void endDocument()
      {

      }

      public InstructionList getInstructionList()
      {
          	return instructions_;
      }
}
