/*
 * Created on 12.09.2004
 *
 */
package PrintGame;

import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.LinkedList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class LevelHandler {

  private LoadLabyrinth load_labyrinth_;
  private GameXMLContentHandler game_xml_content_handler_;
  private String wall_picture_;
  private String way_picture_;
  private String robot_picture_;
  private String diamond_picture_;
  private String start_picture_;
  private int num_levels_;
  private String file_;
  private URL document_base_;
  private boolean is_not_default_style_;
  private boolean is_error_;
	private LinkedList level_name_;
	private LinkedList instruction_file_;
  public LevelHandler()
  {
    document_base_= null;
    is_not_default_style_=false;
	is_error_=false;
  }


  public void setDocumentBase(URL document_base)
  {
    document_base_=document_base;
  }


	public void loadGameXmlFile(String file)
  {
    try
    {
			SAXParserFactory saxparserfactory = SAXParserFactory.newInstance();
			saxparserfactory.setValidating(true);
			SAXParser saxparser = saxparserfactory.newSAXParser();
			XMLReader xmlreader = saxparser.getXMLReader();
	  game_xml_content_handler_ = new GameXMLContentHandler();
	  game_xml_content_handler_.setDocumentBase(document_base_);
			xmlreader.setContentHandler(game_xml_content_handler_);
			XMLErrorHandler xmlerrorhandler = new XMLErrorHandler();
			xmlreader.setErrorHandler(xmlerrorhandler);
			xmlreader.parse(file);

			is_error_ = xmlerrorhandler.isXMLError();

			if(is_error_==false)
			{
      	wall_picture_ = game_xml_content_handler_.getWallPicture();
      	way_picture_ = game_xml_content_handler_.getWayPicture();
      	robot_picture_ = game_xml_content_handler_.getRobotPicture();
      	diamond_picture_ = game_xml_content_handler_.getDiamondPicture();
      	start_picture_ = game_xml_content_handler_.getStartPicture();
      	num_levels_ = game_xml_content_handler_.getNumLevels();
				level_name_ = game_xml_content_handler_.getLevelNameList();
				instruction_file_ = game_xml_content_handler_.getInstructionFileList();
			}
    }
    catch(SAXException exc)
    {
      System.err.println(exc.getMessage());
    }
    catch(ParserConfigurationException exc)
    {
      System.err.println(exc.getMessage());
    }
    catch(IOException exc)
    {
      System.err.println(exc.getMessage());
    }
  }


  public int getNumLevels()
  {
		if(is_error_==false)
    	return num_levels_;
		else
			return -1;
  }


	public InstructionList loadInstructionList(int number)
  {
		if (number > num_levels_ || number <= 0)
			return null;

		if (instruction_file_.get(number - 1) != null)
		{
			LoadInstructions load_instruction_list = new LoadInstructions((String)instruction_file_.get(number - 1),document_base_ );
			return load_instruction_list.getInstructionList();
		}
			else
			return null;
	}


	public void loadLevel(int number)
			{
		if(number > num_levels_ || number <= 0)
			throw new IllegalArgumentException(new String("number must be < "+num_levels_+" and >= 0"));
		if (is_error_ == false)
				{
				    is_not_default_style_=false;
			file_ = (String)game_xml_content_handler_.getFile(number);
					load_labyrinth_ = new LoadLabyrinth(file_, document_base_);
					is_not_default_style_=load_labyrinth_.isStyle();
			}
		}


	public LinkedList getLevelNameList()
	{
		return level_name_;
  }

  public LabyrinthField getLabyrinthField()
  {
		if(is_error_==false)
			return (load_labyrinth_.getLabyrinthField());
		else
			return (null);
  }

  public String getWallPicture()
  {

    if(is_not_default_style_)
			return (load_labyrinth_.getWallPicture());
    else
    	return wall_picture_;
  }

  public String getWayPicture()
  {
    if(is_not_default_style_)
      return load_labyrinth_.getWayPicture();
    else
      return way_picture_;
  }

  public String getRobotPicture()
  {
    if(is_not_default_style_)
      return load_labyrinth_.getRobotPicture();
    else
      return robot_picture_;
  }

  public String getDiamondPicture()
  {
    if(is_not_default_style_)
      return load_labyrinth_.getDiamondPicture();
    else
      return diamond_picture_;
  }

  public String getStartPicture()
  {
    if(is_not_default_style_)
      return load_labyrinth_.getStartPicture();
    else
			return (start_picture_);
  }

}
