/*
 * Created on 15.07.2005
 *
 * Package - PrintGame
 * File - LoadInstructions.java
 * 
 */
package PrintGame;

import java.io.IOException;
import java.net.URL;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

/**
 * @author Bojan
 *
 * LoadInstructions - Used for loading Instructions (rules) from an xml file
 * 
 */
public class LoadInstructions {

    private URL document_base_;
    private String filename_;
    protected InstructionListXMLContentHandler instruction_list_xml_content_handler_;
    
    protected InstructionList instructions_;
    
    public LoadInstructions(String filename, URL document_base)
      throws IllegalArgumentException
    {
        filename_ = filename;
        document_base_ = document_base;
        
        try
        {
    		// Load the ContentHandler ********************************************
    		SAXParserFactory factory = SAXParserFactory.newInstance();
    		factory.setValidating(true);
    		SAXParser saxParser = factory.newSAXParser();
    		XMLReader xmlReader = saxParser.getXMLReader(); 
    		instruction_list_xml_content_handler_ = new InstructionListXMLContentHandler();
    		instruction_list_xml_content_handler_.setDocumentBase(document_base_);
    		xmlReader.setContentHandler(instruction_list_xml_content_handler_);
    			
    		XMLErrorHandler xml_error_handler = new XMLErrorHandler();
    		xmlReader.setErrorHandler(xml_error_handler);
    			
    		xmlReader.parse(filename_);
    		// (END OF) Load the ContentHandler ********************************************
    		
    		if(xml_error_handler.isXMLError()==false)
    		{
    		    instructions_ = instruction_list_xml_content_handler_.getInstructionList();
    		}
        }
    	catch(SAXParseException exc)
    	{
    		System.out.println("ERROR");
    		System.out.println("In File " + exc.getSystemId());
    		System.out.println(exc.getMessage());
    	}		
    	catch(SAXException exc)
    	{
    		System.out.println("SAXException");
    		System.err.println(exc.getMessage());
    		System.err.println(exc.toString());
    	}
    	catch(ParserConfigurationException exc)
    	{
    		System.out.println("ParserConfigurationException");
    		System.err.println(exc.getMessage());
    	}
    	catch(IOException exc)
    	{
    		System.out.println("IOException");
    		System.err.println(exc.getMessage());
    	}
    }
    
    public InstructionList getInstructionList()
    {
        	return instructions_;
    }
}
