package PrintGame;

import java.net.URL;
import java.net.MalformedURLException;
import java.io.IOException;

import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.XMLReader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

import PrintGame.Action;
import PrintGame.Condition;
import PrintGame.Instruction;

public class TxtWriter
{   
  private String line_;
    
  private String condition_start_string_;
  private String condition_end_string_;
  private String action_start_string_;
  private String action_end_string_;
  private String condition_action_separator_string_;
  private String separator_string_;
  private String comment_out_line_string_; 
  private String comment_out_start_string_;
  private String comment_out_end_string_;
  private String wall_string_;
  private String way_string_;
  private String direction_left_string_;
  private String direction_ahead_string_;
  private String direction_right_string_;
  private String direction_back_string_;
  private URL url_ = null;
  private String path_ = null;
  private InstructionTXTXMLContentHandler handler_;
  private LabyrinthMarkAndStateArray mark_array_, state_array_;
	
  public TxtWriter(URL url)
  {
  InstructionTXTXMLContentHandler handler_ = new InstructionTXTXMLContentHandler();
        try { path_ = (new URL(url, "config/InstructionTXT.xml")).toString();} 
  catch (MalformedURLException ex) { System.err.println(ex.getMessage());}
      try
      { 
  SAXParserFactory factory = SAXParserFactory.newInstance();
  factory.setValidating(true);   //neu
  SAXParser saxParser = factory.newSAXParser();
  XMLReader xmlReader = saxParser.getXMLReader(); 
  handler_ = new InstructionTXTXMLContentHandler(); 
  xmlReader.setContentHandler(handler_);  
  XMLErrorHandler xml_error_handler = new XMLErrorHandler();
  xmlReader.setErrorHandler(xml_error_handler); 
  xmlReader.parse(path_);
  }
  catch(SAXParseException exc)
  {
    System.out.println("ERROR");
    System.out.println("In File " + exc.getSystemId());
    System.out.println(exc.getMessage());
  }   
  catch(SAXException exc)
  {
    System.out.println("SAXException");
    System.err.println(exc.getMessage());
    System.err.println(exc.toString());
  }
  catch(ParserConfigurationException exc)
  {
    System.out.println("ParserConfigurationException");
    System.err.println(exc.getMessage());
  }
  catch(IOException exc)
  {
    System.out.println("IOException");
    System.err.println(exc.getMessage());
  }
  
  condition_start_string_ = handler_.ConditionStartString();
  condition_end_string_= handler_.ConditionEndString();
  action_start_string_= handler_.ActionStartString();
  action_end_string_= handler_.ActionEndString();
  condition_action_separator_string_= handler_.ConditionActionSeparatorString();
  separator_string_= handler_.SeparatorString();
  comment_out_line_string_= handler_.CommentOutLineString(); 
  comment_out_start_string_= handler_.CommentOutStartString();
  comment_out_end_string_= handler_.CommentOutEndString();
  wall_string_= handler_.WallString();
  way_string_= handler_.WayString();
  direction_left_string_= handler_.DirectionLeftString();
  direction_ahead_string_= handler_.DirectionAheadString();
  direction_right_string_= handler_.DirectionRightString();
  direction_back_string_= handler_.DirectionBackString(); 
  
  }
  
	public void setMarkArray(LabyrinthMarkAndStateArray mark_array)
	{
		mark_array_=mark_array;
	}
	
	public void setStateArray(LabyrinthMarkAndStateArray state_array)
	{
		state_array_=state_array;
	}
	
  public String writeText(InstructionList list)  
  {
    InstructionList instructions;
    instructions=list;
    String code;
    code=new String();
    try
    {
      for(int count=0;count<instructions.size();count++)
      {
        Instruction tmp_instruction=instructions.getInstructionAtPos(count);
        String tmp=writeLine(tmp_instruction);
        code=code.concat(tmp).concat("\n");
      }
    }
    catch(IllegalArgumentException exc)
    {
      System.err.println(exc.getMessage());
    }
    return code;
  }
    
  
  private String writeLine(Instruction instruction)
  throws IllegalArgumentException
  {
  String left, ahead, right, direction;
  Condition tmp_condition=instruction.getCondition();
  
	String condition_state=state_array_.getFromInt(tmp_condition.getState());  
  String condition_cell_mark=mark_array_.getFromInt(tmp_condition.getCellMark());  
  //String condition_state="0";
  //String condition_cell_mark="-1";
  
  boolean wall_left=tmp_condition.isWallLeft();
  if(wall_left==true)
    left=wall_string_;
  else 
    left=way_string_;
  
  boolean wall_ahead=tmp_condition.isWallAhead();
  if(wall_ahead==true)
    ahead=wall_string_;
  else 
    ahead=way_string_;
    
  boolean wall_right=tmp_condition.isWallRight();
  if(wall_right==true)
    right=wall_string_;
  else 
    right=way_string_;
  
  Action tmp_action=instruction.getAction();
  
  int dir=tmp_action.getMovingDirection();
  if(dir==1)
    direction=direction_ahead_string_;
  else if(dir==2)
    direction=direction_right_string_;
  else if(dir==3)
    direction=direction_back_string_;
  else if(dir==4)
    direction=direction_left_string_;
  else 
   throw(new IllegalArgumentException("Illegal direction"));
  
  String action_cellmark=mark_array_.getFromInt(tmp_action.getCellMark());
	String action_state=state_array_.getFromInt(tmp_action.GetState());
  //String action_cellmark="-1";
  //String action_state="0";
  
  String line=condition_start_string_.concat(left).concat(ahead).concat(right).concat(separator_string_).
  concat(condition_state).concat(separator_string_).concat(condition_cell_mark).concat(condition_end_string_)
  .concat(condition_action_separator_string_)
  .concat(action_start_string_).concat(action_cellmark).concat(separator_string_).concat(direction).concat(separator_string_)
  .concat(action_state).concat(action_end_string_);
  
  return  line;
  } 
}