package PrintGame;

import java.net.*;
import javax.swing.*;
import java.awt.*;
import java.util.LinkedList;

import PrintGame.Instruction;
public class XpertMode
{ 
	URL url_;
  TextArea ta_;
  Instruction instruction_;
	LabyrinthMarkAndStateArray mark_array_, state_array_;
	
  public XpertMode()
  {
  }
  
	public void setUrl( URL url)
	{
  	url_=url;
	}
	
	public void setMarkArray(LabyrinthMarkAndStateArray mark_array)
	{
		mark_array_=mark_array;
	}
	
	public LabyrinthMarkAndStateArray getMarkArray()
	{
		return mark_array_;
	}
	
	public void setStateArray(LabyrinthMarkAndStateArray state_array)
	{
		state_array_=state_array;
	}
	
	public LabyrinthMarkAndStateArray getStateArray()
	{
		return state_array_;
	}
	
	public void outputRuleList(InstructionList list, TextArea ta) 
	{ 	
    TxtWriter writer_ = new TxtWriter(url_);
		writer_.setMarkArray(mark_array_);
		writer_.setStateArray(state_array_);
    String text=writer_.writeText(list);
    ta.setText(text);
  }
  
  public InstructionList getRuleList(TextArea ta)
  {
    InstructionList instructions;
    instructions = new InstructionList();
    String code;
    code = ta.getText();
    
    TxtParser parser_ = new TxtParser(url_);
		parser_.setMarkArray(mark_array_);
		parser_.setStateArray(state_array_);
    instructions=parser_.parseText(code);
		mark_array_=parser_.getMarkArray();
		state_array_=parser_.getStateArray();
    return instructions;
  } 
}