/*
 * Created on 24.09.2005
 *
 */
package TUGLaby;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.*;
import java.net.URL;
import java.util.LinkedList;
import PrintGame.Instruction;
import PrintGame.InstructionList;
/**
 * Contains the Menue shown in the GUI
 */
public class MenuePanel{

    JMenuBar menue_;
    JMenu rule_, labyrinth_, level_of_difficulty_;
    JMenuItem add_, xpertmode_, help_;
    JMenuItem new_labyrinth_, save_labyrinth_, load_labyrinth_, save_rule_, load_rule_;
    JRadioButtonMenuItem easy_, difficult_, loops_, free_, places_;
    ButtonGroup difficulty_;
    
    private int current_selected_;
    private TUGLabyrinth top_;
    private URL url_;
    private InstructionList instruct_list_; 
    private XpertFrame xpert_frame_;
    
    MenuePanel(URL url, TUGLabyrinth top_object_)
    {
    super();
    top_=top_object_;
    url_=url;
    current_selected_=1;
    
    
    // BEGIN OF NEW RULE BUTTON  *******************************************
    
    add_ = new JMenuItem("Hinzufgen"); 
    add_.setBackground(new Color(127,127,127));
    add_.setForeground(Color.ORANGE);
    
      add_.addActionListener(
      new java.awt.event.ActionListener() 
        {public void actionPerformed(java.awt.event.ActionEvent evt) 
          {
            top_.rule_tree_panel_.addNewRule("ConditionRule");
          }
        }
       );
    
    // END OF NEW RULE BUTTON **************************************************
    
    // BEGIN OF EXPERTEN-MODUS BUTTON ****************************************************
    
    xpertmode_ = new JMenuItem("Expertenmodus");
    xpertmode_.setBackground(new Color(127,127,127));
    xpertmode_.setForeground(Color.ORANGE);
    xpertmode_.addActionListener
    (new java.awt.event.ActionListener() 
        {public void actionPerformed(java.awt.event.ActionEvent evt) 
          {          
             instruct_list_ = new InstructionList();
             LinkedList listi = top_.rule_tree_panel_.getRuleList();
            for (int i = 0; i < listi.size(); i++) 
            {
              Instruction dummy = ((ConditionRulePanel) listi.get(i)).getInstruction();
              instruct_list_.addInstruction(dummy);
            }
            xpert_frame_ = new XpertFrame(url_,top_,instruct_list_);           

          }
        }
      );
   // END EXPERTEN-MODUS BUTTON ********************************************************
    
    // BEGIN OF RULE MENUE  ***********************************************    
    rule_= new JMenu("Regelstze");
    rule_.setBackground(new Color(127,127,127));
    rule_.setForeground(Color.ORANGE);
    save_rule_= new JMenuItem("speichern");
    save_rule_.setBackground(new Color(127,127,127));
    save_rule_.setForeground(Color.ORANGE);
    load_rule_= new JMenuItem("laden");
    load_rule_.setBackground(new Color(127,127,127));
    load_rule_.setForeground(Color.ORANGE);
    rule_.add(save_rule_);
    rule_.add(load_rule_);
    // END OF RULE MENUE  *****************************************************
    
    // BEGIN OF LABYRINTH MENUE  **********************************************
    labyrinth_= new JMenu("Labyrinth");
    labyrinth_.setBackground(new Color(127,127,127));
    labyrinth_.setForeground(Color.ORANGE);
    new_labyrinth_ = new JMenuItem("neu");
    new_labyrinth_.setBackground(new Color(127,127,127));
    new_labyrinth_.setForeground(Color.ORANGE);
      new_labyrinth_.setActionCommand("MenuEintrag 'neues Labyrinth' ausgewhlt");
      new_labyrinth_.addActionListener(
      new java.awt.event.ActionListener() 
        {public void actionPerformed(java.awt.event.ActionEvent evt) 
          {
            top_.drawNewLabyrinth();
          }
        }
       );
    
    save_labyrinth_= new JMenuItem("speichern");
    save_labyrinth_.setBackground(new Color(127,127,127));
    save_labyrinth_.setForeground(Color.ORANGE);
    load_labyrinth_= new JMenuItem("laden");
    load_labyrinth_.setBackground(new Color(127,127,127));
    load_labyrinth_.setForeground(Color.ORANGE);
    labyrinth_.add(new_labyrinth_);
    labyrinth_.add(save_labyrinth_);
    labyrinth_.add(load_labyrinth_);
   // END OF LABYRINTH MENUE  **************************************************
    
   // BEGIN OF DIFFICULTY MENUE  ***********************************************
    level_of_difficulty_= new JMenu("Schwierigkeitsgrad");
    level_of_difficulty_.setBackground(new Color(127,127,127));
    level_of_difficulty_.setForeground(Color.ORANGE);
    difficulty_ = new ButtonGroup();
    
    easy_ = new JRadioButtonMenuItem("Leichtes Labyrinth");
    easy_.setBackground(new Color(127,127,127));
    easy_.setForeground(Color.ORANGE);
    easy_.addItemListener(
      new java.awt.event.ItemListener() 
        {public void itemStateChanged(java.awt.event.ItemEvent evt) 
          {
          if (evt.getStateChange() == ItemEvent.SELECTED) 
            {
            current_selected_=1;
            top_.drawNewLabyrinth();
            }
          }
        }
       );
    difficult_ = new JRadioButtonMenuItem("Schweres Labyrinth");
    difficult_.setBackground(new Color(127,127,127));
    difficult_.setForeground(Color.ORANGE);
    difficult_.addItemListener(
      new java.awt.event.ItemListener() 
        {public void itemStateChanged(java.awt.event.ItemEvent evt) 
          {
          if (evt.getStateChange() == ItemEvent.SELECTED) 
            {
            current_selected_=2;
            top_.drawNewLabyrinth();
            }
          }
        }
       );
    loops_ = new JRadioButtonMenuItem("Labyrinth mit Loops");
    loops_.setBackground(new Color(127,127,127));
    loops_.setForeground(Color.ORANGE);
    loops_.addItemListener(
      new java.awt.event.ItemListener() 
        {public void itemStateChanged(java.awt.event.ItemEvent evt) 
          {
          if (evt.getStateChange() == ItemEvent.SELECTED) 
            {
            current_selected_=3;
            top_.drawNewLabyrinth();
            }
          }
        }
       );
    free_ = new JRadioButtonMenuItem("Freies Feld");
    free_.setBackground(new Color(127,127,127));
    free_.setForeground(Color.ORANGE);
    free_.addItemListener(
      new java.awt.event.ItemListener() 
        {public void itemStateChanged(java.awt.event.ItemEvent evt) 
          {
          if (evt.getStateChange() == ItemEvent.SELECTED) 
            {
            current_selected_=4;
            top_.drawNewLabyrinth();
            }
          }
        }
       );
    places_ = new JRadioButtonMenuItem("Labyrinth mit Pltzen");
    places_.setBackground(new Color(127,127,127));
    places_.setForeground(Color.ORANGE);
    places_.addItemListener(
      new java.awt.event.ItemListener() 
        {public void itemStateChanged(java.awt.event.ItemEvent evt) 
          {
          if (evt.getStateChange() == ItemEvent.SELECTED) 
            {
            current_selected_=5;
            top_.drawNewLabyrinth();
            }
          }
        }
       );
    difficulty_.add(easy_);
    difficulty_.add(difficult_);
    difficulty_.add(loops_);
    difficulty_.add(free_);
    difficulty_.add(places_);
   
    level_of_difficulty_.add(easy_);
    level_of_difficulty_.add(difficult_);
    level_of_difficulty_.add(loops_);
    level_of_difficulty_.add(free_);
    level_of_difficulty_.add(places_);
  
    
   // END OF DIFFICULTY MENUE  ***********************************************
    
   // BEGIN OF HELP BUTTON  *********************************************
    help_= new JMenuItem("Hilfe");
    help_.setBackground(new Color(127,127,127));
    help_.setForeground(Color.ORANGE);
    help_.addActionListener(
    new java.awt.event.ActionListener()
    {public void actionPerformed(java.awt.event.ActionEvent evt) {
    HelpWindow help_window=new HelpWindow(url_);
    help_window.showHelpWindow();
    }
    });
   // END OF HELP BUTTON  ***********************************************
   
    menue_=new JMenuBar();
    menue_.add(Box.createHorizontalGlue());
    menue_.add(add_);
    menue_.add(xpertmode_);
    menue_.add(rule_);
    menue_.add(Box.createHorizontalGlue());
    menue_.add(labyrinth_);
    menue_.add(Box.createHorizontalGlue());
    menue_.add(level_of_difficulty_);
    menue_.add(Box.createHorizontalGlue());
    menue_.add(help_);
    menue_.setBackground(new Color(127,127,127));
    top_.setJMenuBar(menue_);
  } 
  
 public int getCurrentSelectedLevel() {
        return current_selected_;
    } 
  }
