package TUGLaby;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JScrollPane;

import PrintGame.Action;
import PrintGame.Condition;
import PrintGame.IllegalDirectionException;
import PrintGame.Instruction;
import PrintGame.InstructionList;
import PrintGame.LabyrinthField;
import PrintGame.LevelHandler;
import PrintGame.LoadInstructions;
import PrintGame.PrintLabyrinth;
import PrintGame.Robot;
import PrintGame.TuringMachine;
import PrintGame.LabyrinthMarkAndStateArray;
/*
 * JApplet.java
 *
 * Changed on 24.09. 2005, 15:53
 */

/**
 * The Top level class
 * @author user
 */
public class TUGLabyrinth extends javax.swing.JApplet implements Runnable {
 //   private javax.swing.JApplet mainframe_ = this;
    private static final int height = 580;
    private static final int width = 950;
    protected RuleTreePanel rule_tree_panel_;
    private JScrollPane rule_tree_scrollpane_;

    private MenuePanel menue_panel_;

    private HashMap brick_images_;
    private JButton start_button_;
    private String image_folder_;
    protected Thread th_;
    /**
     * ADDED FROM PrintGame
     * *********************************************************
     */
   // protected final static boolean create_labyrinth_ = false; // Switch, nur
    // derzeit ntig
    //number of cells in a row and a col
    protected final static int ROWS = 20;
    protected final static int COLS = 20;

    protected static LabyrinthField labyrinth_field_;
    protected static LevelHandler level_handler_;
    protected static Robot robot_;
    protected InstructionList instruct_list_;
    protected TuringMachine turing_machine_;
    protected PrintLabyrinth print_labyrinth_;
    protected String file_name_;
    protected String custom_level_filename_; //KEINE AHNUNG

    protected LabyrinthMarkAndStateArray mark_array_;
    protected LabyrinthMarkAndStateArray state_array_;
    /**
     * ADDED FROM PrintGame
     */

    /** Initializes the applet JApplet
	* Draws the applet and some of its buttons. Adds action listeners.
	* One of the object trees which may help you to understand the source is: Applet->LevelHandler->LoadLabyrinth->LabyrinthField
	*/
    public void init() {
    	// BEGIN OF WINDOW SETUP ****************************************************************

        mark_array_=new LabyrinthMarkAndStateArray();
        state_array_=new LabyrinthMarkAndStateArray();

        mark_array_.setString("0");
        mark_array_.setString("1");
        mark_array_.setString("2");
        mark_array_.setString("3");

        state_array_.setString("NONE");
        state_array_.setString("GREEN");
        state_array_.setString("BLUE");
        state_array_.setString("RED");
        state_array_.setString("YELLOW");

        getContentPane().setLayout(null);
        this.setSize(width, height);

        String abs_filename = getParameter("abs_filename");

        abs_filename = "Games/Game.xml";

        start_button_ = new JButton();
        menue_panel_ = new MenuePanel(getCodeBase(),this);

    		// Images -> HashMap "brick_images_"
        loadImages();

        rule_tree_panel_ = new RuleTreePanel(brick_images_);
		    // Initially display 4 Rules - this is done for usablility reasons.
		    for(int i=0;i<4;i++) rule_tree_panel_.addNewRule("ConditionRule");

        rule_tree_panel_.setPreferredSize(new Dimension(250, height - 10));
        rule_tree_scrollpane_ = new JScrollPane(rule_tree_panel_);

        print_labyrinth_ = new PrintLabyrinth(brick_images_, robot_, null);

        getContentPane().add(start_button_);
        getContentPane().add(rule_tree_scrollpane_);
        getContentPane().add(print_labyrinth_);

        rule_tree_scrollpane_.setBounds(5, 10, 268, height - 40 + 1);
        print_labyrinth_.setBounds(290, 70, 400, 400);
				print_labyrinth_.setBackground(Color.ORANGE);

        URL new_url = null;
        try {
            new_url = new URL(getDocumentBase(), abs_filename);
        } catch (MalformedURLException ex) {
            System.err.println(ex.getMessage());
        }
        this.getContentPane().setBackground(Color.ORANGE);
        file_name_ = new_url.toString(); // "Game.xml", Level-Info

		// END OF WINDOW SETUP ******************************************************************



		// BEGIN OF START BUTTON  ***************************************************************
        start_button_.setBounds(710,350, 150, 30);
        start_button_.setBackground(new Color(127,127,127));
        start_button_.setForeground(Color.ORANGE);
        start_button_.setText("Start !");

        start_button_.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) { // START BUTTON PRESSED
                System.out.println("\n START BUTTON PRESSED, Rule Tree -->");
            	 String l;
            	instruct_list_ = new InstructionList();
                LinkedList listi = TUGLabyrinth.this.rule_tree_panel_.getRuleList();

		// ------------------------------------------------------------------------------------------
		for (int i = 0; i < listi.size(); i++) {
                		Instruction dummy = ((ConditionRulePanel) listi.get(i)).getInstruction();
                		instruct_list_.addInstruction(dummy);
                		System.out.print(dummy);
                		}
		// ------------------------------------------------------------------------------------------

                //level_handler_.loadLevel(menue_panel_.getCurrentSelectedLevel(),true); // responsible for drawing, param: (level, keepLabyrinth)
								//level_handler_.loadLevel(menue_panel_.getCurrentSelectedLevel());
      			labyrinth_field_ = level_handler_.getLabyrinthField();
				th_ = new Thread(TUGLabyrinth.this);
				th_.start();// => Calls run()
            }
        });

        // END OF START BUTTON ***************************************************************

		drawNewLabyrinth();

    }


	/** This methods job is to generate a new labyrinth.
	* It is intended to be called from the action listener of the draw_button_ and from the action listener
	* of the LabyrinthChoosePanel.
	* @author Bernhard Kornberger
	*/
	public void drawNewLabyrinth()
	{
		level_handler_ = new LevelHandler();
        level_handler_.setDocumentBase(getDocumentBase());
        level_handler_.loadGameXmlFile(file_name_);
        //level_handler_.setCustomLevelFile(custom_level_filename_); // KEINE AHNUNG
		//if (level_handler_.loadLevel(menue_panel_.getCurrentSelectedLevel(),false)) // draw lab., param: (level, keepLabyrinth)
		//{
		level_handler_.loadLevel(menue_panel_.getCurrentSelectedLevel());

	      	labyrinth_field_ = level_handler_.getLabyrinthField();
			robot_ = new Robot();
	       	robot_.setPos(labyrinth_field_.getStartpointRow(), labyrinth_field_.getStartpointCol());
	       	try
			{
				robot_.setStartDirection(labyrinth_field_.getStartDirection());
			}
			catch (IllegalDirectionException ex)
			{
	            System.err.println(ex.getMessage());
			}
			print_labyrinth_.setLabyrinthField(labyrinth_field_);
	        print_labyrinth_.setRobot(robot_);
	      	repaint();
			this.showStatus("Marvin-10 programmieren...");
		//}
	}

    /**
     * This method is called from within the init() method to initialize the
     * form. WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void loadImages() {
        brick_images_ = new HashMap();
        // load the images which are display at the brick_rules panel
        image_folder_ = "Images";
        brick_images_.put("CONDITION_DEFAULT", loadImage("images.jpg"));
        brick_images_.put("CONDITION_HOVER", loadImage("images1.jpg"));
        brick_images_.put("ACTION_DEFAULT", loadImage("images2.jpg"));
        brick_images_.put("ACTION_HOVER", loadImage("images3.jpg"));
        brick_images_.put("ARROW_UP", loadImage("arrow_up.gif"));
        brick_images_.put("ARROW_DOWN", loadImage("arrow_down.gif"));
        brick_images_.put("ARROW_LEFT", loadImage("arrow_left.gif"));
        brick_images_.put("ARROW_RIGHT", loadImage("arrow_right.gif"));
        brick_images_.put("FREE_GROUND", loadImage("free_ground.gif"));
        brick_images_.put("WALL_GROUND", loadImage("wall_ground.gif"));

        brick_images_.put("EMPTY_FLOOR", loadImage("floor_empty.gif"));
        brick_images_.put("FLOOR_0", loadImage("floor_0.gif"));
        brick_images_.put("FLOOR_1", loadImage("floor_1.gif"));
        brick_images_.put("FLOOR_2", loadImage("floor_2.gif"));
        brick_images_.put("FLOOR_3", loadImage("floor_3.gif"));
        brick_images_.put("FLOOR_4", loadImage("floor_4.gif"));
        brick_images_.put("X_BUTTON", loadIcon("x_button.gif"));

        brick_images_.put("COND_NONE", loadImage("cond_none.gif"));
        brick_images_.put("COND_GREEN", loadImage("cond_green.gif"));
        brick_images_.put("COND_BLUE", loadImage("cond_blue.gif"));
        brick_images_.put("COND_RED", loadImage("cond_red.gif"));
        brick_images_.put("COND_YELLOW", loadImage("cond_yellow.gif"));
        brick_images_.put("COND_GRAY", loadImage("cond_gray.gif"));

        brick_images_.put("COND_NONE_1", loadImage("cond_none_1.gif"));
        brick_images_.put("COND_GREEN_1", loadImage("cond_green_1.gif"));
        brick_images_.put("COND_BLUE_1", loadImage("cond_blue_1.gif"));
        brick_images_.put("COND_RED_1", loadImage("cond_red_1.gif"));
        brick_images_.put("COND_YELLOW_1", loadImage("cond_yellow_1.gif"));
        brick_images_.put("COND_GRAY_1", loadImage("cond_gray_1.gif"));

        brick_images_.put("LAB_WAY", loadImage("way_3.jpg"));
        brick_images_.put("LAB_WALL", loadImage("way_2.jpg"));

        brick_images_
                .put("LAB_ROBOT_BLANK_UP", loadImage("robot_blank_up.gif"));
        brick_images_.put("LAB_ROBOT_BLANK_RIGHT",
                loadImage("robot_blank_right.gif"));
        brick_images_.put("LAB_ROBOT_BLANK_DOWN",
                loadImage("robot_blank_down.gif"));
        brick_images_.put("LAB_ROBOT_BLANK_LEFT",
                loadImage("robot_blank_left.gif"));

        brick_images_.put("LAB_ROBOT_BLUE_UP", loadImage("robot_blue_up.gif"));
        brick_images_.put("LAB_ROBOT_BLUE_RIGHT",
                loadImage("robot_blue_right.gif"));
        brick_images_.put("LAB_ROBOT_BLUE_DOWN",
                loadImage("robot_blue_down.gif"));
        brick_images_.put("LAB_ROBOT_BLUE_LEFT",
                loadImage("robot_blue_left.gif"));

        brick_images_
                .put("LAB_ROBOT_GREEN_UP", loadImage("robot_green_up.gif"));
        brick_images_.put("LAB_ROBOT_GREEN_RIGHT",
                loadImage("robot_green_right.gif"));
        brick_images_.put("LAB_ROBOT_GREEN_DOWN",
                loadImage("robot_green_down.gif"));
        brick_images_.put("LAB_ROBOT_GREEN_LEFT",
                loadImage("robot_green_left.gif"));

        brick_images_.put("LAB_ROBOT_RED_UP", loadImage("robot_red_up.gif"));
        brick_images_.put("LAB_ROBOT_RED_RIGHT",
                loadImage("robot_red_right.gif"));
        brick_images_.put("LAB_ROBOT_RED_DOWN",
                loadImage("robot_red_down.gif"));
        brick_images_.put("LAB_ROBOT_RED_LEFT",
                loadImage("robot_red_left.gif"));

        brick_images_.put("LAB_ROBOT_YELLOW_UP", loadImage("robot_yellow_up.gif"));
        brick_images_.put("LAB_ROBOT_YELLOW_RIGHT",
                loadImage("robot_yellow_right.gif"));
        brick_images_.put("LAB_ROBOT_YELLOW_DOWN",
                loadImage("robot_yellow_down.gif"));
        brick_images_.put("LAB_ROBOT_YELLOW_LEFT",
                loadImage("robot_yellow_left.gif"));

        brick_images_.put("LAB_ROBOT_GRAY_UP", loadImage("robot_gray_up.gif"));
        brick_images_.put("LAB_ROBOT_GRAY_RIGHT", loadImage("robot_gray_right.gif"));
        brick_images_.put("LAB_ROBOT_GRAY_DOWN", loadImage("robot_gray_down.gif"));
        brick_images_.put("LAB_ROBOT_GRAY_LEFT", loadImage("robot_gray_left.gif"));

        brick_images_.put("LAB_CELLMARK0", loadImage("lab_cellmark0.gif"));
        brick_images_.put("LAB_CELLMARK1", loadImage("lab_cellmark1.gif"));
        brick_images_.put("LAB_CELLMARK2", loadImage("lab_cellmark2.gif"));
        brick_images_.put("LAB_CELLMARK3", loadImage("lab_cellmark3.gif"));
        brick_images_.put("LAB_CELLMARK", loadImage("lab_cellmark.gif"));

        brick_images_.put("LAB_DIAMOND", loadImage("diamond.gif"));

    }


    private Image loadImage(String name) {
        ImageIcon icon = null;
        if (image_folder_ == null)
            image_folder_ = "";
        try {
            icon = new ImageIcon(new URL(getCodeBase(), image_folder_ + "/"
                    + name));
            return icon.getImage();
        } catch (MalformedURLException e) {
            System.out.println("Failed to create URL:\n" + e);
            return null;
        }
    }

    private ImageIcon loadIcon(String name) {
        ImageIcon icon = null;
        if (image_folder_ == null)
            image_folder_ = "";
        try {
            icon = new ImageIcon(new URL(getCodeBase(), image_folder_ + "/"
                    + name));
            return icon;
        } catch (MalformedURLException e) {
            System.out.println("Failed to create URL:\n" + e);
            return null;
        }
    }

	/**
	* Used to start a new thread and intended to be called from the start button's action listener defined in init()
	*/
    public void run() {
        try
		{
			if(level_handler_.getLabyrinthField()!=null)
			{
				robot_ = new Robot();
            	robot_.setPos(labyrinth_field_.getStartpointRow(), labyrinth_field_.getStartpointCol());
            	robot_.setStartDirection(labyrinth_field_.getStartDirection());

				// TuringMachine setup
				turing_machine_ = new TuringMachine();
				turing_machine_.setLabyrinthField(labyrinth_field_);
				turing_machine_.setRobot(robot_);
				turing_machine_.setInstructionList(instruct_list_);
				turing_machine_.setMode(TuringMachine.VERYFASTFORWARD);

				// Put it together, repaint, start!
            	print_labyrinth_.setLabyrinthField(labyrinth_field_);
            	print_labyrinth_.setRobot(robot_);
            	repaint();
            	Thread.sleep(50);
				turing_machine_.start(print_labyrinth_);

				// The following lines just set appropriate status bar messages
				String status_message_="";
				int rest_=labyrinth_field_.getNumDiamonds();
				if(rest_==1)status_message_="Es ist noch ein Diamant im Labyrinth";
				if(rest_>1) status_message_="Es sind noch "+rest_+" Diamanten im Labyrinth";
				boolean robot_is_out_=(robot_.getPosCol()==labyrinth_field_.getStartpointCol() &&
					robot_.getPosRow() ==labyrinth_field_.getStartpointRow()); // Did the robot return to the start point?
				if(rest_==0 && robot_is_out_) status_message_="Du hast es geschafft! Marvin-10 hat  "+turing_machine_.getNumTakenDiamonds()+" Diamanten gesammelt.";
				if(rest_==0 && !robot_is_out_) status_message_="Okay, aber Marvin-10 mu wieder aus dem Labyrinth herauskommen";
				this.showStatus(status_message_);
			}
        } catch (IllegalDirectionException ex) {
            System.err.println(ex.getMessage());
        } catch (InterruptedException ex) {
            System.err.println(ex.getMessage());
        }
    }
}
