package PrintGame;

/**
 * class representing an action
 */

public class Action
{
  public final static int MOVE_AHEAD = 1;
  public final static int MOVE_RIGHT = 2;
  public final static int MOVE_BACK  = 3;
  public final static int MOVE_LEFT  = 4;


  protected int cell_mark_;
  protected int state_;
  protected int moving_direction_;

//-----------------------------------------------------------------------------
/**
 * Standard constructor
 * @param moving_direction relative direction
 * @param cell_mark
 * @param new_area true if the robot explores area he hasn't seen before
 */
  public Action(int state, int cell_mark, int moving_direction)
    throws IllegalArgumentException
  {
    if(moving_direction<1 || moving_direction>4)
     throw(new IllegalArgumentException(
       "invalid moving_direction. possible directions MOVE_AHEAD, " +
       "MOVE_BACK, MOVE_LEFT, MOVE_RIGHT "));

    if(cell_mark<-1)
     throw(new IllegalArgumentException(
       "cell_mark must be >= -1"));

    moving_direction_= moving_direction;
    cell_mark_= cell_mark;
    state_= state;
  }

  
  public Action(Action action)
  {
    moving_direction_= action.getMovingDirection();
    cell_mark_= action.getCellMark();
    state_= action.GetState();
  }
  
  public boolean equals(Action action)
  {
    if(moving_direction_==action.getMovingDirection() && cell_mark_==action.getCellMark() && state_==action.GetState())
      return true;
    else 
      return false;
  }
//-----------------------------------------------------------------------------
/**
 * method sets the value of cell mark
 * @param cell_mark 0 if the cell is not marked
 * 1 if the cell is marked for the first time
 * 2 if the cell was marked before
 */
  public void setCellMark(int cell_mark)
    throws IllegalArgumentException
  {
    if(cell_mark<-1)
     throw(new IllegalArgumentException(
       "cell_mark must be >= -1"));

    cell_mark_= cell_mark;
  }

/**-----------------------------------------------------------------------------
 *
 */
  public void setState(int state)
    throws IllegalArgumentException
  {
    if(state<-1)
     throw(new IllegalArgumentException(
       "state must be >= -1"));
    state_ = state;
  }

//-----------------------------------------------------------------------------
/**
 * method sets a relative direction used to move the robot.
 * @param moving_direction possible directions are ahead, back, left and rigth.
 */
  public void setMovingDirection(int moving_direction)
    throws IllegalArgumentException
  {
    if(moving_direction<1 || moving_direction>4)
     throw(new IllegalArgumentException(
       "invalid moving_direction. possible directions MOVE_AHEAD, " +
       "MOVE_BACK, MOVE_LEFT, MOVE_RIGHT "));

    moving_direction_= moving_direction;
  }

//-----------------------------------------------------------------------------
/**
 * method returns a relative direction.
 */
  public int getMovingDirection()
  {
    return moving_direction_;
  }

//-----------------------------------------------------------------------------
/**
 * method returns the value of the cell mark
 */
  public int getCellMark()
  {
    return cell_mark_;
  }

//-----------------------------------------------------------------------------
/**
 *
 */
  public int GetState()
  {
    return state_;
  }


  public String toString(){
  	String direction ="";

  	switch(moving_direction_){
  		case(MOVE_AHEAD):
  			direction = "nach vorn";
  			break;
  		case(MOVE_BACK):
  			direction = "umdrehen";
  			break;
  		case(MOVE_LEFT):
  			direction = "nach links";
  			break;
  		case(MOVE_RIGHT):
  			direction = "nach rechts";
  			break;
  	}


  	return(cell_mark_ + "," + direction + "," + state_);
  }

}
