package PrintGame;

import java.util.*;


/**
 * class represting a List of instructions which are excecuted by the 
 * turing machine. 
 */

public class InstructionList extends ArrayList
{
//-----------------------------------------------------------------------------
/**
 * method adds an instruction at the end of an instruction list.
 * @param instruction instruction to insert
 */  
  public void addInstruction(Instruction instruction)
  {
    super.add(instruction);
  }

//-----------------------------------------------------------------------------  
/**
 * method adds an instruction at the specified position to the instruction list.
 * @param index zero based position of the element to add.
 * @param instruction instruction to insert
 */    
  public void addInstructionAtPos(int index, Instruction instruction)
  {
    super.add(index, instruction);
  }

//-----------------------------------------------------------------------------  
/**
 * method gets an instruction at the specified position in the instruction list.
 * @param index zero based position of the requested instruction.
 */      
  public Instruction getInstructionAtPos(int index)
  {
    return (Instruction)super.get(index);
  }

//-----------------------------------------------------------------------------  
/**
 * method removes the instruction at the specified position.
 * @param index zero based position of the element to remove. 
 */    
  public void removeInstructionAtPos(int index)
  {
    super.remove(index);
  }
//-----------------------------------------------------------------------------  
/**
 * method removes all instruction.
 */    
  public void removeAllInstructions()
  {
    super.clear(); 
  }
}