package PrintGame;

import java.net.URL;

import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/**
 * InstructionListXMLContentHandler - XML Content Handler for instruction list stored in an XML file
 * 
 *
 */
public class InstructionTXTXMLContentHandler extends DefaultHandler {
    
    private String condition_start_string_;
    private String condition_end_string_;
    private String action_start_string_;
    private String action_end_string_;
    private String condition_action_separator_string_;
    private String separator_string_;
    private String comment_out_line_string_; 
    private String comment_out_start_string_;
    private String comment_out_end_string_;
    private String wall_string_;
    private String way_string_;
    private String direction_left_string_;
    private String direction_ahead_string_;
    private String direction_right_string_;
    private String direction_back_string_;
        
    private String current_tag_;
    private URL document_base_;
    private String document_;
    
    public InstructionTXTXMLContentHandler()
    {
        condition_start_string_ = new String();
        condition_end_string_= new String();
        action_start_string_= new String();
        action_end_string_= new String();
        condition_action_separator_string_= new String();
        separator_string_= new String();
	comment_out_line_string_= new String(); 
   	comment_out_start_string_= new String();
   	comment_out_end_string_= new String();
        wall_string_= new String();
        way_string_= new String();
        direction_left_string_= new String();
        direction_ahead_string_= new String();
        direction_right_string_= new String();
        direction_back_string_= new String();
	
        current_tag_ = new String();
        document_base_=null;
	document_=null;
    }
    
    public void setDocumentBase(URL document_base)
    {
        document_base_=document_base;
	System.out.println("url");
	System.out.println(document_base_);
    }
    
  public void setDocument(String document)
  {
    document_=document;
    	System.out.println("file");
	System.out.println(document_);
  }
    /**
     *Receive notification of the beginning of the document.
     */
    public void startDocument()
    {
        //nothing to do here.
    }
    
    /**
     *Receive notification of the start of an element.
     *@param attributes - The specified or defaulted attributes.
     *@param localName - The local name (without prefix),
     *or the empty string if Namespace processing is not being performed.
     *@param qualName - The qualified name (with prefix),
     *or the empty string if qualified names are not available.
     */
    
    public void startElement(String uri, String localName, String qualName, Attributes attribs)
    {
        current_tag_ = qualName;      
   }
    
    /**-----------------------------------------------------------------------------
     *Receive notification of character data inside an element.
     *@param charArray - The characters.
     *@param start - The start position in the character array.
     *@param length - The number of characters to use from the character array.
     */
    public void characters(char[] charArray, int start, int length)
    {
        if(current_tag_.length() > 0)
        {
            String temp_string = new String(charArray, start, length);
            temp_string = temp_string.trim();	    
	          
            if (current_tag_.equals(new String(TagName.CONDITIONSTARTSTRING)))
            {
              condition_start_string_=temp_string;
            }
            else if (current_tag_.equals(new String(TagName.CONDITIONENDSTRING)))
            {
              condition_end_string_=temp_string;
            }
            else if (current_tag_.equals(new String(TagName.ACTIONSTARTSTRING)))
            {
	    	action_start_string_=temp_string;
            }
            else if (current_tag_.equals(new String(TagName.ACTIONENDSTRING)))
            {
	    	action_end_string_=temp_string;
            }
            else if (current_tag_.equals(new String(TagName.CONDITIONACTIONSEPERATORSTRING)))
            {
	    	condition_action_separator_string_=temp_string;
            }
            else if (current_tag_.equals(new String(TagName.SEPERATORSTRING)))
            {
	    	separator_string_=temp_string;
            }
	    else if (current_tag_.equals(new String(TagName.COMMENTOUTLINESTRING)))
            {
	    	comment_out_line_string_=temp_string;
            }
	    else if (current_tag_.equals(new String(TagName.COMMENTOUTSTARTSTRING)))
            {
	    	comment_out_start_string_=temp_string;
            }
	    else if (current_tag_.equals(new String(TagName.COMMENTOUTENDSTRING)))
            {
	    	comment_out_end_string_=temp_string;
            } 
            else if (current_tag_.equals(new String(TagName.WALLSTRING)))
            {
	    	wall_string_=temp_string;
            }
            else if (current_tag_.equals(new String(TagName.WAYSTRING)))
            {
	    	way_string_=temp_string;
            }
            else if (current_tag_.equals(new String(TagName.DIRECTIONLEFTSTRING)))
            {
	    	direction_left_string_=temp_string;
            }
            else if (current_tag_.equals(new String(TagName.DIRECTIONAHEADSTRING)))
            {
	    	direction_ahead_string_=temp_string;
            }
	    else if (current_tag_.equals(new String(TagName.DIRECTIONRIGHTSTRING)))
            {
	    	direction_right_string_=temp_string;
            }
	    else if (current_tag_.equals(new String(TagName.DIRECTIONBACKSTRING)))
            {
	    	direction_back_string_=temp_string;
            }
        }
    }
    
    public void endElement(String uri, String localName, String qualName)
    {
 	current_tag_="";
    }

    /**
     *Receive notification of the end of the document.
     */
      public void endDocument()
      {

      }

      
      public String ConditionStartString()
      {
      	return condition_start_string_;
      }
      
      public String ConditionEndString()
      {
       	return condition_end_string_;
      }
      
      public String ActionStartString()
      {
      	return action_start_string_;
      }
      
      public String ActionEndString()
      {
      	return action_end_string_;
      }
      
      public String ConditionActionSeparatorString()
      {
      	return condition_action_separator_string_;
      }
      
      public String SeparatorString()
      {
      	return separator_string_;
      }
      
      public String CommentOutLineString()
      {
      	return comment_out_line_string_;
      }
      
      public String CommentOutStartString()
      {
      	return comment_out_start_string_;
      }
      
      public String CommentOutEndString()
      {
      	return comment_out_end_string_;
      }
      
      public String WallString()
      {
      	return wall_string_;
      }
      
      public String WayString()
      {
      	return way_string_;
      }
      
      public String DirectionLeftString()
      {
      	return direction_left_string_;
      }
      
      public String DirectionAheadString()
      {
      	return direction_ahead_string_;
      }
      
      public String DirectionRightString()
      {
      	return direction_right_string_;
      }
      
      public String DirectionBackString()
      {
     	return direction_back_string_;
      }
}
