package PrintGame;

import javax.swing.*;
import java.awt.*;

import org.xml.sax.*;
import java.lang.Integer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URI;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.xml.parsers.*;

import java.io.BufferedReader;
import java.io.InputStreamReader;

public class LabyrinthXpertMode
{ 
	private URL url_;
  private String file_;
  private TextArea ta_;
  private GameXMLContentHandler game_xml_content_handler_;
	private boolean is_error_;
  private int id_;
  private String level_file_;
  public LabyrinthXpertMode()
  {
    is_error_=true; 
    id_=0;
  }
  
	public void setUrl( URL url)
	{
  	url_=url;
	}
	 public void setFile(String file)
  {
    file_=file;
  }
  private void loadGameXmlFile()
  {
    try
    {
      SAXParserFactory factory = SAXParserFactory.newInstance();
      factory.setValidating(true);
      SAXParser saxParser = factory.newSAXParser();
      XMLReader xmlReader = saxParser.getXMLReader();
      
      game_xml_content_handler_ = new GameXMLContentHandler();
      game_xml_content_handler_.setDocumentBase(url_);
      xmlReader.setContentHandler(game_xml_content_handler_);
      XMLErrorHandler xml_error_handler = new XMLErrorHandler();
      xmlReader.setErrorHandler(xml_error_handler);
      xmlReader.parse(file_);
      is_error_=xml_error_handler.isXMLError();
      if(is_error_==false)
      {
       int num_levels = game_xml_content_handler_.getNumLevels();
       if((id_>0) && (id_<=num_levels))
        level_file_=game_xml_content_handler_.getFile(id_);
       else
        System.out.println("Wrong parameter for loading level...");
      }
    }
    catch(SAXException exc)
    {
      System.err.println(exc.getMessage());
    }
    catch(ParserConfigurationException exc)
    {
      System.err.println(exc.getMessage());
    }
    catch(IOException exc)
    {
      System.err.println(exc.getMessage());
    }
  }
  
  private String getLevelString()
  {
   int max_characters_ = 20000;
   BufferedReader in;
   try
   {
    in = new BufferedReader(new InputStreamReader(
      new URL(level_file_).openStream()));
      in.mark(max_characters_);
    }
    catch(Exception e)
    {
    System.out.println("Open File Error");
    in = null;
    }
    String tmp;
    String level="";
    if(in != null)
    {
      try
      {
          in.reset();
          while((tmp = in.readLine()) != null)
              level=level.concat(tmp).concat("\n");
       }
       catch(Exception e){System.out.println("while:"+e.getMessage());}
      }
      return level;
  
  }
  
  public String getLabyrinth(int id)
  {
  id_=id;
  loadGameXmlFile();
  String labyrinth=getLevelString();  
  return labyrinth;
  }  
}