package PrintGame;

import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.io.PrintWriter;
import java.io.DataInputStream;
import java.util.GregorianCalendar;
import java.util.Calendar;
import java.util.TimeZone;

public class SqlCommunicator {
	static private String temp_buffer_ = "";
	
	static private boolean activated_ = false;
	
	static public void activate(boolean activate)
	{
		activated_ = activate;
	}
	
	static public void saveRules(URL script_file, String user_id, int level, int lab_id, int pub, String text)
	{
		if (activated_)
		{
			URLConnection urlConn=null;
		    try
			{
				urlConn=script_file.openConnection();
			}
			catch(Exception w)
			{
				System.out.println("Rule writing failed! (openConnecton() failed)");
			}
			try
			{
				urlConn.setDoInput(true);
				urlConn.setUseCaches(false);
				
			}
			catch(Exception a)
			{
				System.out.println("Rule writing failed! (setDoInput() failed)");
			}
			try
			{
				urlConn.setDoOutput(true);
				PrintWriter out=new PrintWriter(urlConn.getOutputStream());
				out.println("user_id="+user_id+"&level="+Integer.toString(level)+"&lab_id="+Integer.toString(lab_id)+"&public="+Integer.toString(pub)+"&text="+URLEncoder.encode(text, "UTF-8"));
				out.close();
			    // Get response data.
				DataInputStream input = new DataInputStream (urlConn.getInputStream ());
			    String str;
			    while (null != ((str = input.readLine())))
				{
					System.out.println (str);
				}
				input.close ();
			}
			catch(Exception a)
			{
				System.out.println("Rule writing failed! " + a.getMessage());
			}	
		}
	}
	
	static public void add_log(String log_entry)
	{
		GregorianCalendar cal = new GregorianCalendar();
		cal.setTimeZone(TimeZone.getDefault());
		String timestamp = getTimestamp(cal);
		temp_buffer_ += timestamp + " : " + log_entry + "\n";
	}
	
	static public void flush_log(URL script_file, String user_id, int level)
	{
		if (activated_)
		{
			URLConnection urlConn=null;
		    try
			{
				urlConn=script_file.openConnection();
			}
			catch(Exception w)
			{
				System.out.println("Log writing failed! (openConnecton() failed)");
			}
			try
			{
				urlConn.setDoInput(true);
				urlConn.setUseCaches(false);
				
			}
			catch(Exception a)
			{
				System.out.println("Log writing failed! (setDoInput() failed)");
			}
			try
			{
				urlConn.setDoOutput(true);
				PrintWriter out=new PrintWriter(urlConn.getOutputStream());
				out.println("user_id="+user_id+"&level="+Integer.toString(level)+"&text="+URLEncoder.encode(temp_buffer_, "UTF-8"));
				out.close();
			    // Get response data.
				DataInputStream input = new DataInputStream (urlConn.getInputStream ());
			    String str;
			    while (null != ((str = input.readLine())))
				{
					System.out.println (str);
				}
				input.close ();
				temp_buffer_ = "";
			}
			catch(Exception a)
			{
				System.out.println("Log writing failed! " + a.getMessage());
			}
		}
		else
		{
			temp_buffer_ = "";
		}
	}
	
	static private String getTimestamp(GregorianCalendar cal)
	{
		String timestamp = "";
		
		timestamp = expandNumber(Integer.toString(cal.get(Calendar.YEAR)),2) + "-" +
					expandNumber(Integer.toString(cal.get(Calendar.MONTH)+1),2) + "-" +
					expandNumber(Integer.toString(cal.get(Calendar.DATE)),2) + " " +
					expandNumber(Integer.toString(cal.get(Calendar.HOUR_OF_DAY)),2) + ":" +
					expandNumber(Integer.toString(cal.get(Calendar.MINUTE)),2) + ":" +
					expandNumber(Integer.toString(cal.get(Calendar.SECOND)),2);
		
		return timestamp;
	}
	
	static private String expandNumber(String toExpand, int places)
	{
		while (toExpand.length() < places)
			toExpand = "0" + toExpand;
		return toExpand;
	}
}
