package PrintGame;

import java.awt.*;
import javax.swing.JLabel;
import TUGLaby.StatisticsPanel;
import TUGLaby.StatusPanel;
import TUGLaby.AktiveRulePanel;
/**
 * class representing a turing machine.
 */

public class TuringMachine
{
  /*public final static int SINGLE_STEP = 1;
  public final static int FASTFORWARD = 100;
  public final static int VERYFASTFORWARD = 60;
  public final static int NORMAL      = 180;
  public final static int CRAZY		  = 2;*/

  private int num_visited_;
  private boolean single_step_;

  private InstructionList instruct_list_;
  private Robot robot_;
  private LabyrinthField lab_field_;
  private int num_steps_;
  private int num_taken_diamonds_;
  private int max_num_diamonds_;
  private int delay_time_;
  private boolean finished_;
  private boolean stopped_;
  private String message_="   Programm luft...";
  private int mode_;
  private int num_next_steps_;
  private Component component_;
  private StatisticsPanel statistics_;

  private StatusPanel status_message_;
  private AktiveRulePanel aktive_panel_;

  private boolean run_=false;
  private boolean sleep_=false;
//-----------------------------------------------------------------------------
/**
 * method returns the conditions of robot's environment
 * @return info about the current condition
 */
  protected Condition getFieldConditions()
  {
    int current_row = robot_.getPosRow();
    int current_col = robot_.getPosCol();
    int cell_mark = lab_field_.getCellMark(current_row, current_col);
    boolean wall_ahead = false;
    boolean wall_left = false;
    boolean wall_right = false;
    int state = robot_.getState();
//     Lock l;

    try
    {
      switch (robot_.getCurrentDirection().getDirection())
      {
        case Direction.DIRECTION_UP:
          wall_ahead = lab_field_.isWall(current_row-1, current_col);
          wall_left  = lab_field_.isWall(current_row, current_col-1);
          wall_right = lab_field_.isWall(current_row, current_col+1);
          break;
        case Direction.DIRECTION_DOWN:
          wall_ahead = lab_field_.isWall(current_row+1, current_col);
          wall_left  = lab_field_.isWall(current_row, current_col+1);
          wall_right = lab_field_.isWall(current_row, current_col-1);
          break;
        case Direction.DIRECTION_LEFT:
          wall_ahead = lab_field_.isWall(current_row, current_col-1);
          wall_left  = lab_field_.isWall(current_row+1, current_col);
          wall_right = lab_field_.isWall(current_row-1, current_col);
          break;
        case Direction.DIRECTION_RIGHT:
          wall_ahead = lab_field_.isWall(current_row, current_col+1);
          wall_left  = lab_field_.isWall(current_row-1, current_col);
          wall_right = lab_field_.isWall(current_row+1, current_col);
          break;
      }
    }
    catch (IllegalDirectionException ex)
    {
      System.err.println(ex.getMessage());
    }

    Condition temp_condition = new Condition(state, cell_mark, wall_left, wall_right, wall_ahead );

    return temp_condition;
  }

//-----------------------------------------------------------------------------
/**
 * method performes the given action and checks if the robot crashes
 * @param action specifies what to do
 * @return true if no problems occure during the action, false if the robot is crashed
 */
  protected boolean performAction(Action action)
  {
    int current_row = robot_.getPosRow();
    int current_col = robot_.getPosCol();
    boolean action_performed = false;

    try
    {
      switch (action.getMovingDirection())
      {
        case Action.MOVE_AHEAD:
          robot_.moveForward();
          break;
        case Action.MOVE_BACK:
          robot_.goBack();
          break;
        case Action.MOVE_LEFT:
          robot_.goLeft();
          break;
        case Action.MOVE_RIGHT:
          robot_.goRight();
          break;
      }

    }
    catch (IllegalDirectionException ex)
    {
      System.err.println(ex.getMessage());
    }
    boolean is_wall=false;
    try
    {
        is_wall = lab_field_.isWall(robot_.getPosRow(), robot_.getPosCol());
    }
    catch(IllegalArgumentException ex)
    {
        System.err.println("ERROR: Robot's position is not valid!");
    }
    if( is_wall )
    {
      robot_.setPos(current_row, current_col);

    }
    else
    {
      robot_.setState(action.GetState());
      lab_field_.setCellMark(current_row, current_col, action.getCellMark());
      action_performed = true;
    }

    return action_performed;
  }

//-----------------------------------------------------------------------------
/**
 *
 */
  public void setInstructionList(InstructionList instruct_list)
  {
    instruct_list_ = instruct_list;
  }

//-----------------------------------------------------------------------------
/**
 *
 */
  public void setRobot(Robot robot)
  {
    robot_ = robot;
  }

//-----------------------------------------------------------------------------
/**
 *
 */
  public void setLabyrinthField(LabyrinthField lab_field)
  {
    lab_field_ = lab_field;
  }

 //-----------------------------------------------------------------------------
/**
 *
 */

  public void setStatusPanel(StatusPanel status_message)
  {
    status_message_=status_message;
  }

  public void setAktiveRulePanel(AktiveRulePanel aktive_panel)
  {
    aktive_panel_=aktive_panel;
  }

 public void takeAndCalcDiamonds()
 {
   boolean contains_diamond=false;
   try
   {
       contains_diamond = lab_field_.containsDiamond(robot_.getPosRow(), robot_.getPosCol());
   }
   catch(IllegalArgumentException ex)
   {
       System.err.println("ERROR: Robot's position is not valid!");
   }
   if(contains_diamond)
   {
     num_taken_diamonds_++;
     lab_field_.removeDiamond(robot_.getPosRow(), robot_.getPosCol());
   }

 }

  public void setVisited()
  {
     if((lab_field_.isVisited(robot_.getPosRow(), robot_.getPosCol())==false) && (checkCellIsStartpoint()==true))
     {
       lab_field_.setVisited(robot_.getPosRow(), robot_.getPosCol());
       num_visited_++;
     }
  }

  public void start(Component component, StatisticsPanel statistics)
    throws InterruptedException
  {
    Direction initial_direction_=new Direction(lab_field_.getStartDirection());
	// System.out.println("Here is TURING: dir="+initial_direction_);
    finished_ = false;
    stopped_=false;
    component_=component;
    statistics_=statistics;
    max_num_diamonds_ = lab_field_.getNumDiamonds();
    num_taken_diamonds_ = 0;
    num_steps_ = 0;
    num_visited_=0;

    runLoop();
	  lab_field_.setStartDirection(initial_direction_);
  }

//-----------------------------------------------------------------------------
public void stop(boolean stopped)
{
  stopped_=stopped;
  if(stopped_==true)
   message_="   Programm angehalten!";
  else
   message_="   Programm luft...";
  status_message_.setNewText(message_);
}
//-----------------------------------------------------------------------------
public void singleStepMode(boolean mode)
{
  single_step_=mode;
}
//-----------------------------------------------------------------------------
  public void setSpeed(int delay_time)
  {
    delay_time_ = delay_time;
    if(delay_time_==0)
    {
      single_step_=true;
    }
    else
      single_step_=false;
  }
//-----------------------------------------------------------------------------
/**
 * method processes an instruction list
 * @param component window which contains the labyrinth field
 */
  public void runLoop()
    throws InterruptedException
  {
    //while(finished_ == false && stopped_ == false )
    while(finished_ == false)
    {
      run_=true;
/*      System.out.println("field conditions: "+field_condition.isWallLeft()
                                            +field_condition.isWallRight()
                                            +field_condition.isWallAhead()
                                            +field_condition.getCellMark()
                                            +field_condition.isNewArea());*/
      while(stopped_==true)
        Thread.sleep(50);

      if (single_step_==false)
      {
        //if(delay_time_>1)
          Thread.sleep(delay_time_);
          runSingleStep();
      }
      else if (num_next_steps_ > 0)
      {
        runSingleStep();
        num_next_steps_--;
      }
      else
      {
        while(sleep_==true)
          Thread.sleep(50);
        runSingleStep();
      }

    }
    run_=false;
  }

//-----------------------------------------------------------------------------
    public void runSingleStep()
    throws InterruptedException
  {
    Instruction current_instruction;
    Condition field_condition;
    field_condition = getFieldConditions();
    int num_instructions = instruct_list_.size();
    boolean condition_found = false;

    if(single_step_==true)
      sleep_=true;

    for(int index=0; index < num_instructions; index++)
    {
      current_instruction = instruct_list_.getInstructionAtPos(index);

/*   System.out.println("instruct conditions: "+current_instruction.getCondition().isWallLeft()
                                            +current_instruction.getCondition().isWallRight()
                                            +current_instruction.getCondition().isWallAhead()
                                            +current_instruction.getCondition().getCellMark()
                                            +current_instruction.getCondition().isNewArea());*/


      if(field_condition.equals(current_instruction.getCondition()))
      {

        aktive_panel_.setRule(current_instruction);
        if (!performAction(current_instruction.getAction()))
        {
          message_="   Oje, der Roboter ist in die Wand gekracht!";
          component_.repaint();
          if(single_step_==false)
            finished_ = true;
          else
          {
            status_message_.setNewText(message_);
            sleep_=true;
            while(sleep_==true)
              Thread.sleep(50);
            status_message_.setNewText("   Programm luft..");
            robot_.restoreLastDirection();
            runSingleStep();
          }
        }
        else
        {
          takeAndCalcDiamonds();
          num_steps_++;
          if (!checkCellIsStartpoint() && num_taken_diamonds_==max_num_diamonds_)
          {
            finished_ = true;
            message_="   Gratuliere, du hast es geschafft!";
            aktive_panel_.removeAktiveRule();
          }
					else if (!checkCellIsStartpoint())
					{
            finished_ = true;
            message_="   Du hast nicht alle Diamanten eingesammelt!";
            aktive_panel_.removeAktiveRule();
					}
        }
        setVisited();
        component_.repaint();
        statistics_.refreshPanel(num_steps_, num_taken_diamonds_, num_visited_);

        condition_found = true;
        break;
      }
    }
    if(condition_found == false)
    {
      aktive_panel_.removeAktiveRule();
      message_ = "   Keine Regel gefunden, " +
      "das Programm ist nicht vollstndig!";
      if(single_step_==false)
        finished_ = true;
      else
      {
        status_message_.setNewText(message_);
        sleep_=true;
        while(sleep_==true)
          Thread.sleep(50);
        status_message_.setNewText("   Programm luft..");
        runSingleStep();
      }
    }
 }

  public String getMessage()
  {
  return message_;
  }
  public boolean wasStopped()
  {
  return stopped_;
  }
 //-----------------------------------------------------------------------------
  public void setSleep(boolean sleep)
  {
  sleep_=sleep;
  }
//-----------------------------------------------------------------------------
/**
 * method checks if the robot's position is the startpoint.
 */
  public boolean checkCellIsStartpoint()
  {
    boolean cell_ok = true;
    int current_row = robot_.getPosRow();
    int current_col = robot_.getPosCol();
    if (lab_field_.isStartpoint(current_row, current_col) && (num_steps_ > 0))
    {
      cell_ok = false;
    }
    return cell_ok;

  }
//------------------------------------------------------------------------------------
  /*public void setMode(int mode)
  {
    mode_ = mode;
    if (mode_ != SINGLE_STEP)
    {
      delay_time_ = mode;
    }
  }*/

  public int getNumSteps()
  {
    return num_steps_;
  }

  public int getNumTakenDiamonds()
  {
    return num_taken_diamonds_;
  }

  public boolean isFinished()
  {
    return finished_;
  }

  public void setNumNextSteps(int num_next_steps)
  {
    num_next_steps_ = num_next_steps;
  }
}
