package TUGLaby;

import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.BorderFactory;
import java.util.HashMap;
import java.awt.Dimension;
import java.util.LinkedList;

import PrintGame.Instruction;

public class AktiveRulePanel extends javax.swing.JPanel
{
    private HashMap brick_images_;
    private JLabel message_;
    private static final int CONDITION_HEIGHT = 80;
    private static final int CONDITION_WIDTH = 225;
    private TUGLabyrinth labyrinth_;
    private Dimension start_dimension_;
    private ConditionRulePanel new_rule_;
    private int id_;
    private Instruction rule_;
    public AktiveRulePanel(HashMap brick_images, TUGLabyrinth labyrinth) 
    {
        initComponents();
        labyrinth_=labyrinth;
        id_=0;
        rule_=null;
        this.setBackground(Color.ORANGE);
        brick_images_ = brick_images;
        setBorder(BorderFactory.createTitledBorder("Aktive Regel")); 
        start_dimension_ = this.getSize();   
//         rule_=new Instruction();
 
    }
    
    private void initComponents() 
    {
        setLayout(null);
    }
    
    public void drawAktiveRule()
    {
        this.removeAll();
            new_rule_.setBounds(15,26 , CONDITION_WIDTH,
                    CONDITION_HEIGHT);
            this.add(new_rule_);
            new_rule_.repaint();
        this.repaint();
    }
    public void removeAktiveRule()
    {
        this.removeAll();
        new_rule_=null;
        this.repaint();
    }
   
    public int getRuleId()
    {
     return id_;
    }
    
    public Instruction getInstruction()
    {
      if(new_rule_!=null)
      {
        rule_=new Instruction(new_rule_.getInstruction());
        return rule_;
      }
      else 
        return null;
    }
     public void setRule(Instruction rule) 
     {
        JPanel new_rule = null;
        rule_=new Instruction(rule);
        int preset_ahead_sensor = SensorChoosePanel.FREE;
        int preset_left_sensor = SensorChoosePanel.FREE;
        int preset_right_sensor = SensorChoosePanel.FREE;
        int preset_current_sensor = CurrentSensorPanel.EMPTY_FLOOR;
        int preset_state = ConditionChoosePanel.NONE;
        int preset_action_direction = DirectionChoosePanel.UP;
        int preset_action_current_sensor = CurrentSensorPanel.EMPTY_FLOOR;
        int preset_action_state = ConditionChoosePanel.NONE;

        if (rule.getCondition().isWallAhead())
            preset_ahead_sensor = SensorChoosePanel.WALL;

        if (rule.getCondition().isWallLeft())
            preset_left_sensor = SensorChoosePanel.WALL;

        if (rule.getCondition().isWallRight())
            preset_right_sensor = SensorChoosePanel.WALL;


        preset_current_sensor = rule.getCondition().getCellMark() + 1;

        preset_state = rule.getCondition().getState() + 1;

        preset_action_direction = rule.getAction().getMovingDirection();

        preset_action_current_sensor = rule.getAction().getCellMark() + 1;

        preset_action_state = rule.getAction().GetState() + 1;

        LinkedList list=labyrinth_.rule_tree_panel_.getRuleList();
         for (int index = 0; index < list.size(); index++)
        {
           ConditionRulePanel temp = (ConditionRulePanel) list.get(index);
           Instruction tmp_instruction=temp.getInstruction();
           if(tmp_instruction.equals(rule))
               id_=temp.getID();
        }
        
        new_rule_ = new ConditionRulePanel(
                id_,
                brick_images_,
                preset_ahead_sensor,
                preset_left_sensor,
                preset_right_sensor,
                preset_current_sensor,
                preset_state,
                preset_action_direction,
                preset_action_current_sensor,
                preset_action_state,
                labyrinth_, true);
                
        this.drawAktiveRule();              
        if (new_rule != null) 
        {
        System.out.println("new_rule != null\n");
        }

    }   
}
