package TUGLaby;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;

import javax.swing.BorderFactory;

/*
 * JBrickPanel.java
 *
 * Created on 25. August 2004, 18:28
 *
 * This is the visual representation of a single dragable condition
 * or action. A new type of dragable instance can easily created by
 * giving a new type name and images
 */

/**
 * 
 * @author auguan@sbox
 */

public class BrickPanel extends javax.swing.JPanel {

    private String brick_type_;

    private Image default_image_;

    private Image current_image_;

    private Image mouse_over_image_;

    //dnd private DragSource drag_source_;

    //dnd private DragGestureListener drag_gesture_listener_;

    //dnd public DragSourceListener drag_rule_listener_;

    //dnd private int drag_action_ = DnDConstants.ACTION_COPY; //FIXXME Reformat as

    // const

    RuleTreePanel rule_tree_panel_;
    /**
     * Creates new form JBrickPanel
     * 
     * @param brick_type
     * @param default_image
     * @param hover_image
     */
    public BrickPanel(String brick_type, Image default_image, Image hover_image,
                      RuleTreePanel rule_tree_panel) {

        default_image_ = default_image;
        this.mouse_over_image_ = hover_image;
        brick_type_ = brick_type;
        current_image_ = default_image_;
        rule_tree_panel_ = rule_tree_panel;
        //dnd drag_source_ = DragSource.getDefaultDragSource();
//      dnd drag_gesture_listener_ = new DragRuleGestureListener();
//      dnd drag_rule_listener_ = new DragRuleSourceListener();

//      dnd this.drag_source_.createDefaultDragGestureRecognizer(this,
//      dnd         this.drag_action_, this.drag_gesture_listener_);

        this.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                current_image_ = mouse_over_image_;
                repaint();
            }

            public void mouseReleased(java.awt.event.MouseEvent evt) {
                current_image_ = default_image_;
                repaint();
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                BrickPanel.this.setBorder( BorderFactory.createLineBorder(Color.white,1) );
                repaint();
            }

            public void mouseExited(java.awt.event.MouseEvent evt) {
                BrickPanel.this.setBorder( null );
                repaint();
            }
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                rule_tree_panel_.addNewRule(brick_type_, true);
            }
        });
		// Initially display 4 Rules - this is done for usablility reasons.
		for(int i=0;i<4;i++) rule_tree_panel_.addNewRule(brick_type_, true);
    }

    /**
     * Set a new bricktype
     * 
     * @param brick_type
     */
    public void setBrickType(String brick_type) {
        this.brick_type_ = brick_type;
    }

    /**
     * Set an new default image
     * 
     * @param default_image
     */
    public void setDefaultImage(Image default_image) {
        this.default_image_ = default_image;

    }

    /*
     * (non-Javadoc) Draws the panel with the given image
     * 
     * @see javax.swing.JComponent#paintComponent(java.awt.Graphics)
     */
    public void paintComponent(Graphics g) {
        super.paintComponent(g);

        g.drawImage(current_image_, 0, 0, this);

    }
 
    /** ************************************************************************ */
    // insert file drag_listener_from_BrickPanel.txt here to add dnd support
}
