package TUGLaby;

import java.awt.Color;
import java.awt.TextArea;
import java.awt.event.WindowListener;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.BorderLayout;
import java.awt.Font;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import java.net.URL;
import java.net.MalformedURLException;

import java.io.StringBufferInputStream;
import java.io.ByteArrayInputStream;
import org.xml.sax.InputSource;

import PrintGame.LabyrinthXpertMode;

public class LabyrinthXpertFrame extends JPanel implements WindowListener{

  static JFrame frame_;
  private JButton submit_button_;
  private TextArea ta_;
  private TUGLabyrinth top_;
  private int selected_labyrinth_;

  LabyrinthXpertFrame(URL url, TUGLabyrinth top_object, int selected_labyrinth)
  {
      top_=top_object;
      selected_labyrinth_=selected_labyrinth;
      String file= top_.file_name_;

      ta_ = new TextArea();
      Font f = new Font( "Monospaced", Font.PLAIN, 12 );
      ta_.setFont(f);
      final LabyrinthXpertMode xpert= new LabyrinthXpertMode();
      xpert.setUrl(url);
      xpert.setFile(file);
      submit_button_ = new JButton();
      submit_button_.setBounds(5,5,89,40);
      submit_button_.setBackground(Color.ORANGE);
      submit_button_.setForeground(new Color(0,0,0));
      submit_button_.setText("Labyrinth bernehmen");
      submit_button_.addActionListener
      (new java.awt.event.ActionListener()
         {public void actionPerformed(java.awt.event.ActionEvent evt)
           {
               String labyrinth=ta_.getText();
               InputSource source=new InputSource(new StringBufferInputStream(labyrinth));
//                top_.level_handler_.loadLevel(source);
               top_.menue_panel_.refreshList(0);
               top_.level_xpert_source_=labyrinth;
               top_.drawNewLabyrinth();
                }
              }
            );
             frame_ = new JFrame("Marvin-10 Experten-Modus");
             frame_.getContentPane().setLayout(new BorderLayout());
             frame_.getContentPane().add(submit_button_, BorderLayout.NORTH);
             frame_.getContentPane().add(ta_, BorderLayout.CENTER);
             frame_.addWindowListener(this);
             frame_.setSize(600,800 );
             frame_.setVisible(true);
             String labyrinth=xpert.getLabyrinth(selected_labyrinth_);
             ta_.setText(labyrinth);
   }

   public void windowClosing(WindowEvent e)
   {
      top_.menue_panel_.decrementCount();
      top_.menue_panel_.refreshList();
    }

    public void windowClosed(WindowEvent e) { }

    public void windowOpened(WindowEvent e) { }

    public void windowIconified(WindowEvent e) { }

    public void windowDeiconified(WindowEvent e) { }

    public void windowActivated(WindowEvent e) { }

    public void windowDeactivated(WindowEvent e) { }

}