/*
 * Created on 24.09.2005
 *
 */
package TUGLaby;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.*;
import java.net.URL;
import java.util.LinkedList;
import java.awt.GridLayout;
import PrintGame.Instruction;
import PrintGame.InstructionList;
import PrintGame.RuleTxtParser;
import PrintGame.RuleTxtWriter;
import PrintGame.SqlCommunicator;
/**
 * Contains the Menue shown in the GUI
 */
public class MenuePanel{

    private JMenuBar menue_;
    private JMenu rule_, labyrinth_, level_of_difficulty_, xpertmode_;
    private JMenuItem add_, help_;
    private JMenuItem new_labyrinth_, save_labyrinth_, load_labyrinth_, save_rule_, load_rule_;
    private JMenuItem rule_xpert_, labyrinth_xpert_;
//     private JRadioButtonMenuItem easy_, difficult_, loops_, free_, places_;
    private ButtonGroup difficulty_;

    private int current_selected_, count_;
    private TUGLabyrinth top_;
    private URL url_;
    private InstructionList instruct_list_;
    private RuleXpertFrame rule_xpert_frame_;
    private LabyrinthXpertFrame labyrinth_xpert_frame_;
    private int labyrinth_xpert_count_;

    private int index_of_draw_difficult_menue_=0;

		private JRadioButtonMenuItem radio_list_[];
		private LinkedList level_name_list_;

    MenuePanel(URL url, TUGLabyrinth top_object_)
    {
    super();
    top_=top_object_;
    url_=url;
    current_selected_=1;
    labyrinth_xpert_count_=0;


    // BEGIN OF NEW RULE BUTTON  *******************************************

    add_ = new JMenuItem("Regel hinzufgen");
    add_.setBackground(new Color(127,127,127));
    add_.setForeground(Color.ORANGE);

      add_.addActionListener(
      new java.awt.event.ActionListener()
        {public void actionPerformed(java.awt.event.ActionEvent evt)
          {
            int rule_id = top_.rule_tree_panel_.addNewRule("ConditionRule", true);
            SqlCommunicator.add_log("Rule added. Rule id: " + Integer.toString(rule_id));
          }
        }
       );

    // END OF NEW RULE BUTTON **************************************************

    // BEGIN OF EXPERTEN-MODUS BUTTON ****************************************************

    xpertmode_ = new JMenu("Expertenmodus");
    xpertmode_.setBackground(new Color(127,127,127));
    xpertmode_.setForeground(Color.ORANGE);

    rule_xpert_= new JMenuItem("Regelsatz editieren");
    rule_xpert_.setBackground(new Color(127,127,127));
    rule_xpert_.setForeground(Color.ORANGE);
    labyrinth_xpert_= new JMenuItem("Labyrinth editieren");
    labyrinth_xpert_.setBackground(new Color(127,127,127));
    labyrinth_xpert_.setForeground(Color.ORANGE);
    xpertmode_.add(rule_xpert_);
    xpertmode_.add(labyrinth_xpert_);

    rule_xpert_.addActionListener
    (new java.awt.event.ActionListener()
        {public void actionPerformed(java.awt.event.ActionEvent evt)
          {
             instruct_list_ = new InstructionList();
             LinkedList listi = top_.rule_tree_panel_.getRuleList();
            for (int i = 0; i < listi.size(); i++)
            {
              Instruction dummy = ((ConditionRulePanel) listi.get(i)).getInstruction();
              instruct_list_.addInstruction(dummy);
            }
            rule_xpert_frame_ = new RuleXpertFrame(url_,top_,instruct_list_);
          }
        }
      );
     labyrinth_xpert_.addActionListener
    (new java.awt.event.ActionListener()
        {public void actionPerformed(java.awt.event.ActionEvent evt)
          {
            labyrinth_xpert_frame_ = new LabyrinthXpertFrame(url_,top_,current_selected_);
            labyrinth_xpert_count_++;
          }
        }
      );

   // END EXPERTEN-MODUS BUTTON ********************************************************

    // BEGIN OF RULE MENUE  ***********************************************
    rule_= new JMenu("Regelstze");
    rule_.setBackground(new Color(127,127,127));
    rule_.setForeground(Color.ORANGE);
    save_rule_= new JMenuItem("speichern");
    save_rule_.setBackground(new Color(127,127,127));
    save_rule_.setForeground(Color.ORANGE);
    load_rule_= new JMenuItem("laden");
    load_rule_.setBackground(new Color(127,127,127));
    load_rule_.setForeground(Color.ORANGE);
    rule_.add(save_rule_);
    rule_.add(load_rule_);

    save_rule_.addActionListener
    (new java.awt.event.ActionListener()
        {public void actionPerformed(java.awt.event.ActionEvent evt)
          {
             instruct_list_ = new InstructionList();
             LinkedList listi = top_.rule_tree_panel_.getRuleList();
            for (int i = 0; i < listi.size(); i++)
            {
              Instruction dummy = ((ConditionRulePanel) listi.get(i)).getInstruction();
              instruct_list_.addInstruction(dummy);
            }
        RuleTxtWriter writer_ = new RuleTxtWriter(url_);
    		writer_.setMarkArray(top_.mark_array_);
    		writer_.setStateArray(top_.state_array_);
    		String text=writer_.writeText(instruct_list_);

	    	URL saverule_url;
	    	String user_id = top_.getParameter("userid");
	    	try
	    	{
	    		saverule_url = new URL(top_.getCodeBase(),"saverule.php");
	    		SqlCommunicator.saveRules(saverule_url, user_id, getCurrentSelectedLevel(), 0, 0, text);
	    	}
	    	catch(Exception e)
	    	{
	    		System.out.println("Rule writing failed! (Could not get code base)");
	    	}
           }
        }
      );
    load_rule_.addActionListener
    (new java.awt.event.ActionListener()
        {public void actionPerformed(java.awt.event.ActionEvent evt)
          {
	    	/*URL rulelist_url;
	    	String user_id = top_.getParameter("userid");
	    	try
	    	{
	    		rulelist_url = new URL(top_.getCodeBase(),"rulelist.php");
	    		list = SqlCommunicator.getRulesListForUser(rulelist_url, user_id);
	    	}
	    	catch(Exception e)
	    	{
	    		System.out.println("Rule writing failed! (Could not get code base)");
	    	}

            RuleTxtParser parser_ = new RuleTxtParser(url_);
    		parser_.setMarkArray(top_.mark_array_);
    		parser_.setStateArray(top_.state_array_);
    		instruct_list_=parser_.parseText(code);
    		top_.mark_array_=parser_.getMarkArray();
    		top_.state_array_=parser_.getStateArray();
            for(int count=0;count<instruct_list_.size();count++)
            {
             Instruction tmp_instruction=instruct_list_.getInstructionAtPos(count);
             top_.rule_tree_panel_.addNewRule(tmp_instruction, false);
            }*/
          }
        }
      );
    // END OF RULE MENUE  *****************************************************

    // BEGIN OF LABYRINTH MENUE  **********************************************
    labyrinth_= new JMenu("Labyrinth");
    labyrinth_.setBackground(new Color(127,127,127));
    labyrinth_.setForeground(Color.ORANGE);
    new_labyrinth_ = new JMenuItem("neu");
    new_labyrinth_.setBackground(new Color(127,127,127));
    new_labyrinth_.setForeground(Color.ORANGE);
      new_labyrinth_.setActionCommand("MenuEintrag 'neues Labyrinth' ausgewhlt");
      new_labyrinth_.addActionListener(
      new java.awt.event.ActionListener()
        {public void actionPerformed(java.awt.event.ActionEvent evt)
          {
            top_.drawNewLabyrinth();
          }
        }
       );

    save_labyrinth_= new JMenuItem("speichern");
    save_labyrinth_.setBackground(new Color(127,127,127));
    save_labyrinth_.setForeground(Color.ORANGE);
    load_labyrinth_= new JMenuItem("laden");
    load_labyrinth_.setBackground(new Color(127,127,127));
    load_labyrinth_.setForeground(Color.ORANGE);
    labyrinth_.add(new_labyrinth_);
    labyrinth_.add(save_labyrinth_);
    labyrinth_.add(load_labyrinth_);
   // END OF LABYRINTH MENUE  **************************************************

   // BEGIN OF DIFFICULTY MENUE  ***********************************************

    drawDifficultMenue();




   // END OF DIFFICULTY MENUE  ***********************************************

   // BEGIN OF HELP BUTTON  *********************************************
    help_= new JMenuItem("Hilfe");
    help_.setBackground(new Color(127,127,127));
    help_.setForeground(Color.ORANGE);
    help_.addActionListener(
    new java.awt.event.ActionListener()
    {public void actionPerformed(java.awt.event.ActionEvent evt) {
    HelpWindow help_window=new HelpWindow(url_);
    help_window.showHelpWindow();
    }
    });
   // END OF HELP BUTTON  ***********************************************

    menue_=new JMenuBar();
    menue_.setLayout(new GridLayout(0,6));
//     menue_.setLayout(null);

//     add_.setBounds(5,2, 150, 30);
//     xpertmode_.setBounds(2,2, 150, 30);
//     rule_.setBounds(2,2, 150, 30);
//     labyrinth_.setBounds(2,2, 150, 30);
//     level_of_difficulty_.setBounds(2,2, 150, 30);
//     help_.setBounds(2,2, 150, 30);

    menue_.add(add_);
    menue_.add(xpertmode_);
    menue_.add(rule_);
    menue_.add(labyrinth_);
    menue_.add(level_of_difficulty_);
    index_of_draw_difficult_menue_=menue_.getMenuCount();
    //menue_.add(Box.createHorizontalGlue());
    menue_.add(help_);
    menue_.setBackground(new Color(127,127,127));
    top_.setJMenuBar(menue_);
  }

 public int getCurrentSelectedLevel()
 {
    return current_selected_;
 }
 public void decrementCount()
 {
 labyrinth_xpert_count_--;
 }

 public void refreshList(int number){
 	current_selected_=number;
	refreshList();
 }

 public void refreshList(){
    menue_.remove(index_of_draw_difficult_menue_-1);
    level_of_difficulty_.removeAll();
    drawDifficultMenue();
    menue_.add(level_of_difficulty_,index_of_draw_difficult_menue_-1);
    top_.setJMenuBar(menue_);
  }


   private void drawDifficultMenue()
   {
    level_of_difficulty_= new JMenu("Schwierigkeitsgrad");
    level_of_difficulty_.setBackground(new Color(127,127,127));
    level_of_difficulty_.setForeground(Color.ORANGE);
    difficulty_ = new ButtonGroup();

		if(top_.level_handler_!=null)
		{
			level_name_list_ = top_.level_handler_.getLevelNameList();
			if(labyrinth_xpert_count_>0)
				radio_list_ = new JRadioButtonMenuItem[level_name_list_.size()+1];
			else
				radio_list_ = new JRadioButtonMenuItem[level_name_list_.size()];

			for(int count=0; count<level_name_list_.size();count++)
			{

				if(current_selected_==count+1 ||
				(current_selected_==0 && labyrinth_xpert_count_==0 && count==0))
				{
					radio_list_[count] = new JRadioButtonMenuItem((String)level_name_list_.get(count), true);
					current_selected_=count+1;
				}
				else
					radio_list_[count] = new JRadioButtonMenuItem((String)level_name_list_.get(count));

				radio_list_[count].setBackground(new Color(127,127,127));
				radio_list_[count].setForeground(Color.ORANGE);

				radio_list_[count].addItemListener(
					new java.awt.event.ItemListener()
						{public void itemStateChanged(java.awt.event.ItemEvent event)
							{
							if (event.getStateChange() == ItemEvent.SELECTED)
								{
								int max;
								if(labyrinth_xpert_count_>0)
									max=level_name_list_.size()+1;
								else
									max=level_name_list_.size();
								for (int i = 0; i < max; i++) {
									if (((JRadioButtonMenuItem) event.getSource()) == radio_list_[i]) {
											radio_list_[i].setSelected(true);
											if(i==level_name_list_.size())
												current_selected_ = 0;
											else
												current_selected_ = i + 1;
									}
									else
									{
										radio_list_[i].setSelected(false);
									}
								}
								top_.drawNewLabyrinth();
								}
							}
						}
					);

				difficulty_.add(radio_list_[count]);
				level_of_difficulty_.add(radio_list_[count]);

			}
		}

     if(labyrinth_xpert_count_ > 0)
     {
		 int count=level_name_list_.size();
//      current_selected_=0;
     radio_list_[count] = new JRadioButtonMenuItem("Expertemodus", true);
     radio_list_[count].setBackground(new Color(127,127,127));
     radio_list_[count].setForeground(Color.ORANGE);
				radio_list_[count].addItemListener(
					new java.awt.event.ItemListener()
						{public void itemStateChanged(java.awt.event.ItemEvent event)
							{
							if (event.getStateChange() == ItemEvent.SELECTED)
								{
								int max;
								if(labyrinth_xpert_count_>0)
									max=level_name_list_.size()+1;
								else
									max=level_name_list_.size();
								for (int i = 0; i < max; i++)
								{
									if (((JRadioButtonMenuItem) event.getSource()) == radio_list_[i])
									{
										radio_list_[i].setSelected(true);
										if(i==level_name_list_.size())
											current_selected_ = 0;
										else
											current_selected_ = i + 1;
									}
									else
									{
										radio_list_[i].setSelected(false);
									}
								}
								top_.drawNewLabyrinth();
								}
							}
						}
					);

				difficulty_.add(radio_list_[count]);
				level_of_difficulty_.add(radio_list_[count]);
     }
  }
}


