package TUGLaby;

import java.awt.Color;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.BorderLayout;
import java.awt.Font;
import javax.swing.JButton;
import javax.swing.JFrame;
import java.net.URL;

import PrintGame.Instruction;
import PrintGame.InstructionList;
import PrintGame.RuleXpertMode;

public class RuleXpertFrame{

  private JFrame frame_;
  private JButton submit_button_;
  private TextArea ta_; 
  private TUGLabyrinth top_;
  private InstructionList instruct_list_;
  RuleXpertFrame(URL url, TUGLabyrinth top_object_, InstructionList instruction_list)
  {
      top_=top_object_;
      ta_ = new TextArea(); 
      Font f = new Font( "Monospaced", Font.PLAIN, 12 );
      ta_.setFont(f);
      instruct_list_ = instruction_list;
      final RuleXpertMode xpert= new RuleXpertMode();
      xpert.setUrl(url);
      xpert.setMarkArray(top_.mark_array_);    
      xpert.setStateArray(top_.state_array_);    
      
      submit_button_ = new JButton();
      submit_button_.setBounds(5,5,89,40);
      submit_button_.setBackground(Color.ORANGE);
      submit_button_.setForeground(new Color(0,0,0));
      submit_button_.setText("Regelsatz bernehmen");
      submit_button_.addActionListener
      (new java.awt.event.ActionListener() 
         {public void actionPerformed(java.awt.event.ActionEvent evt) 
           {
            top_.rule_tree_panel_.deleteAllRules();
             instruct_list_=xpert.getRuleList(ta_);
                for(int count=0;count<instruct_list_.size();count++)
                 {
                  Instruction tmp_instruction=instruct_list_.getInstructionAtPos(count);
                  top_.rule_tree_panel_.addNewRule(tmp_instruction, false);
                 }
                 top_.mark_array_=xpert.getMarkArray();
                 top_.state_array_=xpert.getStateArray();  
                }
              }
            );
             frame_ = new JFrame("Marvin-10 Experten-Modus");
             frame_.getContentPane().setLayout(new BorderLayout());
             frame_.getContentPane().add(submit_button_, BorderLayout.NORTH);
             frame_.getContentPane().add(ta_, BorderLayout.CENTER);
             frame_.setSize(300,600 );
             frame_.setVisible(true);
             
             xpert.outputRuleList(instruct_list_, ta_);
   }

}