package TUGLaby;

import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.BorderFactory;
import javax.swing.event.*;
import java.lang.Math;
import javax.swing.JLabel;


public class SpeedPanel extends JPanel implements ChangeListener
{

    private static final int FPS_MIN = 0;
    private static final int FPS_MAX = 20;
    private static final int FPS_INIT = 5;
    private static final int FPS_MULT = 1000;
    private static final double FPS_TAU = 7.0;
    private int delay;
    private JSlider speed_;
    private JLabel info_;
    private TUGLabyrinth top;

    public SpeedPanel(TUGLabyrinth top_object_)
    {
        super();
        top=top_object_;

        delay = FPS_INIT;
       setLayout(new GridLayout(0,1));
       speed_ = new JSlider(JSlider.HORIZONTAL,FPS_MIN, FPS_MAX, FPS_INIT);
       speed_.setMajorTickSpacing(10);
       speed_.setMinorTickSpacing(1);
       speed_.setPaintTicks(true);
       speed_.setPaintLabels(true);
       speed_.setBackground(Color.ORANGE);
       speed_.addChangeListener(this);

       info_= new JLabel();
       info_.setText("     0 = Singlestepp");
       this.setBackground(Color.ORANGE);
       this.setBorder(BorderFactory.createTitledBorder("Geschwindigkeit"));

       add(speed_);
       add(info_);

    }
    public int getDelay()
    {
      if(speed_.getValue()==0)
        return 0;
      else if(speed_.getValue()==FPS_MAX)
        return 1;
      else
        return (int)(FPS_MULT*Math.exp(-speed_.getValue()/(FPS_MAX/FPS_TAU)));
    }
    public boolean isSingleStepMode()
    {
      if(speed_.getValue()==0)
        return true;
      else
        return false;
    }

    public void stateChanged(ChangeEvent e)
    {
        JSlider source = (JSlider)e.getSource();
        if (!source.getValueIsAdjusting())
        {
            int fps = (int)source.getValue();
            if (fps == 0)
            {
              if(top.turing_machine_!=null)
              {
               top.turing_machine_.setSpeed(fps); 
               top.turing_machine_.setSleep(true);
               /*try
               {
                top.turing_machine_.runSingleStep();
               }
               catch (InterruptedException ex) 
               {
                System.out.println("Single Stepp Error");
                System.err.println(ex.getMessage());
               }*/
               if(top.stopp_==true)
                top.drawStepButton();
               else
               {
                 top.start_button_.setVisible(true);
                 top.stop_button_.setVisible(false);
                 top.step_button_.setVisible(false);
                 top.stopp_=false;
               }
              }
             info_.setText("     > 0 = weiter"); 
            }
            else
            {
              if(speed_.getValue()==FPS_MAX)
                delay=1;
              else
                delay = (int)(FPS_MULT*Math.exp(-speed_.getValue()/(FPS_MAX/FPS_TAU)));
              if(top.turing_machine_!=null)
                {
                  System.out.println("Speed\n"+delay);
                  top.turing_machine_.setSpeed(delay);
                  top.turing_machine_.setSleep(false);
                  
                  if(top.stopp_==true)
                  {
                    top.drawStopButton();
                    top.turing_machine_.stop(false);
                  }
                  else
                  {
                    top.start_button_.setVisible(true);
                    top.stop_button_.setVisible(false);
                    top.step_button_.setVisible(false);
                    top.stopp_=false;
                  }
                   
                }
              info_.setText("     0 = Singlestepp");
            }
        }
    }
}
