package TUGLaby;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.BorderFactory;
import java.io.StringBufferInputStream;
import java.io.ByteArrayInputStream;
import org.xml.sax.InputSource;

import PrintGame.Action;
import PrintGame.Condition;
import PrintGame.IllegalDirectionException;
import PrintGame.Instruction;
import PrintGame.InstructionList;
import PrintGame.LabyrinthField;
import PrintGame.LevelHandler;
import PrintGame.LoadInstructions;
import PrintGame.Robot;
import PrintGame.TuringMachine;
import PrintGame.LabyrinthMarkAndStateArray;
import PrintGame.SqlCommunicator;
import java.lang.Integer;
/*
 * JApplet.java
 *
 * Changed on 24.09. 2005, 15:53
 */

/**
 * The Top level class
 * @author user
 */
public class TUGLabyrinth extends javax.swing.JApplet implements Runnable {

    private javax.swing.JApplet mainframe_ = this; //?????

    private static final int height = 580;
    private static final int width = 950;
    protected RuleTreePanel rule_tree_panel_;
    private JScrollPane rule_tree_scrollpane_;

    protected MenuePanel menue_panel_;

    private HashMap brick_images_;
    protected JButton start_button_;
    protected JButton stop_button_;
    protected JButton step_button_;
    private String image_folder_;

//     private JLabel status_message_;
    private StatusPanel status_message_;

    protected SpeedPanel speed_panel_;
    private StatisticsPanel statistics_panel_;

    private AktiveRulePanel aktive_rule_panel_;

    protected Thread th_;

//     protected InputSource level_xpert_source_;
protected String level_xpert_source_;

    protected boolean stopp_;
    /**
     * ADDED FROM PrintGame
     * *********************************************************
     */
   // protected final static boolean create_labyrinth_ = false; // Switch, nur
    // derzeit n�ig
    //number of cells in a row and a col
    protected final static int ROWS = 20;
    protected final static int COLS = 20;

    protected static LabyrinthField labyrinth_field_;
    protected static LevelHandler level_handler_;
    protected static Robot robot_;
    protected InstructionList instruct_list_;
    protected TuringMachine turing_machine_;
    protected PrintLabyrinth print_labyrinth_;
    protected String file_name_;

    protected LabyrinthMarkAndStateArray mark_array_;
    protected LabyrinthMarkAndStateArray state_array_;
    /**
     * ADDED FROM PrintGame
     */

    private void AddCurrentProgramToLog()
    {
    	String current_program = "Current program:\n";
        LinkedList listi = rule_tree_panel_.getRuleList();
        for (int i = 0; i < listi.size(); i++)
        {
          Instruction dummy = ((ConditionRulePanel) listi.get(i)).getInstruction();
          current_program += "                                        " + dummy.toString();
        }
        SqlCommunicator.add_log(current_program);
    }
    /** Initializes the applet JApplet
	* Draws the applet and some of its buttons. Adds action listeners.
	* One of the object trees which may help you to understand the source is: Applet->LevelHandler->LoadLabyrinth->LabyrinthField
	*/
    public void init() {
    	// BEGIN OF WINDOW SETUP ****************************************************************
    	SqlCommunicator.add_log("Starting Applet");
    	if (getParameter("logging").equals("true"))
			{
    		SqlCommunicator.activate(true);
				System.out.println("logging == true");
			}
			else
				System.out.println("logging == false");

        mark_array_=new LabyrinthMarkAndStateArray();
        state_array_=new LabyrinthMarkAndStateArray();

        mark_array_.setString("0");
        mark_array_.setString("1");
        mark_array_.setString("2");
        mark_array_.setString("3");

//         state_array_.setString("NONE");
        state_array_.setString("grn");
        state_array_.setString("blau");
        state_array_.setString("rot");
        state_array_.setString("gelb");

        level_xpert_source_=null;

        getContentPane().setLayout(null);
        this.setSize(width, height);

        String abs_filename = getParameter("abs_filename");

				if(abs_filename==null)
				{
        	abs_filename = "Games/Game.xml";
					System.out.println("take default file: "+abs_filename);
				}
        start_button_ = new JButton();
        stop_button_ = new JButton();
        step_button_= new JButton();
        menue_panel_ = new MenuePanel(getCodeBase(),this);


        status_message_= new StatusPanel();
//     		status_message_= new JLabel();

        // Images -> HashMap "brick_images_"
        loadImages();

        aktive_rule_panel_=new AktiveRulePanel(brick_images_ , this);
        rule_tree_panel_ = new RuleTreePanel(brick_images_,this);

        // Initially display 4 Rules - this is done for usablility reasons.
		    for(int i=0;i<4;i++) rule_tree_panel_.addNewRule("ConditionRule", false);

        rule_tree_panel_.setPreferredSize(new Dimension(250, height - 10));
        rule_tree_scrollpane_ = new JScrollPane(rule_tree_panel_);

        print_labyrinth_ = new PrintLabyrinth(brick_images_, robot_, null, this);
        statistics_panel_ = new StatisticsPanel(this);

        speed_panel_= new SpeedPanel(this);


        getContentPane().add(start_button_);
        getContentPane().add(stop_button_);
        getContentPane().add(step_button_);
        getContentPane().add(rule_tree_scrollpane_);
        getContentPane().add(print_labyrinth_);
        getContentPane().add(status_message_);
        getContentPane().add(statistics_panel_);
        getContentPane().add(speed_panel_);
        getContentPane().add(aktive_rule_panel_);

        rule_tree_scrollpane_.setBounds(5, 10, 268, height - 40 + 1);
        print_labyrinth_.setBounds(280, 70, 400, 400);
				print_labyrinth_.setBackground(Color.ORANGE);


        status_message_.setBounds(280,490,400,50);
        status_message_.setBackground(Color.ORANGE);
        status_message_.setVisible(true);


        statistics_panel_.setBounds(687,62,255,150);
        speed_panel_.setBounds(687,230,255,100);
        aktive_rule_panel_.setBounds(687,348,255,125);
        //statistics_.setBorder(BorderFactory.createTitledBorder("Status"));

        //statistics_.setBackground(Color.GREEN);


        URL new_url = null;
        try {
            new_url = new URL(getDocumentBase(), abs_filename);
        } catch (MalformedURLException ex) {
            System.err.println(ex.getMessage());
        }
        this.getContentPane().setBackground(Color.ORANGE);
        file_name_ = new_url.toString(); // "Game.xml", Level-Info

		// END OF WINDOW SETUP ******************************************************************

    drawStopButton();
		drawStartButton();
    drawStepButton();
		drawNewLabyrinth();

    }

   // BEGIN OF START BUTTON  ***************************************************************
   protected void drawStartButton()
        {
        start_button_.setVisible(true);
        stop_button_.setVisible(false);
        step_button_.setVisible(false);
        start_button_.setBounds(735,500, 150, 30);
        start_button_.setBackground(new Color(127,127,127));
        start_button_.setForeground(Color.ORANGE);
        start_button_.setText("Neustart !");

        stopp_=false;

        start_button_.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) { // START BUTTON PRESSED
              System.out.println("\n START BUTTON PRESSED, Rule Tree -->");
              instruct_list_ = new InstructionList();
              LinkedList listi = TUGLabyrinth.this.rule_tree_panel_.getRuleList();

    // ------------------------------------------------------------------------------------------
              for (int i = 0; i < listi.size(); i++) {
                    Instruction dummy = ((ConditionRulePanel) listi.get(i)).getInstruction();
                    instruct_list_.addInstruction(dummy);
//                     System.out.print(dummy);
                    }
    // ------------------------------------------------------------------------------------------
              SqlCommunicator.add_log("Start button pressed");
		    	AddCurrentProgramToLog();
		    	URL logger_url;
		    	String user_id = getParameter("userid");
		    	try
		    	{
		    		logger_url = new URL(getCodeBase(),"logger.php");
		    		SqlCommunicator.flush_log(logger_url, user_id, menue_panel_.getCurrentSelectedLevel());
		    	}
		    	catch(Exception e)
		    	{
		    		System.out.println("Log writing failed! (Could not get code base)");
		    	}
    // ------------------------------------------------------------------------------------------
            labyrinth_field_ = level_handler_.getLabyrinthField();
            drawStopButton();

            String text;
            Integer tmp,tmp2;
            if(th_==null)
              text="1";
            else
            {
              tmp = new Integer(Integer.parseInt(th_.getName()));
              text=Integer.toString(tmp.intValue()+1);
             }
            th_ = new Thread(TUGLabyrinth.this,text);
            System.out.println(th_.getName()+"new Thread");
            th_.start();// => Calls run()
            System.out.println(th_.getName()+"Thread.start()");
            }
        });
      }
   // END OF START BUTTON ***************************************************************

  protected void drawStopButton()
  {
    start_button_.setVisible(false);
    stop_button_.setVisible(true);
    step_button_.setVisible(false);
    stop_button_.setBounds(735,500, 150, 30);
    stop_button_.setBackground(new Color(127,127,127));
    stop_button_.setForeground(Color.ORANGE);
    stop_button_.setText("Stopp !");

    stopp_=true;

    stop_button_.addActionListener(new java.awt.event.ActionListener() {
     public void actionPerformed(java.awt.event.ActionEvent evt)
      {
       if(turing_machine_!=null)
       {
         start_button_.setVisible(true);
         stop_button_.setVisible(false);
         turing_machine_.stop(true);
        }
       }
     });
    }

  protected void drawStepButton()
  {
    start_button_.setVisible(false);
    stop_button_.setVisible(false);
    step_button_.setVisible(true);
    step_button_.setBounds(735,500, 150, 30);
    step_button_.setBackground(new Color(127,127,127));
    step_button_.setForeground(Color.ORANGE);
    step_button_.setText("Schritt!");
    step_button_.addActionListener(new java.awt.event.ActionListener() {
     public void actionPerformed(java.awt.event.ActionEvent evt)
      {
       if(turing_machine_!=null)
       {
        instruct_list_.removeAllInstructions();
        updateRuleTreePanel();
        LinkedList listi = rule_tree_panel_.getRuleList();
        for (int i = 0; i < listi.size(); i++)
              {
                Instruction dummy = ((ConditionRulePanel) listi.get(i)).getInstruction();
                instruct_list_.addInstruction(dummy);
//                     System.out.print(dummy);
              }
          turing_machine_.setInstructionList(instruct_list_);
          turing_machine_.stop(false);
          turing_machine_.setSleep(false);
        }
       }
     });
  }

  public void updateRuleTreePanel()
  {
    if(aktive_rule_panel_.getInstruction()!=null)
    {
      int id=aktive_rule_panel_.getRuleId();
      if(id > 0)
      {
        rule_tree_panel_.updateRule(aktive_rule_panel_.getInstruction(),id);
      }
    }
  }

	/** This methods job is to generate a new labyrinth.
	* It is intended to be called from the action listener of the draw_button_ and from the action listener
	* of the MenuePanel.
	* @author Bernhard Kornberger
	*/
	public void drawNewLabyrinth()
	{
    if (turing_machine_!=null)
       turing_machine_.stop(true);

    start_button_.setVisible(true);
    stop_button_.setVisible(false);
		level_handler_ = new LevelHandler();
    level_handler_.setDocumentBase(getDocumentBase());
		level_handler_.setMarkArray(mark_array_);
    level_handler_.loadGameXmlFile(file_name_);

		menue_panel_.refreshList();

    if(menue_panel_.getCurrentSelectedLevel()==0)
    {
      if(level_xpert_source_!=null)
      {
      InputSource tmp=new InputSource(new StringBufferInputStream(level_xpert_source_));
      level_handler_.loadLevel(tmp);
      }
      else
      System.err.println("Input Source == Null");
    }
    else
      level_handler_.loadLevel(menue_panel_.getCurrentSelectedLevel());

	  labyrinth_field_ = level_handler_.getLabyrinthField();
		robot_ = new Robot();
	  robot_.setPos(labyrinth_field_.getStartpointRow(), labyrinth_field_.getStartpointCol());
	  try
			{
				robot_.setStartDirection(labyrinth_field_.getStartDirection());
			}
			catch (IllegalDirectionException ex)
			{
	            System.err.println(ex.getMessage());
			}

      print_labyrinth_.setLabyrinthField(labyrinth_field_);
			print_labyrinth_.setTUGLabyrinth(this);
 	    print_labyrinth_.setRobot(robot_);
     aktive_rule_panel_.removeAktiveRule();
	    repaint();

//_______________________________Achtung ! ________-1 Anzahl der Startpunkte____________________
      statistics_panel_.setFieldcountDiamondcount(labyrinth_field_.getNumWayCells()-1, labyrinth_field_.getNumDiamonds());
      statistics_panel_.resetPanel();
      status_message_.setNewText("   Marvin-10 programmieren...");
		}



	/**
	* Used to start a new thread and intended to be called from the start button's action listener defined in init()
	*/
    public void run() {
        try
		{
			if(level_handler_.getLabyrinthField()!=null)
			{
				robot_ = new Robot();
        robot_.setPos(labyrinth_field_.getStartpointRow(), labyrinth_field_.getStartpointCol());
        robot_.setStartDirection(labyrinth_field_.getStartDirection());

				// TuringMachine setup
				turing_machine_ = new TuringMachine();
				turing_machine_.setLabyrinthField(labyrinth_field_);
				turing_machine_.setRobot(robot_);
				turing_machine_.setInstructionList(instruct_list_);

				// Put it together, repaint, start!
        print_labyrinth_.setLabyrinthField(labyrinth_field_);
				print_labyrinth_.setTUGLabyrinth(this);
        print_labyrinth_.setRobot(robot_);

        turing_machine_.setStatusPanel(status_message_);
        turing_machine_.setAktiveRulePanel(aktive_rule_panel_);
        String message=turing_machine_.getMessage();
        status_message_.setNewText(message);
        System.out.println(message);
        repaint();
        Thread.sleep(50);
        int delay=speed_panel_.getDelay();
        turing_machine_.setSpeed(delay);
        System.out.println("Speed\n"+delay);
        if(delay==0)
        {
          turing_machine_.setSleep(true);
          turing_machine_.singleStepMode(true);
          drawStepButton();
        }
				turing_machine_.start(print_labyrinth_, statistics_panel_);

        message=turing_machine_.getMessage();
        status_message_.setNewText(message);
        System.out.println(message);

         start_button_.setVisible(true);
         step_button_.setVisible(false);
         stop_button_.setVisible(false);
         stopp_=false;
			}
        } catch (IllegalDirectionException ex) {
            System.err.println(ex.getMessage());
        } catch (InterruptedException ex) {
            System.err.println(ex.getMessage());
        }
    }



    private Image loadImage(String name) {
        ImageIcon icon = null;
        if (image_folder_ == null)
            image_folder_ = "";
        try {
            icon = new ImageIcon(new URL(getCodeBase(), image_folder_ + "/"
                    + name));
            return icon.getImage();
        } catch (MalformedURLException e) {
            System.out.println("Failed to create URL:\n" + e);
            return null;
        }
    }

    private ImageIcon loadIcon(String name) {
        ImageIcon icon = null;
        if (image_folder_ == null)
            image_folder_ = "";
        try {
            icon = new ImageIcon(new URL(getCodeBase(), image_folder_ + "/"
                    + name));
            return icon;
        } catch (MalformedURLException e) {
            System.out.println("Failed to create URL:\n" + e);
            return null;
        }
    }

    /**
     * This method is called from within the init() method to initialize the
     * form. WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void loadImages() {
        brick_images_ = new HashMap();
        // load the images which are display at the brick_rules panel
        image_folder_ = "Images";
        brick_images_.put("CONDITION_DEFAULT", loadImage("images.jpg"));
        brick_images_.put("CONDITION_HOVER", loadImage("images1.jpg"));
        brick_images_.put("ACTION_DEFAULT", loadImage("images2.jpg"));
        brick_images_.put("ACTION_HOVER", loadImage("images3.jpg"));
        brick_images_.put("ARROW_UP", loadImage("arrow_up.gif"));
        brick_images_.put("ARROW_DOWN", loadImage("arrow_down.gif"));
        brick_images_.put("ARROW_LEFT", loadImage("arrow_left.gif"));
        brick_images_.put("ARROW_RIGHT", loadImage("arrow_right.gif"));
        brick_images_.put("FREE_GROUND", loadImage("free_ground.gif"));
        brick_images_.put("WALL_GROUND", loadImage("wall_ground.gif"));

        brick_images_.put("EMPTY_FLOOR", loadImage("floor_empty.gif"));
        brick_images_.put("FLOOR_0", loadImage("floor_0.gif"));
        brick_images_.put("FLOOR_1", loadImage("floor_1.gif"));
        brick_images_.put("FLOOR_2", loadImage("floor_2.gif"));
        brick_images_.put("FLOOR_3", loadImage("floor_3.gif"));
        brick_images_.put("FLOOR_4", loadImage("floor_4.gif"));
        brick_images_.put("X_BUTTON", loadIcon("x_button.gif"));

        brick_images_.put("COND_NONE", loadImage("cond_none.gif"));
        brick_images_.put("COND_GREEN", loadImage("cond_green.gif"));
        brick_images_.put("COND_BLUE", loadImage("cond_blue.gif"));
        brick_images_.put("COND_RED", loadImage("cond_red.gif"));
        brick_images_.put("COND_YELLOW", loadImage("cond_yellow.gif"));
        brick_images_.put("COND_GRAY", loadImage("cond_gray.gif"));

        brick_images_.put("COND_NONE_1", loadImage("cond_none_1.gif"));
        brick_images_.put("COND_GREEN_1", loadImage("cond_green_1.gif"));
        brick_images_.put("COND_BLUE_1", loadImage("cond_blue_1.gif"));
        brick_images_.put("COND_RED_1", loadImage("cond_red_1.gif"));
        brick_images_.put("COND_YELLOW_1", loadImage("cond_yellow_1.gif"));
        brick_images_.put("COND_GRAY_1", loadImage("cond_gray_1.gif"));

        brick_images_.put("LAB_WAY", loadImage("way_3.jpg"));
        brick_images_.put("LAB_WALL", loadImage("way_2.jpg"));

        brick_images_
                .put("LAB_ROBOT_BLANK_UP", loadImage("robot_blank_up.gif"));
        brick_images_.put("LAB_ROBOT_BLANK_RIGHT",
                loadImage("robot_blank_right.gif"));
        brick_images_.put("LAB_ROBOT_BLANK_DOWN",
                loadImage("robot_blank_down.gif"));
        brick_images_.put("LAB_ROBOT_BLANK_LEFT",
                loadImage("robot_blank_left.gif"));

        brick_images_.put("LAB_ROBOT_BLUE_UP", loadImage("robot_blue_up.gif"));
        brick_images_.put("LAB_ROBOT_BLUE_RIGHT",
                loadImage("robot_blue_right.gif"));
        brick_images_.put("LAB_ROBOT_BLUE_DOWN",
                loadImage("robot_blue_down.gif"));
        brick_images_.put("LAB_ROBOT_BLUE_LEFT",
                loadImage("robot_blue_left.gif"));

        brick_images_
                .put("LAB_ROBOT_GREEN_UP", loadImage("robot_green_up.gif"));
        brick_images_.put("LAB_ROBOT_GREEN_RIGHT",
                loadImage("robot_green_right.gif"));
        brick_images_.put("LAB_ROBOT_GREEN_DOWN",
                loadImage("robot_green_down.gif"));
        brick_images_.put("LAB_ROBOT_GREEN_LEFT",
                loadImage("robot_green_left.gif"));

        brick_images_.put("LAB_ROBOT_RED_UP", loadImage("robot_red_up.gif"));
        brick_images_.put("LAB_ROBOT_RED_RIGHT",
                loadImage("robot_red_right.gif"));
        brick_images_.put("LAB_ROBOT_RED_DOWN",
                loadImage("robot_red_down.gif"));
        brick_images_.put("LAB_ROBOT_RED_LEFT",
                loadImage("robot_red_left.gif"));

        brick_images_.put("LAB_ROBOT_YELLOW_UP", loadImage("robot_yellow_up.gif"));
        brick_images_.put("LAB_ROBOT_YELLOW_RIGHT",
                loadImage("robot_yellow_right.gif"));
        brick_images_.put("LAB_ROBOT_YELLOW_DOWN",
                loadImage("robot_yellow_down.gif"));
        brick_images_.put("LAB_ROBOT_YELLOW_LEFT",
                loadImage("robot_yellow_left.gif"));

        brick_images_.put("LAB_ROBOT_GRAY_UP", loadImage("robot_gray_up.gif"));
        brick_images_.put("LAB_ROBOT_GRAY_RIGHT", loadImage("robot_gray_right.gif"));
        brick_images_.put("LAB_ROBOT_GRAY_DOWN", loadImage("robot_gray_down.gif"));
        brick_images_.put("LAB_ROBOT_GRAY_LEFT", loadImage("robot_gray_left.gif"));

        brick_images_.put("LAB_CELLMARK0", loadImage("lab_cellmark0.gif"));
        brick_images_.put("LAB_CELLMARK1", loadImage("lab_cellmark1.gif"));
        brick_images_.put("LAB_CELLMARK2", loadImage("lab_cellmark2.gif"));
        brick_images_.put("LAB_CELLMARK3", loadImage("lab_cellmark3.gif"));
        brick_images_.put("LAB_CELLMARK", loadImage("lab_cellmark.gif"));

        brick_images_.put("LAB_DIAMOND", loadImage("diamond.gif"));

    }
}
